# Spatial Temporal Graph Convolutional Networks for Skeleton-Based Action Recognition(STGCN)

## 模型介绍
人体骨骼的动力学为人类动作识别传递了重要信息。传统的骨架建模方法通常依赖于手工制作的部分或遍历规则，因此导致表达能力有限，难以泛化。在这项工作中，我们提出了一种新的动态骨架模型，称为时空图卷积网络（ST-GCN），它通过从数据中自动学习空间和时间模式，超越了以前方法的限制。该公式不仅具有更大的表达能力，而且具有更强的泛化能力。在Kinetics和NTU-RGBD这两个大型数据集上，它比主流方法有了实质性的改进。
## 模型结构
ST-GCN模型由九层时空图卷积组成。前三层输出64通道数，中间三层输出128通道，最后三层输出256层通道数。一共有9个时间卷积核，在每一个ST-GCN使用残差链接，使用dropout进行特征正则化处理，将一半的神经元进行dropout处理。第4、7层的时间卷积层设置为poling层。最后将输出的256个通道数的输出进行全局pooling,并由softmax进行分类。

![img](https://user-images.githubusercontent.com/34324155/142995893-d6618728-072c-46e1-b276-9b88cf21a01c.png)

## 数据集
有关数据集的基本信息，请参阅官方网站(https://www.deepmind.com/open-source/kinetics)。脚本可用于准备kinetics400, kinetics600, kinetics700.。要准备不同版本的动力学，您需要将以下示例中的${DATASET}替换为特定的数据集名称。数据集名称的选择是kinetics400、kinetics600和kinetics700。在开始之前，请确保目录位于$MMACTION2/tools/data/${DATASET}/。在本测试中使用的是kinetics400数据集。

数据集处理方法请参考tools/data/kinetics自行处理，也可通过下面链接下载使用。

链接：https://pan.baidu.com/s/1LWMCki18G15Pkvjl9-gwgw?pwd=xlpi 提取码：xlpi 

## STGCN训练
### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取的训练以及推理的docker镜像：
* 训练镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10.1-py37-latest

  ```
  mmaction2 安装：
  cd mmaction2-0.24.1
  pip3 install -e .
  ```
### 训练
训练命令：

    export HIP_VISIBLE_DEVICES=0
    export ROCBLAS_ATOMICS_MOD=1
    export MIOPEN_FIND_MODE=1
    python3 tools/train.py configs/skeleton/stgcn/stgcn_80e_ntu60_xsub_keypoint.py --seed 0 --deterministic --validate --gpu-ids 0

## 准确率数据
测试数据使用的是[kinetics400](https://github.com/sirius-ai/LPRNet_Pytorch/tree/master/data/test)，使用的加速卡是DCU Z100L。

| 卡数 | Top5_acc |
| :------: |:------: |
| 1 | 1.0000 |

### 历史版本

https://developer.hpccube.com/codes/modelzoo/stgcn

### 参考

https://github.com/open-mmlab/mmdetection
