## Yi-1.5-6B

## 论文

`Yi: Open Foundation Models by 01.AI`

- [https://arxiv.org/abs/2403.04652]
## 算法原理

Yi-1.5是一个 decoder-only 的 transformer 模型，使用 SwiGLU激活函数、GQA、RoPE等是Yi的升级版本，它在Yi的基础上进行了持续预训练，使用了500B（即500十亿）个高质量语料库的token，并且在300万个多样化的微调样本上进行了微调。
与Yi相比，Yi-1.5在编程、数学、推理和指令遵循能力方面表现更强，同时仍然保持了在语言理解、常识推理和阅读理解方面的卓越能力。
<div align=center>
    <img src="./doc/yi.png"/>
</div>

## 环境配置

### Docker（方法一）

此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取 docker 镜像的地址与使用步骤

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it --shm-size=1024G -v /parastor/home/Yi-1.5-pytorch:/home/Yi-1.5-pytorch -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name Yi-1.5  <your IMAGE ID> bash  # <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
cd /home/Yi-1.5-pytorch
pip install -r requirement.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
# deepspeed、bitsandbytes可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+das1.0+gita724046.abi0.dtk2404.torch2.1.0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.42.0-py3-none-any.whl

```

### Dockerfile（方法二）

此处提供 dockerfile 的使用方法

```
docker build  -t Yi-1.5-df:latest .
docker run -it --shm-size=1024G -v /parastor/home/Yi-1.5-pytorch:/home/Yi-1.5-pytorch -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name Yi-1.5  Yi-1.5-df  bash
pip install -r requirement.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
# deepspeed、bitsandbytes可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+das1.0+gita724046.abi0.dtk2404.torch2.1.0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.42.0-py3-none-any.whl

```

### Anaconda（方法三）

此处提供本地配置、编译的详细步骤，例如：

关于本项目 DCU 显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk23.04
python：python3.10
torch: 2.1.0
torchvision: 0.16.0
deepspeed:0.12.3
bitsandbytes: 0.42.0
triton:2.1.0
```

`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照 requirements.txt 安装：

```
pip install -r requirements.txt
```

## 数据集
使用alpaca_en.json数据集，已经包含在finetune/data目录中，具体文件为alpaca_en_demo.json
项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：

```
 ── data
    ├── alpaca_en_demo.json.json
    └── alpaca_zh_demo.json.json
```
## 模型下载
Yi-1.5-6B-chat下载地址(https://hf-mirror.com/01-ai/Yi-1.5-6B-Chat)

[快速下载通道](http://113.200.138.88:18080/aimodels/01-ai/Yi-1.5-6B-Chat)
## 训练

一般情况下，ModelZoo 上的项目提供单机训练的启动方法即可，单机单卡、单机多卡至少提供其一训练方法。

### 单机单卡

```
cd finetune
sh single_node.sh
```
### 单机多卡

```
cd finetune
sh multi_node.sh
```


## 推理

```
cd inference
sh 6B_single_dcu.sh
```

## result

使用的加速卡:2张 DCU-K100-64G

<div align=center>
    <img src="./doc/training_loss.png"/>
</div>

### 精度
测试数据：[alpaca_en_demo.json]，使用的加速卡:K100-64G,2卡训练。

根据测试结果情况填写表格：
| device | train_loss | 
| :------: | :------: | 
| DCU-K100 | 0.7647 | 
| GPU-A800 | 0.7651 | 

## 应用场景

### 算法类别

对话问答

### 热点应用行业

`科研,教育,政府,金融`


## 源码仓库及问题反馈

- https://github.com/01-ai/Yi-1.5

## 参考资料

- https://github.com/hiyouga/LLaMA-Factory/tree/main
- https://github.com/01-ai/Yi-1.5
- (https://huggingface.co/01-ai)

