# magic_pdf

## 一、安装pdf文档解析

### 以下演示在223节点安装pdf解析模块（可以直接使用镜像：1177ea7959ce）

### 1、下载本项目

`git clone http://developer.sourcefind.cn/codes/zhiAn123/magic_pdf.git`

#### 安装依赖包

【提供的镜像暂未支持doclayout-YoLo模型，如需使用，请下载最新的库文件】

`pip install -U magic-pdf[full] --extra-index-url https://wheels.myhloli.com -i https://mirrors.aliyun.com/pypi/simple`

安装完毕后，请卸载需要使用光源库文件（torch、vllm等），以及nvdia-cuda类似不支持的库文件

### 2、下载需要的模型库


下载qwen模型：[快速下载通道](http://113.200.138.88:18080/aimodels/qwen/Qwen2-VL-7B-Instruct.git)

下载PDF解析需要的模型： [快速下载通道](http://113.200.138.88:18080/aimodels/opendatalab/PDF-Extract-Kit)

`pip install modelscope`

`wget https://gitee.com/myhloli/MinerU/raw/master/scripts/download_models.py -O download_models.py`

`python download_models.py`

【注意，download_models.py执行完毕，会把模型文件以及layout文件安装在/root/.cache下】

### 3、安装需要的依赖库

#### 进入主目录（以下内容都在主目录下进行）

`cd magic_pdf`

执行本地源码安装

#### pip install -e .

`pip install qwen_vl_utils`

`pip install easyofd`


在国产计算卡运行时，下载已适配的[paddle](https://cancon.hpccube.com:65024/4/main/paddle)可以大幅提高文本解析速度（根据自身容器，自行选择已适配paddle的版本）

### 4、修改magic-pdf.json
在第二步执行download_models.py文件后，会在/root文件夹下，下载名为magic-pdf.json文件，修改文件内容

<div align=center>
    <img src="doc/image (9).png"/>
</div>

"models-dir":"[模型路径]" 路径指向**第二步下载的pdf解析模型路径下的models文件夹**

<div align=center>
    <img src="doc/image (10).png"/>
</div>

### 5、配置config.ini中的路由地址

vim magic_pdf/config.ini

默认如下：

<div align=center>
    <img src="doc/image13.png"/>
</div>

根据需要，自行配置路由地址

### 6、启动qwen-ocr模块：

#### 6.1、启动非vllm的qwen-ocr模块：

修改magic_pdf/magic_pdf/dict2md/ocr_server.py文件中模型路径地址

<div align=center>
    <img src="doc/image11.png"/>
</div>

##### qwen-ocr服务启动代码：

`python magic_pdf/dict2md/ocr_server.py`

默认使用0号DCU卡 ，可以通过--dcu_id 指定卡，-c 指定qwen模型地址，--config_path 指定config.ini路径

qwen-ocr模块启动成功：
<div align=center>
    <img src="doc/image (5).png"/>
</div>

#### 6.2、 启动vllm的qwen-ocr模块：

1、修改magic_pdf/magic_pdf/dict2md/ocr_vllm_server.py文件中模型路径地址
2、修改magic_pdf/magic_pdf/pre_proc/cut_image.py、magic_pdf/magic_pdf/tools/pdf_server.py、magic_pdf/magic_pdf/parse/ofd_parse.py文件
将注释更改如下
<div align=center>
    <img src="doc/image_vllm.png"/>
</div>

##### qwen-ocr-vllm服务启动代码：

`CUDA_VISIBLE_DEVICES=0 python magic_pdf/dict2md/ocr_vllm_server.py`

默认使用0号DCU卡，-c 指定qwen模型地址，--config_path 指定config.ini路径 


qwen-ocr模块启动成功：
<div align=center>
    <img src="doc/image (5).png"/>
</div>


### 7、启动pdf-server解析服务：

#### pdf-server解析服务启动代码：

`python magic_pdf/tools/pdf_server.py`

默认使用0号DCU卡 ，可以通过--dcu_id 指定卡，--config_path 指定config.ini路径

<div align=center>
    <img src="doc/image (6).png"/>
</div>

启动成功：
<div align=center>
    <img src="doc/image (7).png"/>
</div>

### 8、解析pdf

`python magic_pdf/parse/common_parse.py -p [文件/目录 路径] -o [输出地址]`

-p指定pdf路径，-o指定输出路径 --config_path 指定config.ini路径 

<div align=center>
    <img src="doc/image12.png"/>
</div>

<div align=center>
    <img src="doc/image (8).png"/>
</div>

## 二、安装ofd文档解析

`1、pip install easyofd`

2、安装需要的字体文件

查看容器内的字体：

`fc-list`

请配置magic_pdf/tools/font_tools.py文件，配置字体路径

<div align=center>
    <img src="doc/font.png"/>
</div>

若代码执行过程中报错，字体未找到
<div align=center>
    <img src="doc/fonts.png"/>
</div>

请执行：

`fc-list #查找字体文件`

`vim magic_pdf/tools/font_tools.py`

如果fc-list未找到需要的字体文件，请向容器内添加字体后，再修改font_tools.py文件






