#!/usr/bin/env python
#-*- coding: utf-8 -*-
#PROJECT_NAME: D:\code\easyofd\easyofd
#CREATE_TIME: 2023-07-27 
#E_MAIL: renoyuan@foxmail.com
#AUTHOR: reno 
#NOTE: 字体处理  
import time
import re
import json
import base64
import zipfile
import os
import shutil
import logging
from io import BytesIO, StringIO
import string
from uuid import uuid1
import random
import traceback
import logging


import tempfile
import xmltodict
from fontTools.ttLib import TTFont as ttLib_TTFont
from fontTools.pens.basePen import BasePen
from reportlab.graphics.shapes import Path
from reportlab.lib import colors
from reportlab.graphics import renderPM
from reportlab.graphics.shapes import Group, Drawing, scale
from reportlab import platypus
from reportlab.lib.pagesizes import letter, A4
from reportlab.lib.units import mm,inch
from reportlab.platypus import SimpleDocTemplate, Image
from reportlab.lib.utils import ImageReader
from reportlab.pdfgen import canvas
from reportlab.pdfbase import pdfmetrics
from reportlab.pdfbase.cidfonts import UnicodeCIDFont
from reportlab.pdfbase.ttfonts import TTFont
from concurrent.futures import ThreadPoolExecutor
import threading
import multiprocessing
import PIL


from reportlab.lib.fonts import _tt2ps_map 
from reportlab.lib.fonts import _family_alias 

from loguru import logger

FONTS = ['宋体',"SWPMEH+SimSun",'SimSun','KaiTi','楷体','等线','仿宋',"STKAITI","SWLCQE+KaiTi",
         'Courier New','STSong-Light',"CourierNew","SWANVV+CourierNewPSMT",
         "CourierNewPSMT","BWSimKai","hei","黑体","SimHei","SWDKON+SimSun",
         "SWCRMF+CourierNewPSMT","SWHGME+KaiTi",'微软雅黑','隶书']

FONTS_ttf = [{'宋体':'simsun.ttc'},{'SimSun':'simsun.ttc'},{'KaiTi':'simkai.ttf'},{'楷体':'simkai.ttf'},
{'STKAITI':'STKAITI.TTF'},{'hei':'simhei.ttf'},{'STXihei':'simhei.ttf'},{'黑体':'simhei.ttf'},
{'华文细黑':'STXIHEI.TTF'},{'SimHei':'simhei.ttf'},{'Courier New':'cour.ttf'},
{'华文琥珀':'STHUPO.TTF'},{'华文彩云':'STCAIYUN.TTF'},{'等线':"Dengl.ttf"},{'仿宋':'simfang.ttf'},
{'隶书':'SIMLI.TTF'},{'微软雅黑':'msyhbd.ttc'},{'微软雅黑':'msyh.ttc'}]

path_prefix = "/usr/share/fonts/ziti2/"

# 批量注册字体
for font in FONTS_ttf:
    for font_name, file_name in font.items():
        try:
            if 'usr' in file_name:
                font_path = file_name
            else:
                font_path = os.path.join(path_prefix, file_name)
            pdfmetrics.registerFont(TTFont(font_name, font_path))
        except Exception as e:
            logger.error(f"无法注册字体 {font_name}: {e}")

class FontTool(object):
    FONTS = FONTS
    
    def __init__(self):
        # 初始支持字体
        # 字体检测
        pass
    
    def font_check(self):
        logger.info("f{_tt2ps_map}")
        logger.info("f{_family_alias}")
        
        for font in self.FONTS:
            if font in _tt2ps_map.values():
                logger.info(f"已注册{font}")
            else:
                logger.warning(f"-{font}-未注册可能导致写入失败")
                 
        
        
    def register_font(self,file_name,FontName,font_b64):
        
        if font_b64:
            
            file_name = os.path.split(file_name)
            # logger.error(f"file_name:{file_name}")
            # logger.info(f"file_name:{file_name}")
            if isinstance(file_name, (tuple, list)):
                    file_name = file_name[1]
            if not FontName:
                FontName = file_name.split(".")[0]
            try:
                with open(file_name, "wb") as f:
                    f.write(base64.b64decode(font_b64))
                # print("FontName", FontName, "file_name", file_name)
                pdfmetrics.registerFont(TTFont(FontName, file_name))
                self.FONTS.append(FontName)
                
            except Exception as e:
                traceback.print_exc()
                logger.error(f"register_font_error:\n{e} \n 包含不支持解析字体格式")
            
            finally:
                
                if os.path.exists(file_name):
                        os.remove(file_name)
