# InternLM-Math

## 论文

`InternLM-Math: Open Math Large Language Models Toward Verifiable Reasoning`

- [https://arxiv.org/abs/2402.06332]
## 算法原理

InternLM-Math是基于InternLM2-Base模型进行数学预训练得到的大型语言模型。融合了链式推理、奖励建模、数据增强和形式推理等多种能力，不仅可以解决数学问题，还可以验证推理过程的正确性。


## 环境配置

### Docker（方法一）

此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取 docker 镜像的地址与使用步骤

```
docker pull xxx
docker run -it --shm-size=1024G -v /parastor/home/internlm-math-pytorch:/home/internlm-math-pytorch -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name internlm-math  <your IMAGE ID> bash  # <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
cd /home/internlm-math-pytorch
pip install -r requirement.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
# deepspeed、bitsandbytes可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+das1.0+gita724046.abi0.dtk2404.torch2.1.0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.42.0-py3-none-any.whl

```

### Dockerfile（方法二）

此处提供 dockerfile 的使用方法

```
docker build  -t internlm-math-df:latest .
docker run -it --shm-size=1024G -v /parastor/home/internlm-math-pytorch:/home/internlm-math-pytorch -v /opt/hyhal:/opt/hyhal --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name internlm-math  internlm-math-df  bash
pip install -r requirement.txt -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
# deepspeed、bitsandbytes可从whl.zip文件里获取安装：
pip install deepspeed-0.12.3+das1.0+gita724046.abi0.dtk2404.torch2.1.0-cp310-cp310-manylinux2014_x86_64.whl
pip install bitsandbytes-0.42.0-py3-none-any.whl

```

### Anaconda（方法三）

此处提供本地配置、编译的详细步骤，例如：

关于本项目 DCU 显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk23.04
python：python3.10
torch: 2.1.0
torchvision: 0.16.0
deepspeed:0.12.3
bitsandbytes: 0.42.0
triton:2.1.0
```

`Tips：以上dtk驱动、python、paddle等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照 requirements.txt 安装：

```
pip install -r requirements.txt
```

## 数据集
使用alpaca_en.json数据集，已经包含在data目录中，具体文件为alpaca_en_demo.json
项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：

```
 ── data
    ├── alpaca_en_demo.json.json
    └── alpaca_zh_demo.json.json
```

## 训练

一般情况下，ModelZoo 上的项目提供单机训练的启动方法即可，单机单卡、单机多卡至少提供其一训练方法。

### 单机单卡

```
cd fintune
sh single_dcu_finetune_lora.sh
```
### 单机多卡

```
sh multi_node.sh
```


## 推理

```
cd examples/inference
sh single_node.sh
```

## result

使用的加速卡:2张 DCU-K100-64G

<div align=center>
    <img src="./doc/training_loss.png"/>
</div>

### 精度
测试数据：[alpaca_en_demo.json]，使用的加速卡:K100-64G,2卡训练。

根据测试结果情况填写表格：
| device | train_loss | 
| :------: | :------: | 
| DCU-K100 | 1.0941 | 
| GPU-A800 | 1.0944 | 

使用opencompass(https://github.com/open-compass/opencompass)得到的测试结果对比
<div align=center>
    <img src="./doc/result.png"/>
</div>
## 应用场景

### 算法类别

数学推理

### 热点应用行业

`科研,教育,金融`


## 源码仓库及问题反馈

- https://github.com/InternLM/InternLM-Math

## 参考资料

- https://github.com/hiyouga/LLaMA-Factory/tree/main
- https://github.com/InternLM/InternLM-Math
- https://hf-mirror.com/internlm/internlm2-math-7b

