# DeePKS-kit(Deep Kohn-Sham)

# 模型介绍
DeePKS-kit是一个为量子化学系统生成精确能量泛函的程序，DeePKS通过机器学习对于低精度的DFT泛函进行优化，利用神经网络修正项去学习基线泛函（低精度、低成本）与目标第一性原理方法（高精度、高成本）计算得出的能量与力的差值。

# 模型结构

DeePKS-kit一端与PyTorch接口，另一端与PySCF接口，PySCF是一个从头算计算化学程序，为量子化学代码开发和计算提供了一个简单、轻量级、高效的平台。DeePKS-kit支持作者之前开发的DeePHF和DeePKS方法。此外，它还提供了一定的灵活性，例如，修改模型结构，改变训练方案，接口其他量子化学包等。DeePKS-kit由三个主要模块组成，处理以下任务:(1)使用预先计算的描述符和标签训练(微扰)神经网络(NN)能量函数;(2)利用所提供的能量泛函求解给定系统的自洽场方程;(3)通过迭代调用任务(1)和(2)来学习自一致的能量函数。

![](./assets/deepks-kit.png)

DeePKS-kit架构示意图及工作流程如上图，上图说明了整个迭代学习过程的主要步骤。其中，左下是神经网络(NN)能量函数的训练。描述符从给定的分子轨道计算，并用作神经网络模型的输入。随机梯度下降(SGD)训练是使用PyTorch库实现的。右下是求解广义Kohn-Sham自洽场(SCF)方程。从训练好的神经网络泛函中计算XC电位。求解器是作为PySCF库的一个新类实现的。DeePKS-kit还提供了一个用户友好的界面，将上述模块与一些辅助功能组合成一个命令行工具。其中包含五个子命令： 
- `train`: 训练基于神经网络的后高频能量泛函模型
- `test`: 使用给定数据测试后高频模型并显示统计数据
- `scf`: 使用给定的能量模型运行自洽场计算
- `stats`: 收集和打印云函数的统计结果
- `iterate`: 通过组合上面的四个命令来迭代训练自洽模型

## 环境配置
参考[github链接](https://github.com/deepmodeling/deepks-kit/blob/master/requirements.txt) 

DTK版本为22.10 python版本3.7 torch版本1.10.0 pyscf版本2.2.1

## 性能和准确率数据

DCU测试平台：Z100
NVIDIA测试平台：A800

**1)收敛性测试**

Deepks的输出结果文件为test.out文件，默认运行的epoch数为10000，从左到右输出的指标分别是训练步骤、训练损失、验证损失、学习率、训练时间、验证时间。其中截取了最后的epoch部分的数值，其中看DCU和A800最后的结果基本一致。


[DCU文件信息]


![](./assets/deepks-1.png)

![](./assets/deepks-2.png)


![](./assets/deepks-3.png)


![](./assets/deepks-4.png)


[A800的文件输出信息]


![](./assets/deepks-5.png)


![](./assets/deepks-6.png)


![](./assets/deepks-7.png)


![](./assets/deepks-8.png)


整体收敛趋势如下图所示，依次为DCU和GPU。


![](./assets/deepks-9.png)


![](./assets/deepks-10.png)


预测值与实际值对照如下，依次为DCU和GPU。


![](./assets/deepks-11.png)


![](./assets/deepks-12.png)


**2)性能测试**


具体性能对比如下表：


|        || DCU | GPU |
| ------ | ------| ------ |
|总训练用时/s|| 23.87 | 27.36 |
|每100epoch用时/s|| 2.38 | 2.73 |
|每100epoch测试/s|| 0.44 | 2.43 |


## 源码仓库及问题反馈

https://github.com/deepmodeling/deepks-kit

## 参考
[1] Chen, Y., Zhang, L., Wang, H. and E, W.,2023. DeePKS-kit: A package for developing machine learning-based chemically accurate energy and density functional models, Computer Physics Communications, 282, 108520. https://doi.org/10.1016/j.cpc.2022.108520.
