/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CUstream_st {
    _unused: [u8; 0],
}
pub type cudaStream_t = *mut CUstream_st;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum libraryPropertyType_t {
    MAJOR_VERSION = 0,
    MINOR_VERSION = 1,
    PATCH_LEVEL = 2,
}
pub use self::libraryPropertyType_t as libraryPropertyType;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnContext {
    _unused: [u8; 0],
}
pub type cudnnHandle_t = *mut cudnnContext;
extern "C" {
    pub fn cudnnGetVersion() -> usize;
}
extern "C" {
    pub fn cudnnGetCudartVersion() -> usize;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnStatus_t {
    CUDNN_STATUS_SUCCESS = 0,
    CUDNN_STATUS_NOT_INITIALIZED = 1,
    CUDNN_STATUS_ALLOC_FAILED = 2,
    CUDNN_STATUS_BAD_PARAM = 3,
    CUDNN_STATUS_INTERNAL_ERROR = 4,
    CUDNN_STATUS_INVALID_VALUE = 5,
    CUDNN_STATUS_ARCH_MISMATCH = 6,
    CUDNN_STATUS_MAPPING_ERROR = 7,
    CUDNN_STATUS_EXECUTION_FAILED = 8,
    CUDNN_STATUS_NOT_SUPPORTED = 9,
    CUDNN_STATUS_LICENSE_ERROR = 10,
    CUDNN_STATUS_RUNTIME_PREREQUISITE_MISSING = 11,
    CUDNN_STATUS_RUNTIME_IN_PROGRESS = 12,
    CUDNN_STATUS_RUNTIME_FP_OVERFLOW = 13,
    CUDNN_STATUS_VERSION_MISMATCH = 14,
}
extern "C" {
    pub fn cudnnGetErrorString(status: cudnnStatus_t) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRuntimeTag_t {
    _unused: [u8; 0],
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnErrQueryMode_t {
    CUDNN_ERRQUERY_RAWCODE = 0,
    CUDNN_ERRQUERY_NONBLOCKING = 1,
    CUDNN_ERRQUERY_BLOCKING = 2,
}
extern "C" {
    pub fn cudnnQueryRuntimeError(
        handle: cudnnHandle_t,
        rstatus: *mut cudnnStatus_t,
        mode: cudnnErrQueryMode_t,
        tag: *mut cudnnRuntimeTag_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetProperty(
        type_: libraryPropertyType,
        value: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreate(handle: *mut cudnnHandle_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroy(handle: cudnnHandle_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetStream(handle: cudnnHandle_t, streamId: cudaStream_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetStream(handle: cudnnHandle_t, streamId: *mut cudaStream_t) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnTensorStruct {
    _unused: [u8; 0],
}
pub type cudnnTensorDescriptor_t = *mut cudnnTensorStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnPoolingStruct {
    _unused: [u8; 0],
}
pub type cudnnPoolingDescriptor_t = *mut cudnnPoolingStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFilterStruct {
    _unused: [u8; 0],
}
pub type cudnnFilterDescriptor_t = *mut cudnnFilterStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnLRNStruct {
    _unused: [u8; 0],
}
pub type cudnnLRNDescriptor_t = *mut cudnnLRNStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnActivationStruct {
    _unused: [u8; 0],
}
pub type cudnnActivationDescriptor_t = *mut cudnnActivationStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnSpatialTransformerStruct {
    _unused: [u8; 0],
}
pub type cudnnSpatialTransformerDescriptor_t = *mut cudnnSpatialTransformerStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnOpTensorStruct {
    _unused: [u8; 0],
}
pub type cudnnOpTensorDescriptor_t = *mut cudnnOpTensorStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnReduceTensorStruct {
    _unused: [u8; 0],
}
pub type cudnnReduceTensorDescriptor_t = *mut cudnnReduceTensorStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnCTCLossStruct {
    _unused: [u8; 0],
}
pub type cudnnCTCLossDescriptor_t = *mut cudnnCTCLossStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnTensorTransformStruct {
    _unused: [u8; 0],
}
pub type cudnnTensorTransformDescriptor_t = *mut cudnnTensorTransformStruct;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDataType_t {
    CUDNN_DATA_FLOAT = 0,
    CUDNN_DATA_DOUBLE = 1,
    CUDNN_DATA_HALF = 2,
    CUDNN_DATA_INT8 = 3,
    CUDNN_DATA_INT32 = 4,
    CUDNN_DATA_INT8x4 = 5,
    CUDNN_DATA_UINT8 = 6,
    CUDNN_DATA_UINT8x4 = 7,
    CUDNN_DATA_INT8x32 = 8,
    CUDNN_DATA_BFLOAT16 = 9,
    CUDNN_DATA_INT64 = 10,
    CUDNN_DATA_BOOLEAN = 11,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnMathType_t {
    CUDNN_DEFAULT_MATH = 0,
    CUDNN_TENSOR_OP_MATH = 1,
    CUDNN_TENSOR_OP_MATH_ALLOW_CONVERSION = 2,
    CUDNN_FMA_MATH = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNanPropagation_t {
    CUDNN_NOT_PROPAGATE_NAN = 0,
    CUDNN_PROPAGATE_NAN = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDeterminism_t {
    CUDNN_NON_DETERMINISTIC = 0,
    CUDNN_DETERMINISTIC = 1,
}
extern "C" {
    pub fn cudnnCreateTensorDescriptor(tensorDesc: *mut cudnnTensorDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnTensorFormat_t {
    CUDNN_TENSOR_NCHW = 0,
    CUDNN_TENSOR_NHWC = 1,
    CUDNN_TENSOR_NCHW_VECT_C = 2,
}
extern "C" {
    pub fn cudnnSetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        n: ::std::os::raw::c_int,
        c: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensor4dDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        n: ::std::os::raw::c_int,
        c: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
        nStride: ::std::os::raw::c_int,
        cStride: ::std::os::raw::c_int,
        hStride: ::std::os::raw::c_int,
        wStride: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensor4dDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: *mut cudnnDataType_t,
        n: *mut ::std::os::raw::c_int,
        c: *mut ::std::os::raw::c_int,
        h: *mut ::std::os::raw::c_int,
        w: *mut ::std::os::raw::c_int,
        nStride: *mut ::std::os::raw::c_int,
        cStride: *mut ::std::os::raw::c_int,
        hStride: *mut ::std::os::raw::c_int,
        wStride: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::std::os::raw::c_int,
        dimA: *const ::std::os::raw::c_int,
        strideA: *const ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensorNdDescriptorEx(
        tensorDesc: cudnnTensorDescriptor_t,
        format: cudnnTensorFormat_t,
        dataType: cudnnDataType_t,
        nbDims: ::std::os::raw::c_int,
        dimA: *const ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensorNdDescriptor(
        tensorDesc: cudnnTensorDescriptor_t,
        nbDimsRequested: ::std::os::raw::c_int,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::std::os::raw::c_int,
        dimA: *mut ::std::os::raw::c_int,
        strideA: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensorSizeInBytes(
        tensorDesc: cudnnTensorDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyTensorDescriptor(tensorDesc: cudnnTensorDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFoldingDirection_t {
    CUDNN_TRANSFORM_FOLD = 0,
    CUDNN_TRANSFORM_UNFOLD = 1,
}
extern "C" {
    pub fn cudnnInitTransformDest(
        transformDesc: cudnnTensorTransformDescriptor_t,
        srcDesc: cudnnTensorDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        destSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateTensorTransformDescriptor(
        transformDesc: *mut cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDims: u32,
        destFormat: cudnnTensorFormat_t,
        padBeforeA: *const i32,
        padAfterA: *const i32,
        foldA: *const u32,
        direction: cudnnFoldingDirection_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
        nbDimsRequested: u32,
        destFormat: *mut cudnnTensorFormat_t,
        padBeforeA: *mut i32,
        padAfterA: *mut i32,
        foldA: *mut u32,
        direction: *mut cudnnFoldingDirection_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyTensorTransformDescriptor(
        transformDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnTransformTensor(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnTransformTensorEx(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        srcDesc: cudnnTensorDescriptor_t,
        srcData: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        destDesc: cudnnTensorDescriptor_t,
        destData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnAddTensor(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnOpTensorOp_t {
    CUDNN_OP_TENSOR_ADD = 0,
    CUDNN_OP_TENSOR_MUL = 1,
    CUDNN_OP_TENSOR_MIN = 2,
    CUDNN_OP_TENSOR_MAX = 3,
    CUDNN_OP_TENSOR_SQRT = 4,
    CUDNN_OP_TENSOR_NOT = 5,
}
extern "C" {
    pub fn cudnnCreateOpTensorDescriptor(
        opTensorDesc: *mut cudnnOpTensorDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: cudnnOpTensorOp_t,
        opTensorCompType: cudnnDataType_t,
        opTensorNanOpt: cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetOpTensorDescriptor(
        opTensorDesc: cudnnOpTensorDescriptor_t,
        opTensorOp: *mut cudnnOpTensorOp_t,
        opTensorCompType: *mut cudnnDataType_t,
        opTensorNanOpt: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyOpTensorDescriptor(opTensorDesc: cudnnOpTensorDescriptor_t)
        -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnOpTensor(
        handle: cudnnHandle_t,
        opTensorDesc: cudnnOpTensorDescriptor_t,
        alpha1: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        alpha2: *const ::core::ffi::c_void,
        bDesc: cudnnTensorDescriptor_t,
        B: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnReduceTensorOp_t {
    CUDNN_REDUCE_TENSOR_ADD = 0,
    CUDNN_REDUCE_TENSOR_MUL = 1,
    CUDNN_REDUCE_TENSOR_MIN = 2,
    CUDNN_REDUCE_TENSOR_MAX = 3,
    CUDNN_REDUCE_TENSOR_AMAX = 4,
    CUDNN_REDUCE_TENSOR_AVG = 5,
    CUDNN_REDUCE_TENSOR_NORM1 = 6,
    CUDNN_REDUCE_TENSOR_NORM2 = 7,
    CUDNN_REDUCE_TENSOR_MUL_NO_ZEROS = 8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnReduceTensorIndices_t {
    CUDNN_REDUCE_TENSOR_NO_INDICES = 0,
    CUDNN_REDUCE_TENSOR_FLATTENED_INDICES = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnIndicesType_t {
    CUDNN_32BIT_INDICES = 0,
    CUDNN_64BIT_INDICES = 1,
    CUDNN_16BIT_INDICES = 2,
    CUDNN_8BIT_INDICES = 3,
}
extern "C" {
    pub fn cudnnCreateReduceTensorDescriptor(
        reduceTensorDesc: *mut cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: cudnnReduceTensorOp_t,
        reduceTensorCompType: cudnnDataType_t,
        reduceTensorNanOpt: cudnnNanPropagation_t,
        reduceTensorIndices: cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: cudnnIndicesType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        reduceTensorOp: *mut cudnnReduceTensorOp_t,
        reduceTensorCompType: *mut cudnnDataType_t,
        reduceTensorNanOpt: *mut cudnnNanPropagation_t,
        reduceTensorIndices: *mut cudnnReduceTensorIndices_t,
        reduceTensorIndicesType: *mut cudnnIndicesType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyReduceTensorDescriptor(
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetReductionIndicesSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetReductionWorkspaceSize(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        aDesc: cudnnTensorDescriptor_t,
        cDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnReduceTensor(
        handle: cudnnHandle_t,
        reduceTensorDesc: cudnnReduceTensorDescriptor_t,
        indices: *mut ::core::ffi::c_void,
        indicesSizeInBytes: usize,
        workspace: *mut ::core::ffi::c_void,
        workspaceSizeInBytes: usize,
        alpha: *const ::core::ffi::c_void,
        aDesc: cudnnTensorDescriptor_t,
        A: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        C: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        valuePtr: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnScaleTensor(
        handle: cudnnHandle_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        alpha: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFilterDescriptor(filterDesc: *mut cudnnFilterDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        k: ::std::os::raw::c_int,
        c: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        w: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFilter4dDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        k: *mut ::std::os::raw::c_int,
        c: *mut ::std::os::raw::c_int,
        h: *mut ::std::os::raw::c_int,
        w: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        dataType: cudnnDataType_t,
        format: cudnnTensorFormat_t,
        nbDims: ::std::os::raw::c_int,
        filterDimA: *const ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFilterNdDescriptor(
        filterDesc: cudnnFilterDescriptor_t,
        nbDimsRequested: ::std::os::raw::c_int,
        dataType: *mut cudnnDataType_t,
        format: *mut cudnnTensorFormat_t,
        nbDims: *mut ::std::os::raw::c_int,
        filterDimA: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFilterSizeInBytes(
        filterDesc: cudnnFilterDescriptor_t,
        size: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnTransformFilter(
        handle: cudnnHandle_t,
        transDesc: cudnnTensorTransformDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        srcDesc: cudnnFilterDescriptor_t,
        srcData: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        destDesc: cudnnFilterDescriptor_t,
        destData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFilterDescriptor(filterDesc: cudnnFilterDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSoftmaxAlgorithm_t {
    CUDNN_SOFTMAX_FAST = 0,
    CUDNN_SOFTMAX_ACCURATE = 1,
    CUDNN_SOFTMAX_LOG = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSoftmaxMode_t {
    CUDNN_SOFTMAX_MODE_INSTANCE = 0,
    CUDNN_SOFTMAX_MODE_CHANNEL = 1,
}
extern "C" {
    pub fn cudnnSoftmaxForward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnPoolingMode_t {
    CUDNN_POOLING_MAX = 0,
    CUDNN_POOLING_AVERAGE_COUNT_INCLUDE_PADDING = 1,
    CUDNN_POOLING_AVERAGE_COUNT_EXCLUDE_PADDING = 2,
    CUDNN_POOLING_MAX_DETERMINISTIC = 3,
}
extern "C" {
    pub fn cudnnCreatePoolingDescriptor(
        poolingDesc: *mut cudnnPoolingDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        windowHeight: ::std::os::raw::c_int,
        windowWidth: ::std::os::raw::c_int,
        verticalPadding: ::std::os::raw::c_int,
        horizontalPadding: ::std::os::raw::c_int,
        verticalStride: ::std::os::raw::c_int,
        horizontalStride: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPooling2dDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        windowHeight: *mut ::std::os::raw::c_int,
        windowWidth: *mut ::std::os::raw::c_int,
        verticalPadding: *mut ::std::os::raw::c_int,
        horizontalPadding: *mut ::std::os::raw::c_int,
        verticalStride: *mut ::std::os::raw::c_int,
        horizontalStride: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        mode: cudnnPoolingMode_t,
        maxpoolingNanOpt: cudnnNanPropagation_t,
        nbDims: ::std::os::raw::c_int,
        windowDimA: *const ::std::os::raw::c_int,
        paddingA: *const ::std::os::raw::c_int,
        strideA: *const ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPoolingNdDescriptor(
        poolingDesc: cudnnPoolingDescriptor_t,
        nbDimsRequested: ::std::os::raw::c_int,
        mode: *mut cudnnPoolingMode_t,
        maxpoolingNanOpt: *mut cudnnNanPropagation_t,
        nbDims: *mut ::std::os::raw::c_int,
        windowDimA: *mut ::std::os::raw::c_int,
        paddingA: *mut ::std::os::raw::c_int,
        strideA: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPoolingNdForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        nbDims: ::std::os::raw::c_int,
        outputTensorDimA: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetPooling2dForwardOutputDim(
        poolingDesc: cudnnPoolingDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        n: *mut ::std::os::raw::c_int,
        c: *mut ::std::os::raw::c_int,
        h: *mut ::std::os::raw::c_int,
        w: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyPoolingDescriptor(poolingDesc: cudnnPoolingDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnPoolingForward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnActivationMode_t {
    CUDNN_ACTIVATION_SIGMOID = 0,
    CUDNN_ACTIVATION_RELU = 1,
    CUDNN_ACTIVATION_TANH = 2,
    CUDNN_ACTIVATION_CLIPPED_RELU = 3,
    CUDNN_ACTIVATION_ELU = 4,
    CUDNN_ACTIVATION_IDENTITY = 5,
    CUDNN_ACTIVATION_SWISH = 6,
}
extern "C" {
    pub fn cudnnCreateActivationDescriptor(
        activationDesc: *mut cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: cudnnActivationMode_t,
        reluNanOpt: cudnnNanPropagation_t,
        coef: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
        mode: *mut cudnnActivationMode_t,
        reluNanOpt: *mut cudnnNanPropagation_t,
        coef: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetActivationDescriptorSwishBeta(
        activationDesc: cudnnActivationDescriptor_t,
        swish_beta: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyActivationDescriptor(
        activationDesc: cudnnActivationDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnActivationForward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateLRNDescriptor(normDesc: *mut cudnnLRNDescriptor_t) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnLRNMode_t {
    CUDNN_LRN_CROSS_CHANNEL_DIM1 = 0,
}
extern "C" {
    pub fn cudnnSetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: ::std::os::raw::c_uint,
        lrnAlpha: f64,
        lrnBeta: f64,
        lrnK: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetLRNDescriptor(
        normDesc: cudnnLRNDescriptor_t,
        lrnN: *mut ::std::os::raw::c_uint,
        lrnAlpha: *mut f64,
        lrnBeta: *mut f64,
        lrnK: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyLRNDescriptor(lrnDesc: cudnnLRNDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnLRNCrossChannelForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDivNormMode_t {
    CUDNN_DIVNORM_PRECOMPUTED_MEANS = 0,
}
extern "C" {
    pub fn cudnnDivisiveNormalizationForward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        means: *const ::core::ffi::c_void,
        temp: *mut ::core::ffi::c_void,
        temp2: *mut ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBatchNormMode_t {
    CUDNN_BATCHNORM_PER_ACTIVATION = 0,
    CUDNN_BATCHNORM_SPATIAL = 1,
    CUDNN_BATCHNORM_SPATIAL_PERSISTENT = 2,
}
extern "C" {
    pub fn cudnnDeriveBNTensorDescriptor(
        derivedBnDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnBatchNormMode_t,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBatchNormOps_t {
    CUDNN_BATCHNORM_OPS_BN = 0,
    CUDNN_BATCHNORM_OPS_BN_ACTIVATION = 1,
    CUDNN_BATCHNORM_OPS_BN_ADD_ACTIVATION = 2,
}
extern "C" {
    pub fn cudnnBatchNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        estimatedMean: *const ::core::ffi::c_void,
        estimatedVariance: *const ::core::ffi::c_void,
        epsilon: f64,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNormMode_t {
    CUDNN_NORM_PER_ACTIVATION = 0,
    CUDNN_NORM_PER_CHANNEL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNormAlgo_t {
    CUDNN_NORM_ALGO_STANDARD = 0,
    CUDNN_NORM_ALGO_PERSIST = 1,
}
extern "C" {
    pub fn cudnnDeriveNormTensorDescriptor(
        derivedNormScaleBiasDesc: cudnnTensorDescriptor_t,
        derivedNormMeanVarDesc: cudnnTensorDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        mode: cudnnNormMode_t,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnNormOps_t {
    CUDNN_NORM_OPS_NORM = 0,
    CUDNN_NORM_OPS_NORM_ACTIVATION = 1,
    CUDNN_NORM_OPS_NORM_ADD_ACTIVATION = 2,
}
extern "C" {
    pub fn cudnnNormalizationForwardInference(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::core::ffi::c_void,
        normBias: *const ::core::ffi::c_void,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        estimatedMean: *const ::core::ffi::c_void,
        estimatedVariance: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        epsilon: f64,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSamplerType_t {
    CUDNN_SAMPLER_BILINEAR = 0,
}
extern "C" {
    pub fn cudnnCreateSpatialTransformerDescriptor(
        stDesc: *mut cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetSpatialTransformerNdDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
        samplerType: cudnnSamplerType_t,
        dataType: cudnnDataType_t,
        nbDims: ::std::os::raw::c_int,
        dimA: *const ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroySpatialTransformerDescriptor(
        stDesc: cudnnSpatialTransformerDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfGridGeneratorForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        theta: *const ::core::ffi::c_void,
        grid: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfSamplerForward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        grid: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnDropoutStruct {
    _unused: [u8; 0],
}
pub type cudnnDropoutDescriptor_t = *mut cudnnDropoutStruct;
extern "C" {
    pub fn cudnnCreateDropoutDescriptor(
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyDropoutDescriptor(dropoutDesc: cudnnDropoutDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutGetStatesSize(
        handle: cudnnHandle_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutGetReserveSpaceSize(
        xdesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::core::ffi::c_void,
        stateSizeInBytes: usize,
        seed: ::std::os::raw::c_ulonglong,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRestoreDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: f32,
        states: *mut ::core::ffi::c_void,
        stateSizeInBytes: usize,
        seed: ::std::os::raw::c_ulonglong,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetDropoutDescriptor(
        dropoutDesc: cudnnDropoutDescriptor_t,
        handle: cudnnHandle_t,
        dropout: *mut f32,
        states: *mut *mut ::core::ffi::c_void,
        seed: *mut ::std::os::raw::c_ulonglong,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutForward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        xdesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        ydesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAlgorithmStruct {
    _unused: [u8; 0],
}
pub type cudnnAlgorithmDescriptor_t = *mut cudnnAlgorithmStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAlgorithmPerformanceStruct {
    _unused: [u8; 0],
}
pub type cudnnAlgorithmPerformance_t = *mut cudnnAlgorithmPerformanceStruct;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionFwdAlgo_t {
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_GEMM = 0,
    CUDNN_CONVOLUTION_FWD_ALGO_IMPLICIT_PRECOMP_GEMM = 1,
    CUDNN_CONVOLUTION_FWD_ALGO_GEMM = 2,
    CUDNN_CONVOLUTION_FWD_ALGO_DIRECT = 3,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT = 4,
    CUDNN_CONVOLUTION_FWD_ALGO_FFT_TILING = 5,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD = 6,
    CUDNN_CONVOLUTION_FWD_ALGO_WINOGRAD_NONFUSED = 7,
    CUDNN_CONVOLUTION_FWD_ALGO_COUNT = 8,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionBwdFilterAlgo_t {
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_0 = 0,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_1 = 1,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT = 2,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_3 = 3,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD = 4,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_FFT_TILING = 6,
    CUDNN_CONVOLUTION_BWD_FILTER_ALGO_COUNT = 7,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionBwdDataAlgo_t {
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_0 = 0,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_1 = 1,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT = 2,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_FFT_TILING = 3,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD = 4,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_WINOGRAD_NONFUSED = 5,
    CUDNN_CONVOLUTION_BWD_DATA_ALGO_COUNT = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNAlgo_t {
    CUDNN_RNN_ALGO_STANDARD = 0,
    CUDNN_RNN_ALGO_PERSIST_STATIC = 1,
    CUDNN_RNN_ALGO_PERSIST_DYNAMIC = 2,
    CUDNN_RNN_ALGO_PERSIST_STATIC_SMALL_H = 3,
    CUDNN_RNN_ALGO_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnCTCLossAlgo_t {
    CUDNN_CTC_LOSS_ALGO_DETERMINISTIC = 0,
    CUDNN_CTC_LOSS_ALGO_NON_DETERMINISTIC = 1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cudnnAlgorithmUnionStruct {
    pub algo: cudnnAlgorithmUnionStruct_Algorithm,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cudnnAlgorithmUnionStruct_Algorithm {
    pub convFwdAlgo: cudnnConvolutionFwdAlgo_t,
    pub convBwdFilterAlgo: cudnnConvolutionBwdFilterAlgo_t,
    pub convBwdDataAlgo: cudnnConvolutionBwdDataAlgo_t,
    pub RNNAlgo: cudnnRNNAlgo_t,
    pub CTCLossAlgo: cudnnCTCLossAlgo_t,
}
#[test]
fn bindgen_test_layout_cudnnAlgorithmUnionStruct_Algorithm() {
    assert_eq!(
        ::core::mem::size_of::<cudnnAlgorithmUnionStruct_Algorithm>(),
        4usize,
        concat!("Size of: ", stringify!(cudnnAlgorithmUnionStruct_Algorithm))
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnAlgorithmUnionStruct_Algorithm>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).convFwdAlgo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(convFwdAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).convBwdFilterAlgo
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(convBwdFilterAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).convBwdDataAlgo
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(convBwdDataAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).RNNAlgo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(RNNAlgo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnAlgorithmUnionStruct_Algorithm>())).CTCLossAlgo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct_Algorithm),
            "::",
            stringify!(CTCLossAlgo)
        )
    );
}
impl Default for cudnnAlgorithmUnionStruct_Algorithm {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_cudnnAlgorithmUnionStruct() {
    assert_eq!(
        ::core::mem::size_of::<cudnnAlgorithmUnionStruct>(),
        4usize,
        concat!("Size of: ", stringify!(cudnnAlgorithmUnionStruct))
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnAlgorithmUnionStruct>(),
        4usize,
        concat!("Alignment of ", stringify!(cudnnAlgorithmUnionStruct))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnAlgorithmUnionStruct>())).algo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnAlgorithmUnionStruct),
            "::",
            stringify!(algo)
        )
    );
}
impl Default for cudnnAlgorithmUnionStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type cudnnAlgorithm_t = cudnnAlgorithmUnionStruct;
extern "C" {
    pub fn cudnnCreateAlgorithmDescriptor(
        algoDesc: *mut cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetAlgorithmDescriptor(
        algoDesc: cudnnAlgorithmDescriptor_t,
        algorithm: cudnnAlgorithm_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAlgorithmDescriptor(
        algoDesc: cudnnAlgorithmDescriptor_t,
        algorithm: *mut cudnnAlgorithm_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCopyAlgorithmDescriptor(
        src: cudnnAlgorithmDescriptor_t,
        dest: cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyAlgorithmDescriptor(algoDesc: cudnnAlgorithmDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateAlgorithmPerformance(
        algoPerf: *mut cudnnAlgorithmPerformance_t,
        numberToCreate: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetAlgorithmPerformance(
        algoPerf: cudnnAlgorithmPerformance_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
        status: cudnnStatus_t,
        time: f32,
        memory: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAlgorithmPerformance(
        algoPerf: cudnnAlgorithmPerformance_t,
        algoDesc: *mut cudnnAlgorithmDescriptor_t,
        status: *mut cudnnStatus_t,
        time: *mut f32,
        memory: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyAlgorithmPerformance(
        algoPerf: *mut cudnnAlgorithmPerformance_t,
        numberToDestroy: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAlgorithmSpaceSize(
        handle: cudnnHandle_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
        algoSpaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSaveAlgorithm(
        handle: cudnnHandle_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
        algoSpace: *mut ::core::ffi::c_void,
        algoSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRestoreAlgorithm(
        handle: cudnnHandle_t,
        algoSpace: *mut ::core::ffi::c_void,
        algoSpaceSizeInBytes: usize,
        algoDesc: cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSeverity_t {
    CUDNN_SEV_FATAL = 0,
    CUDNN_SEV_ERROR = 1,
    CUDNN_SEV_WARNING = 2,
    CUDNN_SEV_INFO = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct cudnnDebugStruct {
    pub cudnn_version: ::std::os::raw::c_uint,
    pub cudnnStatus: cudnnStatus_t,
    pub time_sec: ::std::os::raw::c_uint,
    pub time_usec: ::std::os::raw::c_uint,
    pub time_delta: ::std::os::raw::c_uint,
    pub handle: cudnnHandle_t,
    pub stream: cudaStream_t,
    pub pid: ::std::os::raw::c_ulonglong,
    pub tid: ::std::os::raw::c_ulonglong,
    pub cudaDeviceId: ::std::os::raw::c_int,
    pub reserved: [::std::os::raw::c_int; 15usize],
}
#[test]
fn bindgen_test_layout_cudnnDebugStruct() {
    assert_eq!(
        ::core::mem::size_of::<cudnnDebugStruct>(),
        120usize,
        concat!("Size of: ", stringify!(cudnnDebugStruct))
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnDebugStruct>(),
        8usize,
        concat!("Alignment of ", stringify!(cudnnDebugStruct))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).cudnn_version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(cudnn_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).cudnnStatus as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(cudnnStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).time_sec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(time_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).time_usec as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(time_usec)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).time_delta as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(time_delta)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).handle as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).stream as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(stream)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).pid as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).tid as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).cudaDeviceId as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(cudaDeviceId)
        )
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnDebugStruct>())).reserved as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnDebugStruct),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for cudnnDebugStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type cudnnDebug_t = cudnnDebugStruct;
pub type cudnnCallback_t = ::core::option::Option<
    unsafe extern "C" fn(
        sev: cudnnSeverity_t,
        udata: *mut ::core::ffi::c_void,
        dbg: *const cudnnDebug_t,
        msg: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn cudnnSetCallback(
        mask: ::std::os::raw::c_uint,
        udata: *mut ::core::ffi::c_void,
        fptr: cudnnCallback_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCallback(
        mask: *mut ::std::os::raw::c_uint,
        udata: *mut *mut ::core::ffi::c_void,
        fptr: *mut cudnnCallback_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnOpsInferVersionCheck() -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSoftmaxBackward(
        handle: cudnnHandle_t,
        algo: cudnnSoftmaxAlgorithm_t,
        mode: cudnnSoftmaxMode_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnPoolingBackward(
        handle: cudnnHandle_t,
        poolingDesc: cudnnPoolingDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnActivationBackward(
        handle: cudnnHandle_t,
        activationDesc: cudnnActivationDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnLRNCrossChannelBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        lrnMode: cudnnLRNMode_t,
        alpha: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDivisiveNormalizationBackward(
        handle: cudnnHandle_t,
        normDesc: cudnnLRNDescriptor_t,
        mode: cudnnDivNormMode_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        means: *const ::core::ffi::c_void,
        dy: *const ::core::ffi::c_void,
        temp: *mut ::core::ffi::c_void,
        temp2: *mut ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dXdMeansDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dMeans: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetBatchNormalizationForwardTrainingExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetBatchNormalizationBackwardExWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetBatchNormalizationTrainingExReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationForwardTrainingEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::core::ffi::c_void,
        bnScaleBiasMeanVarDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        bnBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScale: *const ::core::ffi::c_void,
        dBnScaleResult: *mut ::core::ffi::c_void,
        dBnBiasResult: *mut ::core::ffi::c_void,
        epsilon: f64,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBatchNormalizationBackwardEx(
        handle: cudnnHandle_t,
        mode: cudnnBatchNormMode_t,
        bnOps: cudnnBatchNormOps_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::core::ffi::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::core::ffi::c_void,
        dBnScaleBiasDesc: cudnnTensorDescriptor_t,
        bnScaleData: *const ::core::ffi::c_void,
        bnBiasData: *const ::core::ffi::c_void,
        dBnScaleData: *mut ::core::ffi::c_void,
        dBnBiasData: *mut ::core::ffi::c_void,
        epsilon: f64,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetNormalizationForwardTrainingWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetNormalizationBackwardWorkspaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        xDesc: cudnnTensorDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        dzDesc: cudnnTensorDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        activationDesc: cudnnActivationDescriptor_t,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetNormalizationTrainingReserveSpaceSize(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        activationDesc: cudnnActivationDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnNormalizationForwardTraining(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alpha: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        normScaleBiasDesc: cudnnTensorDescriptor_t,
        normScale: *const ::core::ffi::c_void,
        normBias: *const ::core::ffi::c_void,
        exponentialAverageFactor: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        resultRunningMean: *mut ::core::ffi::c_void,
        resultRunningVariance: *mut ::core::ffi::c_void,
        epsilon: f64,
        resultSaveMean: *mut ::core::ffi::c_void,
        resultSaveInvVariance: *mut ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        zDesc: cudnnTensorDescriptor_t,
        zData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *mut ::core::ffi::c_void,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnNormalizationBackward(
        handle: cudnnHandle_t,
        mode: cudnnNormMode_t,
        normOps: cudnnNormOps_t,
        algo: cudnnNormAlgo_t,
        alphaDataDiff: *const ::core::ffi::c_void,
        betaDataDiff: *const ::core::ffi::c_void,
        alphaParamDiff: *const ::core::ffi::c_void,
        betaParamDiff: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        xData: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        yData: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dyData: *const ::core::ffi::c_void,
        dzDesc: cudnnTensorDescriptor_t,
        dzData: *mut ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dxData: *mut ::core::ffi::c_void,
        dNormScaleBiasDesc: cudnnTensorDescriptor_t,
        normScaleData: *const ::core::ffi::c_void,
        normBiasData: *const ::core::ffi::c_void,
        dNormScaleData: *mut ::core::ffi::c_void,
        dNormBiasData: *mut ::core::ffi::c_void,
        epsilon: f64,
        normMeanVarDesc: cudnnTensorDescriptor_t,
        savedMean: *const ::core::ffi::c_void,
        savedInvVariance: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        groupCnt: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfGridGeneratorBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        dgrid: *const ::core::ffi::c_void,
        dtheta: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSpatialTfSamplerBackward(
        handle: cudnnHandle_t,
        stDesc: cudnnSpatialTransformerDescriptor_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        alphaDgrid: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        grid: *const ::core::ffi::c_void,
        betaDgrid: *const ::core::ffi::c_void,
        dgrid: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDropoutBackward(
        handle: cudnnHandle_t,
        dropoutDesc: cudnnDropoutDescriptor_t,
        dydesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dxdesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnOpsTrainVersionCheck() -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnForwardMode_t {
    CUDNN_FWD_MODE_INFERENCE = 0,
    CUDNN_FWD_MODE_TRAINING = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNMode_t {
    CUDNN_RNN_RELU = 0,
    CUDNN_RNN_TANH = 1,
    CUDNN_LSTM = 2,
    CUDNN_GRU = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNBiasMode_t {
    CUDNN_RNN_NO_BIAS = 0,
    CUDNN_RNN_SINGLE_INP_BIAS = 1,
    CUDNN_RNN_DOUBLE_BIAS = 2,
    CUDNN_RNN_SINGLE_REC_BIAS = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnDirectionMode_t {
    CUDNN_UNIDIRECTIONAL = 0,
    CUDNN_BIDIRECTIONAL = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNInputMode_t {
    CUDNN_LINEAR_INPUT = 0,
    CUDNN_SKIP_INPUT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNClipMode_t {
    CUDNN_RNN_CLIP_NONE = 0,
    CUDNN_RNN_CLIP_MINMAX = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnRNNDataLayout_t {
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_UNPACKED = 0,
    CUDNN_RNN_DATA_LAYOUT_SEQ_MAJOR_PACKED = 1,
    CUDNN_RNN_DATA_LAYOUT_BATCH_MAJOR_UNPACKED = 2,
}
pub type cudnnRNNPaddingMode_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRNNStruct {
    _unused: [u8; 0],
}
pub type cudnnRNNDescriptor_t = *mut cudnnRNNStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnPersistentRNNPlan {
    _unused: [u8; 0],
}
pub type cudnnPersistentRNNPlan_t = *mut cudnnPersistentRNNPlan;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnRNNDataStruct {
    _unused: [u8; 0],
}
pub type cudnnRNNDataDescriptor_t = *mut cudnnRNNDataStruct;
extern "C" {
    pub fn cudnnCreateRNNDescriptor(rnnDesc: *mut cudnnRNNDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyRNNDescriptor(rnnDesc: cudnnRNNDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: cudnnRNNAlgo_t,
        cellMode: cudnnRNNMode_t,
        biasMode: cudnnRNNBiasMode_t,
        dirMode: cudnnDirectionMode_t,
        inputMode: cudnnRNNInputMode_t,
        dataType: cudnnDataType_t,
        mathPrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        inputSize: i32,
        hiddenSize: i32,
        projSize: i32,
        numLayers: i32,
        dropoutDesc: cudnnDropoutDescriptor_t,
        auxFlags: u32,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNDescriptor_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        algo: *mut cudnnRNNAlgo_t,
        cellMode: *mut cudnnRNNMode_t,
        biasMode: *mut cudnnRNNBiasMode_t,
        dirMode: *mut cudnnDirectionMode_t,
        inputMode: *mut cudnnRNNInputMode_t,
        dataType: *mut cudnnDataType_t,
        mathPrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        inputSize: *mut i32,
        hiddenSize: *mut i32,
        projSize: *mut i32,
        numLayers: *mut i32,
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
        auxFlags: *mut u32,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNDescriptor_v6(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        hiddenSize: ::std::os::raw::c_int,
        numLayers: ::std::os::raw::c_int,
        dropoutDesc: cudnnDropoutDescriptor_t,
        inputMode: cudnnRNNInputMode_t,
        direction: cudnnDirectionMode_t,
        cellMode: cudnnRNNMode_t,
        algo: cudnnRNNAlgo_t,
        mathPrec: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNDescriptor_v6(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        hiddenSize: *mut ::std::os::raw::c_int,
        numLayers: *mut ::std::os::raw::c_int,
        dropoutDesc: *mut cudnnDropoutDescriptor_t,
        inputMode: *mut cudnnRNNInputMode_t,
        direction: *mut cudnnDirectionMode_t,
        cellMode: *mut cudnnRNNMode_t,
        algo: *mut cudnnRNNAlgo_t,
        mathPrec: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNMatrixMathType(
        rnnDesc: cudnnRNNDescriptor_t,
        mType: cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNMatrixMathType(
        rnnDesc: cudnnRNNDescriptor_t,
        mType: *mut cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNBiasMode(
        rnnDesc: cudnnRNNDescriptor_t,
        biasMode: cudnnRNNBiasMode_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNBiasMode(
        rnnDesc: cudnnRNNDescriptor_t,
        biasMode: *mut cudnnRNNBiasMode_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNSetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        clipNanOpt: cudnnNanPropagation_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNGetClip_v8(
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        clipNanOpt: *mut cudnnNanPropagation_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNSetClip(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: cudnnRNNClipMode_t,
        clipNanOpt: cudnnNanPropagation_t,
        lclip: f64,
        rclip: f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNGetClip(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        clipMode: *mut cudnnRNNClipMode_t,
        clipNanOpt: *mut cudnnNanPropagation_t,
        lclip: *mut f64,
        rclip: *mut f64,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNProjectionLayers(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        recProjSize: ::std::os::raw::c_int,
        outProjSize: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNProjectionLayers(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        recProjSize: *mut ::std::os::raw::c_int,
        outProjSize: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreatePersistentRNNPlan(
        rnnDesc: cudnnRNNDescriptor_t,
        minibatch: ::std::os::raw::c_int,
        dataType: cudnnDataType_t,
        plan: *mut cudnnPersistentRNNPlan_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyPersistentRNNPlan(plan: cudnnPersistentRNNPlan_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetPersistentRNNPlan(
        rnnDesc: cudnnRNNDescriptor_t,
        plan: cudnnPersistentRNNPlan_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBuildRNNDynamic(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        miniBatch: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNWorkspaceSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNTrainingReserveSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNTempSpaceSizes(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fMode: cudnnForwardMode_t,
        xDesc: cudnnRNNDataDescriptor_t,
        workSpaceSize: *mut usize,
        reserveSpaceSize: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNParamsSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
        dataType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNWeightSpaceSize(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        weightSpaceSize: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNLinLayerMatrixParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: ::std::os::raw::c_int,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        linLayerID: ::std::os::raw::c_int,
        linLayerMatDesc: cudnnFilterDescriptor_t,
        linLayerMat: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNLinLayerBiasParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: ::std::os::raw::c_int,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        linLayerID: ::std::os::raw::c_int,
        linLayerBiasDesc: cudnnFilterDescriptor_t,
        linLayerBias: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNWeightParams(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        pseudoLayer: i32,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        linLayerID: i32,
        mDesc: cudnnTensorDescriptor_t,
        mAddr: *mut *mut ::core::ffi::c_void,
        bDesc: cudnnTensorDescriptor_t,
        bAddr: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForwardInference(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::core::ffi::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNPaddingMode(
        rnnDesc: cudnnRNNDescriptor_t,
        paddingMode: ::std::os::raw::c_uint,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNPaddingMode(
        rnnDesc: cudnnRNNDescriptor_t,
        paddingMode: *mut ::std::os::raw::c_uint,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateRNNDataDescriptor(
        rnnDataDesc: *mut cudnnRNNDataDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyRNNDataDescriptor(rnnDataDesc: cudnnRNNDataDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: cudnnDataType_t,
        layout: cudnnRNNDataLayout_t,
        maxSeqLength: ::std::os::raw::c_int,
        batchSize: ::std::os::raw::c_int,
        vectorSize: ::std::os::raw::c_int,
        seqLengthArray: *const ::std::os::raw::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNDataDescriptor(
        rnnDataDesc: cudnnRNNDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        layout: *mut cudnnRNNDataLayout_t,
        maxSeqLength: *mut ::std::os::raw::c_int,
        batchSize: *mut ::std::os::raw::c_int,
        vectorSize: *mut ::std::os::raw::c_int,
        arrayLengthRequested: ::std::os::raw::c_int,
        seqLengthArray: *mut ::std::os::raw::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForwardInferenceEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::core::ffi::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::core::ffi::c_void,
        kDesc: cudnnRNNDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        cDesc: cudnnRNNDataDescriptor_t,
        cAttn: *mut ::core::ffi::c_void,
        iDesc: cudnnRNNDataDescriptor_t,
        iAttn: *mut ::core::ffi::c_void,
        qDesc: cudnnRNNDataDescriptor_t,
        queries: *mut ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForward(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        fwdMode: cudnnForwardMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        hy: *mut ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        cy: *mut ::core::ffi::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetRNNAlgorithmDescriptor(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        algoDesc: cudnnAlgorithmDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNForwardInferenceAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNForwardInferenceAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::core::ffi::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::core::ffi::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSeqDataAxis_t {
    CUDNN_SEQDATA_TIME_DIM = 0,
    CUDNN_SEQDATA_BATCH_DIM = 1,
    CUDNN_SEQDATA_BEAM_DIM = 2,
    CUDNN_SEQDATA_VECT_DIM = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnSeqDataStruct {
    _unused: [u8; 0],
}
pub type cudnnSeqDataDescriptor_t = *mut cudnnSeqDataStruct;
extern "C" {
    pub fn cudnnCreateSeqDataDescriptor(
        seqDataDesc: *mut cudnnSeqDataDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroySeqDataDescriptor(seqDataDesc: cudnnSeqDataDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: cudnnDataType_t,
        nbDims: ::std::os::raw::c_int,
        dimA: *const ::std::os::raw::c_int,
        axes: *const cudnnSeqDataAxis_t,
        seqLengthArraySize: usize,
        seqLengthArray: *const ::std::os::raw::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetSeqDataDescriptor(
        seqDataDesc: cudnnSeqDataDescriptor_t,
        dataType: *mut cudnnDataType_t,
        nbDims: *mut ::std::os::raw::c_int,
        nbDimsRequested: ::std::os::raw::c_int,
        dimA: *mut ::std::os::raw::c_int,
        axes: *mut cudnnSeqDataAxis_t,
        seqLengthArraySize: *mut usize,
        seqLengthSizeRequested: usize,
        seqLengthArray: *mut ::std::os::raw::c_int,
        paddingFill: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
pub type cudnnAttnQueryMap_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnAttnStruct {
    _unused: [u8; 0],
}
pub type cudnnAttnDescriptor_t = *mut cudnnAttnStruct;
extern "C" {
    pub fn cudnnCreateAttnDescriptor(attnDesc: *mut cudnnAttnDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyAttnDescriptor(attnDesc: cudnnAttnDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: ::std::os::raw::c_uint,
        nHeads: ::std::os::raw::c_int,
        smScaler: f64,
        dataType: cudnnDataType_t,
        computePrec: cudnnDataType_t,
        mathType: cudnnMathType_t,
        attnDropoutDesc: cudnnDropoutDescriptor_t,
        postDropoutDesc: cudnnDropoutDescriptor_t,
        qSize: ::std::os::raw::c_int,
        kSize: ::std::os::raw::c_int,
        vSize: ::std::os::raw::c_int,
        qProjSize: ::std::os::raw::c_int,
        kProjSize: ::std::os::raw::c_int,
        vProjSize: ::std::os::raw::c_int,
        oProjSize: ::std::os::raw::c_int,
        qoMaxSeqLength: ::std::os::raw::c_int,
        kvMaxSeqLength: ::std::os::raw::c_int,
        maxBatchSize: ::std::os::raw::c_int,
        maxBeamSize: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetAttnDescriptor(
        attnDesc: cudnnAttnDescriptor_t,
        attnMode: *mut ::std::os::raw::c_uint,
        nHeads: *mut ::std::os::raw::c_int,
        smScaler: *mut f64,
        dataType: *mut cudnnDataType_t,
        computePrec: *mut cudnnDataType_t,
        mathType: *mut cudnnMathType_t,
        attnDropoutDesc: *mut cudnnDropoutDescriptor_t,
        postDropoutDesc: *mut cudnnDropoutDescriptor_t,
        qSize: *mut ::std::os::raw::c_int,
        kSize: *mut ::std::os::raw::c_int,
        vSize: *mut ::std::os::raw::c_int,
        qProjSize: *mut ::std::os::raw::c_int,
        kProjSize: *mut ::std::os::raw::c_int,
        vProjSize: *mut ::std::os::raw::c_int,
        oProjSize: *mut ::std::os::raw::c_int,
        qoMaxSeqLength: *mut ::std::os::raw::c_int,
        kvMaxSeqLength: *mut ::std::os::raw::c_int,
        maxBatchSize: *mut ::std::os::raw::c_int,
        maxBeamSize: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetMultiHeadAttnBuffers(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        weightSizeInBytes: *mut usize,
        workSpaceSizeInBytes: *mut usize,
        reserveSpaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnMultiHeadAttnWeightKind_t {
    CUDNN_MH_ATTN_Q_WEIGHTS = 0,
    CUDNN_MH_ATTN_K_WEIGHTS = 1,
    CUDNN_MH_ATTN_V_WEIGHTS = 2,
    CUDNN_MH_ATTN_O_WEIGHTS = 3,
    CUDNN_MH_ATTN_Q_BIASES = 4,
    CUDNN_MH_ATTN_K_BIASES = 5,
    CUDNN_MH_ATTN_V_BIASES = 6,
    CUDNN_MH_ATTN_O_BIASES = 7,
}
extern "C" {
    pub fn cudnnGetMultiHeadAttnWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        wKind: cudnnMultiHeadAttnWeightKind_t,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        wDesc: cudnnTensorDescriptor_t,
        wAddr: *mut *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMultiHeadAttnForward(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        currIdx: ::std::os::raw::c_int,
        loWinIdx: *const ::std::os::raw::c_int,
        hiWinIdx: *const ::std::os::raw::c_int,
        devSeqLengthsQO: *const ::std::os::raw::c_int,
        devSeqLengthsKV: *const ::std::os::raw::c_int,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::core::ffi::c_void,
        residuals: *const ::core::ffi::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::core::ffi::c_void,
        oDesc: cudnnSeqDataDescriptor_t,
        out: *mut ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnAdvInferVersionCheck() -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnWgradMode_t {
    CUDNN_WGRAD_MODE_ADD = 0,
    CUDNN_WGRAD_MODE_SET = 1,
}
extern "C" {
    pub fn cudnnRNNForwardTraining(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::core::ffi::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardData(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: *const cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dhyDesc: cudnnTensorDescriptor_t,
        dhy: *const ::core::ffi::c_void,
        dcyDesc: cudnnTensorDescriptor_t,
        dcy: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        dxDesc: *const cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dhxDesc: cudnnTensorDescriptor_t,
        dhx: *mut ::core::ffi::c_void,
        dcxDesc: cudnnTensorDescriptor_t,
        dcx: *mut ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardData_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        devSeqLengths: *const i32,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        dy: *const ::core::ffi::c_void,
        xDesc: cudnnRNNDataDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        dhy: *const ::core::ffi::c_void,
        dhx: *mut ::core::ffi::c_void,
        cDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        dcy: *const ::core::ffi::c_void,
        dcx: *mut ::core::ffi::c_void,
        weightSpaceSize: usize,
        weightSpace: *const ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardWeights(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        workSpace: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
        reserveSpace: *const ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardWeights_v8(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        addGrad: cudnnWgradMode_t,
        devSeqLengths: *const i32,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        hDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        weightSpaceSize: usize,
        dweightSpace: *mut ::core::ffi::c_void,
        workSpaceSize: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSize: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNForwardTrainingEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::core::ffi::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::core::ffi::c_void,
        kDesc: cudnnRNNDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        cDesc: cudnnRNNDataDescriptor_t,
        cAttn: *mut ::core::ffi::c_void,
        iDesc: cudnnRNNDataDescriptor_t,
        iAttn: *mut ::core::ffi::c_void,
        qDesc: cudnnRNNDataDescriptor_t,
        queries: *mut ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardDataEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: cudnnRNNDataDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dcDesc: cudnnRNNDataDescriptor_t,
        dcAttn: *const ::core::ffi::c_void,
        dhyDesc: cudnnTensorDescriptor_t,
        dhy: *const ::core::ffi::c_void,
        dcyDesc: cudnnTensorDescriptor_t,
        dcy: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        dxDesc: cudnnRNNDataDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dhxDesc: cudnnTensorDescriptor_t,
        dhx: *mut ::core::ffi::c_void,
        dcxDesc: cudnnTensorDescriptor_t,
        dcx: *mut ::core::ffi::c_void,
        dkDesc: cudnnRNNDataDescriptor_t,
        dkeys: *mut ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnRNNBackwardWeightsEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        xDesc: cudnnRNNDataDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        yDesc: cudnnRNNDataDescriptor_t,
        y: *const ::core::ffi::c_void,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNForwardTrainingAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNForwardTrainingAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        hyDesc: cudnnTensorDescriptor_t,
        hy: *mut ::core::ffi::c_void,
        cyDesc: cudnnTensorDescriptor_t,
        cy: *mut ::core::ffi::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNBackwardDataAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNBackwardDataAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        dyDesc: *const cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        dhyDesc: cudnnTensorDescriptor_t,
        dhy: *const ::core::ffi::c_void,
        dcyDesc: cudnnTensorDescriptor_t,
        dcy: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        cxDesc: cudnnTensorDescriptor_t,
        cx: *const ::core::ffi::c_void,
        dxDesc: *const cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        dhxDesc: cudnnTensorDescriptor_t,
        dhx: *mut ::core::ffi::c_void,
        dcxDesc: cudnnTensorDescriptor_t,
        dcx: *mut ::core::ffi::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetRNNBackwardWeightsAlgorithmMaxCount(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindRNNBackwardWeightsAlgorithmEx(
        handle: cudnnHandle_t,
        rnnDesc: cudnnRNNDescriptor_t,
        seqLength: ::std::os::raw::c_int,
        xDesc: *const cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        hxDesc: cudnnTensorDescriptor_t,
        hx: *const ::core::ffi::c_void,
        yDesc: *const cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        findIntensity: f32,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnAlgorithmPerformance_t,
        workspace: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
        reserveSpace: *const ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMultiHeadAttnBackwardData(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        loWinIdx: *const ::std::os::raw::c_int,
        hiWinIdx: *const ::std::os::raw::c_int,
        devSeqLengthsDQDO: *const ::std::os::raw::c_int,
        devSeqLengthsDKDV: *const ::std::os::raw::c_int,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::core::ffi::c_void,
        dqDesc: cudnnSeqDataDescriptor_t,
        dqueries: *mut ::core::ffi::c_void,
        queries: *const ::core::ffi::c_void,
        dkDesc: cudnnSeqDataDescriptor_t,
        dkeys: *mut ::core::ffi::c_void,
        keys: *const ::core::ffi::c_void,
        dvDesc: cudnnSeqDataDescriptor_t,
        dvalues: *mut ::core::ffi::c_void,
        values: *const ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMultiHeadAttnBackwardWeights(
        handle: cudnnHandle_t,
        attnDesc: cudnnAttnDescriptor_t,
        addGrad: cudnnWgradMode_t,
        qDesc: cudnnSeqDataDescriptor_t,
        queries: *const ::core::ffi::c_void,
        kDesc: cudnnSeqDataDescriptor_t,
        keys: *const ::core::ffi::c_void,
        vDesc: cudnnSeqDataDescriptor_t,
        values: *const ::core::ffi::c_void,
        doDesc: cudnnSeqDataDescriptor_t,
        dout: *const ::core::ffi::c_void,
        weightSizeInBytes: usize,
        weights: *const ::core::ffi::c_void,
        dweights: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workSpace: *mut ::core::ffi::c_void,
        reserveSpaceSizeInBytes: usize,
        reserveSpace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnLossNormalizationMode_t {
    CUDNN_LOSS_NORMALIZATION_NONE = 0,
    CUDNN_LOSS_NORMALIZATION_SOFTMAX = 1,
}
extern "C" {
    pub fn cudnnCreateCTCLossDescriptor(
        ctcLossDesc: *mut cudnnCTCLossDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: cudnnDataType_t,
        normMode: cudnnLossNormalizationMode_t,
        gradMode: cudnnNanPropagation_t,
        maxLabelLength: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossDescriptor(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossDescriptorEx(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossDescriptor_v8(
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        compType: *mut cudnnDataType_t,
        normMode: *mut cudnnLossNormalizationMode_t,
        gradMode: *mut cudnnNanPropagation_t,
        maxLabelLength: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyCTCLossDescriptor(ctcLossDesc: cudnnCTCLossDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCTCLoss(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::core::ffi::c_void,
        hostLabels: *const ::std::os::raw::c_int,
        hostLabelLengths: *const ::std::os::raw::c_int,
        hostInputLengths: *const ::std::os::raw::c_int,
        costs: *mut ::core::ffi::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::core::ffi::c_void,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        workspace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCTCLoss_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        probs: *const ::core::ffi::c_void,
        labels: *const ::std::os::raw::c_int,
        labelLengths: *const ::std::os::raw::c_int,
        inputLengths: *const ::std::os::raw::c_int,
        costs: *mut ::core::ffi::c_void,
        gradientsDesc: cudnnTensorDescriptor_t,
        gradients: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        workspace: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossWorkspaceSize(
        handle: cudnnHandle_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        labels: *const ::std::os::raw::c_int,
        labelLengths: *const ::std::os::raw::c_int,
        inputLengths: *const ::std::os::raw::c_int,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetCTCLossWorkspaceSize_v8(
        handle: cudnnHandle_t,
        algo: cudnnCTCLossAlgo_t,
        ctcLossDesc: cudnnCTCLossDescriptor_t,
        probsDesc: cudnnTensorDescriptor_t,
        gradientsDesc: cudnnTensorDescriptor_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnAdvTrainVersionCheck() -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnConvolutionStruct {
    _unused: [u8; 0],
}
pub type cudnnConvolutionDescriptor_t = *mut cudnnConvolutionStruct;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnConvolutionMode_t {
    CUDNN_CONVOLUTION = 0,
    CUDNN_CROSS_CORRELATION = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnReorderType_t {
    CUDNN_DEFAULT_REORDER = 0,
    CUDNN_NO_REORDER = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct cudnnConvolutionFwdAlgoPerfStruct {
    pub algo: cudnnConvolutionFwdAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::std::os::raw::c_int; 3usize],
}
#[test]
fn bindgen_test_layout_cudnnConvolutionFwdAlgoPerfStruct() {
    assert_eq!(
        ::core::mem::size_of::<cudnnConvolutionFwdAlgoPerfStruct>(),
        48usize,
        concat!("Size of: ", stringify!(cudnnConvolutionFwdAlgoPerfStruct))
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnConvolutionFwdAlgoPerfStruct>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).algo as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).status as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).time as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).memory as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).determinism as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(determinism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).mathType as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(mathType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionFwdAlgoPerfStruct>())).reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionFwdAlgoPerfStruct),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for cudnnConvolutionFwdAlgoPerfStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type cudnnConvolutionFwdAlgoPerf_t = cudnnConvolutionFwdAlgoPerfStruct;
extern "C" {
    pub fn cudnnCreateConvolutionDescriptor(
        convDesc: *mut cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyConvolutionDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionMathType(
        convDesc: cudnnConvolutionDescriptor_t,
        mathType: *mut cudnnMathType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionGroupCount(
        convDesc: cudnnConvolutionDescriptor_t,
        groupCount: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: cudnnReorderType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionReorderType(
        convDesc: cudnnConvolutionDescriptor_t,
        reorderType: *mut cudnnReorderType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: ::std::os::raw::c_int,
        pad_w: ::std::os::raw::c_int,
        u: ::std::os::raw::c_int,
        v: ::std::os::raw::c_int,
        dilation_h: ::std::os::raw::c_int,
        dilation_w: ::std::os::raw::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolution2dDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        pad_h: *mut ::std::os::raw::c_int,
        pad_w: *mut ::std::os::raw::c_int,
        u: *mut ::std::os::raw::c_int,
        v: *mut ::std::os::raw::c_int,
        dilation_h: *mut ::std::os::raw::c_int,
        dilation_w: *mut ::std::os::raw::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLength: ::std::os::raw::c_int,
        padA: *const ::std::os::raw::c_int,
        filterStrideA: *const ::std::os::raw::c_int,
        dilationA: *const ::std::os::raw::c_int,
        mode: cudnnConvolutionMode_t,
        computeType: cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionNdDescriptor(
        convDesc: cudnnConvolutionDescriptor_t,
        arrayLengthRequested: ::std::os::raw::c_int,
        arrayLength: *mut ::std::os::raw::c_int,
        padA: *mut ::std::os::raw::c_int,
        strideA: *mut ::std::os::raw::c_int,
        dilationA: *mut ::std::os::raw::c_int,
        mode: *mut cudnnConvolutionMode_t,
        computeType: *mut cudnnDataType_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolution2dForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        n: *mut ::std::os::raw::c_int,
        c: *mut ::std::os::raw::c_int,
        h: *mut ::std::os::raw::c_int,
        w: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionNdForwardOutputDim(
        convDesc: cudnnConvolutionDescriptor_t,
        inputTensorDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        nbDims: ::std::os::raw::c_int,
        tensorOuputDimA: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionForwardAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionForwardAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        filterDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        destDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionForwardAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionForwardAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionFwdAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnIm2Col(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        colBuffer: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnReorderFilterAndBias(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        reorderType: cudnnReorderType_t,
        filterData: *const ::core::ffi::c_void,
        reorderedFilterData: *mut ::core::ffi::c_void,
        reorderBias: ::std::os::raw::c_int,
        biasData: *const ::core::ffi::c_void,
        reorderedBiasData: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionForwardWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        wDesc: cudnnFilterDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionForward(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBiasActivationForward(
        handle: cudnnHandle_t,
        alpha1: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionFwdAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        alpha2: *const ::core::ffi::c_void,
        zDesc: cudnnTensorDescriptor_t,
        z: *const ::core::ffi::c_void,
        biasDesc: cudnnTensorDescriptor_t,
        bias: *const ::core::ffi::c_void,
        activationDesc: cudnnActivationDescriptor_t,
        yDesc: cudnnTensorDescriptor_t,
        y: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct cudnnConvolutionBwdDataAlgoPerfStruct {
    pub algo: cudnnConvolutionBwdDataAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::std::os::raw::c_int; 3usize],
}
#[test]
fn bindgen_test_layout_cudnnConvolutionBwdDataAlgoPerfStruct() {
    assert_eq!(
        ::core::mem::size_of::<cudnnConvolutionBwdDataAlgoPerfStruct>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnConvolutionBwdDataAlgoPerfStruct>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).algo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).status as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).time as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).memory as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).determinism
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(determinism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).mathType as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(mathType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdDataAlgoPerfStruct>())).reserved as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdDataAlgoPerfStruct),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for cudnnConvolutionBwdDataAlgoPerfStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type cudnnConvolutionBwdDataAlgoPerf_t = cudnnConvolutionBwdDataAlgoPerfStruct;
extern "C" {
    pub fn cudnnGetConvolutionBackwardDataAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardDataAlgorithm(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardDataAlgorithmEx(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardDataAlgorithm_v7(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionBwdDataAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardDataWorkspaceSize(
        handle: cudnnHandle_t,
        wDesc: cudnnFilterDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dxDesc: cudnnTensorDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBackwardData(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        wDesc: cudnnFilterDescriptor_t,
        w: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdDataAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        dxDesc: cudnnTensorDescriptor_t,
        dx: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFoldedConvBackwardDataDescriptors(
        handle: cudnnHandle_t,
        filterDesc: cudnnFilterDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnTensorDescriptor_t,
        transformFormat: cudnnTensorFormat_t,
        foldedFilterDesc: cudnnFilterDescriptor_t,
        paddedDiffDesc: cudnnTensorDescriptor_t,
        foldedConvDesc: cudnnConvolutionDescriptor_t,
        foldedGradDesc: cudnnTensorDescriptor_t,
        filterFoldTransDesc: cudnnTensorTransformDescriptor_t,
        diffPadTransDesc: cudnnTensorTransformDescriptor_t,
        gradFoldTransDesc: cudnnTensorTransformDescriptor_t,
        gradUnfoldTransDesc: cudnnTensorTransformDescriptor_t,
    ) -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsConstParamStruct {
    _unused: [u8; 0],
}
pub type cudnnFusedOpsConstParamPack_t = *mut cudnnFusedOpsConstParamStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsVariantParamStruct {
    _unused: [u8; 0],
}
pub type cudnnFusedOpsVariantParamPack_t = *mut cudnnFusedOpsVariantParamStruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cudnnFusedOpsPlanStruct {
    _unused: [u8; 0],
}
pub type cudnnFusedOpsPlan_t = *mut cudnnFusedOpsPlanStruct;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOps_t {
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_CONV_BNSTATS = 0,
    CUDNN_FUSED_SCALE_BIAS_ACTIVATION_WGRAD = 1,
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_TRAINING = 2,
    CUDNN_FUSED_BN_FINALIZE_STATISTICS_INFERENCE = 3,
    CUDNN_FUSED_CONV_SCALE_BIAS_ADD_ACTIVATION = 4,
    CUDNN_FUSED_SCALE_BIAS_ADD_ACTIVATION_GEN_BITMASK = 5,
    CUDNN_FUSED_DACTIVATION_FORK_DBATCHNORM = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOpsConstParamLabel_t {
    CUDNN_PARAM_XDESC = 0,
    CUDNN_PARAM_XDATA_PLACEHOLDER = 1,
    CUDNN_PARAM_BN_MODE = 2,
    CUDNN_PARAM_BN_EQSCALEBIAS_DESC = 3,
    CUDNN_PARAM_BN_EQSCALE_PLACEHOLDER = 4,
    CUDNN_PARAM_BN_EQBIAS_PLACEHOLDER = 5,
    CUDNN_PARAM_ACTIVATION_DESC = 6,
    CUDNN_PARAM_CONV_DESC = 7,
    CUDNN_PARAM_WDESC = 8,
    CUDNN_PARAM_WDATA_PLACEHOLDER = 9,
    CUDNN_PARAM_DWDESC = 10,
    CUDNN_PARAM_DWDATA_PLACEHOLDER = 11,
    CUDNN_PARAM_YDESC = 12,
    CUDNN_PARAM_YDATA_PLACEHOLDER = 13,
    CUDNN_PARAM_DYDESC = 14,
    CUDNN_PARAM_DYDATA_PLACEHOLDER = 15,
    CUDNN_PARAM_YSTATS_DESC = 16,
    CUDNN_PARAM_YSUM_PLACEHOLDER = 17,
    CUDNN_PARAM_YSQSUM_PLACEHOLDER = 18,
    CUDNN_PARAM_BN_SCALEBIAS_MEANVAR_DESC = 19,
    CUDNN_PARAM_BN_SCALE_PLACEHOLDER = 20,
    CUDNN_PARAM_BN_BIAS_PLACEHOLDER = 21,
    CUDNN_PARAM_BN_SAVED_MEAN_PLACEHOLDER = 22,
    CUDNN_PARAM_BN_SAVED_INVSTD_PLACEHOLDER = 23,
    CUDNN_PARAM_BN_RUNNING_MEAN_PLACEHOLDER = 24,
    CUDNN_PARAM_BN_RUNNING_VAR_PLACEHOLDER = 25,
    CUDNN_PARAM_ZDESC = 26,
    CUDNN_PARAM_ZDATA_PLACEHOLDER = 27,
    CUDNN_PARAM_BN_Z_EQSCALEBIAS_DESC = 28,
    CUDNN_PARAM_BN_Z_EQSCALE_PLACEHOLDER = 29,
    CUDNN_PARAM_BN_Z_EQBIAS_PLACEHOLDER = 30,
    CUDNN_PARAM_ACTIVATION_BITMASK_DESC = 31,
    CUDNN_PARAM_ACTIVATION_BITMASK_PLACEHOLDER = 32,
    CUDNN_PARAM_DXDESC = 33,
    CUDNN_PARAM_DXDATA_PLACEHOLDER = 34,
    CUDNN_PARAM_DZDESC = 35,
    CUDNN_PARAM_DZDATA_PLACEHOLDER = 36,
    CUDNN_PARAM_BN_DSCALE_PLACEHOLDER = 37,
    CUDNN_PARAM_BN_DBIAS_PLACEHOLDER = 38,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOpsPointerPlaceHolder_t {
    CUDNN_PTR_NULL = 0,
    CUDNN_PTR_ELEM_ALIGNED = 1,
    CUDNN_PTR_16B_ALIGNED = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnFusedOpsVariantParamLabel_t {
    CUDNN_PTR_XDATA = 0,
    CUDNN_PTR_BN_EQSCALE = 1,
    CUDNN_PTR_BN_EQBIAS = 2,
    CUDNN_PTR_WDATA = 3,
    CUDNN_PTR_DWDATA = 4,
    CUDNN_PTR_YDATA = 5,
    CUDNN_PTR_DYDATA = 6,
    CUDNN_PTR_YSUM = 7,
    CUDNN_PTR_YSQSUM = 8,
    CUDNN_PTR_WORKSPACE = 9,
    CUDNN_PTR_BN_SCALE = 10,
    CUDNN_PTR_BN_BIAS = 11,
    CUDNN_PTR_BN_SAVED_MEAN = 12,
    CUDNN_PTR_BN_SAVED_INVSTD = 13,
    CUDNN_PTR_BN_RUNNING_MEAN = 14,
    CUDNN_PTR_BN_RUNNING_VAR = 15,
    CUDNN_PTR_ZDATA = 16,
    CUDNN_PTR_BN_Z_EQSCALE = 17,
    CUDNN_PTR_BN_Z_EQBIAS = 18,
    CUDNN_PTR_ACTIVATION_BITMASK = 19,
    CUDNN_PTR_DXDATA = 20,
    CUDNN_PTR_DZDATA = 21,
    CUDNN_PTR_BN_DSCALE = 22,
    CUDNN_PTR_BN_DBIAS = 23,
    CUDNN_SCALAR_SIZE_T_WORKSPACE_SIZE_IN_BYTES = 100,
    CUDNN_SCALAR_INT64_T_BN_ACCUMULATION_COUNT = 101,
    CUDNN_SCALAR_DOUBLE_BN_EXP_AVG_FACTOR = 102,
    CUDNN_SCALAR_DOUBLE_BN_EPSILON = 103,
}
extern "C" {
    pub fn cudnnCnnInferVersionCheck() -> cudnnStatus_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct cudnnConvolutionBwdFilterAlgoPerfStruct {
    pub algo: cudnnConvolutionBwdFilterAlgo_t,
    pub status: cudnnStatus_t,
    pub time: f32,
    pub memory: usize,
    pub determinism: cudnnDeterminism_t,
    pub mathType: cudnnMathType_t,
    pub reserved: [::std::os::raw::c_int; 3usize],
}
#[test]
fn bindgen_test_layout_cudnnConvolutionBwdFilterAlgoPerfStruct() {
    assert_eq!(
        ::core::mem::size_of::<cudnnConvolutionBwdFilterAlgoPerfStruct>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnConvolutionBwdFilterAlgoPerfStruct>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).algo as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(algo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).status as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).time as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).memory as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).determinism
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(determinism)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).mathType
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(mathType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnConvolutionBwdFilterAlgoPerfStruct>())).reserved
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnConvolutionBwdFilterAlgoPerfStruct),
            "::",
            stringify!(reserved)
        )
    );
}
impl Default for cudnnConvolutionBwdFilterAlgoPerfStruct {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type cudnnConvolutionBwdFilterAlgoPerf_t = cudnnConvolutionBwdFilterAlgoPerfStruct;
extern "C" {
    pub fn cudnnGetConvolutionBackwardFilterAlgorithmMaxCount(
        handle: cudnnHandle_t,
        count: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardFilterAlgorithm(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFindConvolutionBackwardFilterAlgorithmEx(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        y: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardFilterAlgorithm_v7(
        handle: cudnnHandle_t,
        srcDesc: cudnnTensorDescriptor_t,
        diffDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        requestedAlgoCount: ::std::os::raw::c_int,
        returnedAlgoCount: *mut ::std::os::raw::c_int,
        perfResults: *mut cudnnConvolutionBwdFilterAlgoPerf_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetConvolutionBackwardFilterWorkspaceSize(
        handle: cudnnHandle_t,
        xDesc: cudnnTensorDescriptor_t,
        dyDesc: cudnnTensorDescriptor_t,
        convDesc: cudnnConvolutionDescriptor_t,
        gradDesc: cudnnFilterDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        sizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBackwardFilter(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        xDesc: cudnnTensorDescriptor_t,
        x: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        convDesc: cudnnConvolutionDescriptor_t,
        algo: cudnnConvolutionBwdFilterAlgo_t,
        workSpace: *mut ::core::ffi::c_void,
        workSpaceSizeInBytes: usize,
        beta: *const ::core::ffi::c_void,
        dwDesc: cudnnFilterDescriptor_t,
        dw: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnConvolutionBackwardBias(
        handle: cudnnHandle_t,
        alpha: *const ::core::ffi::c_void,
        dyDesc: cudnnTensorDescriptor_t,
        dy: *const ::core::ffi::c_void,
        beta: *const ::core::ffi::c_void,
        dbDesc: cudnnTensorDescriptor_t,
        db: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFusedOpsConstParamPack(
        constPack: *mut cudnnFusedOpsConstParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFusedOpsConstParamPack(
        constPack: cudnnFusedOpsConstParamPack_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFusedOpsConstParamPackAttribute(
        constPack: cudnnFusedOpsConstParamPack_t,
        paramLabel: cudnnFusedOpsConstParamLabel_t,
        param: *mut ::core::ffi::c_void,
        isNULL: *mut ::std::os::raw::c_int,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFusedOpsVariantParamPack(
        varPack: *mut cudnnFusedOpsVariantParamPack_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFusedOpsVariantParamPack(
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnSetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnGetFusedOpsVariantParamPackAttribute(
        varPack: cudnnFusedOpsVariantParamPack_t,
        paramLabel: cudnnFusedOpsVariantParamLabel_t,
        ptr: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCreateFusedOpsPlan(
        plan: *mut cudnnFusedOpsPlan_t,
        ops: cudnnFusedOps_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnDestroyFusedOpsPlan(plan: cudnnFusedOpsPlan_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnMakeFusedOpsPlan(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        constPack: cudnnFusedOpsConstParamPack_t,
        workspaceSizeInBytes: *mut usize,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnFusedOpsExecute(
        handle: cudnnHandle_t,
        plan: cudnnFusedOpsPlan_t,
        varPack: cudnnFusedOpsVariantParamPack_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnCnnTrainVersionCheck() -> cudnnStatus_t;
}
pub type cudnnBackendDescriptor_t = *mut ::core::ffi::c_void;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct cudnnFractionStruct {
    pub numerator: i64,
    pub denominator: i64,
}
#[test]
fn bindgen_test_layout_cudnnFractionStruct() {
    assert_eq!(
        ::core::mem::size_of::<cudnnFractionStruct>(),
        16usize,
        concat!("Size of: ", stringify!(cudnnFractionStruct))
    );
    assert_eq!(
        ::core::mem::align_of::<cudnnFractionStruct>(),
        8usize,
        concat!("Alignment of ", stringify!(cudnnFractionStruct))
    );
    assert_eq!(
        unsafe { &(*(::core::ptr::null::<cudnnFractionStruct>())).numerator as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnFractionStruct),
            "::",
            stringify!(numerator)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::core::ptr::null::<cudnnFractionStruct>())).denominator as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(cudnnFractionStruct),
            "::",
            stringify!(denominator)
        )
    );
}
pub type cudnnFraction_t = cudnnFractionStruct;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnPointwiseMode_t {
    CUDNN_POINTWISE_ADD = 0,
    CUDNN_POINTWISE_ADD_SQUARE = 5,
    CUDNN_POINTWISE_DIV = 6,
    CUDNN_POINTWISE_MAX = 3,
    CUDNN_POINTWISE_MIN = 2,
    CUDNN_POINTWISE_MOD = 7,
    CUDNN_POINTWISE_MUL = 1,
    CUDNN_POINTWISE_POW = 8,
    CUDNN_POINTWISE_SUB = 9,
    CUDNN_POINTWISE_ABS = 10,
    CUDNN_POINTWISE_CEIL = 11,
    CUDNN_POINTWISE_COS = 12,
    CUDNN_POINTWISE_EXP = 13,
    CUDNN_POINTWISE_FLOOR = 14,
    CUDNN_POINTWISE_LOG = 15,
    CUDNN_POINTWISE_NEG = 16,
    CUDNN_POINTWISE_RSQRT = 17,
    CUDNN_POINTWISE_SIN = 18,
    CUDNN_POINTWISE_SQRT = 4,
    CUDNN_POINTWISE_TAN = 19,
    CUDNN_POINTWISE_ERF = 20,
    CUDNN_POINTWISE_IDENTITY = 21,
    CUDNN_POINTWISE_RELU_FWD = 100,
    CUDNN_POINTWISE_TANH_FWD = 101,
    CUDNN_POINTWISE_SIGMOID_FWD = 102,
    CUDNN_POINTWISE_ELU_FWD = 103,
    CUDNN_POINTWISE_GELU_FWD = 104,
    CUDNN_POINTWISE_SOFTPLUS_FWD = 105,
    CUDNN_POINTWISE_SWISH_FWD = 106,
    CUDNN_POINTWISE_GELU_APPROX_TANH_FWD = 107,
    CUDNN_POINTWISE_RELU_BWD = 200,
    CUDNN_POINTWISE_TANH_BWD = 201,
    CUDNN_POINTWISE_SIGMOID_BWD = 202,
    CUDNN_POINTWISE_ELU_BWD = 203,
    CUDNN_POINTWISE_GELU_BWD = 204,
    CUDNN_POINTWISE_SOFTPLUS_BWD = 205,
    CUDNN_POINTWISE_SWISH_BWD = 206,
    CUDNN_POINTWISE_GELU_APPROX_TANH_BWD = 207,
    CUDNN_POINTWISE_CMP_EQ = 300,
    CUDNN_POINTWISE_CMP_NEQ = 301,
    CUDNN_POINTWISE_CMP_GT = 302,
    CUDNN_POINTWISE_CMP_GE = 303,
    CUDNN_POINTWISE_CMP_LT = 304,
    CUDNN_POINTWISE_CMP_LE = 305,
    CUDNN_POINTWISE_LOGICAL_AND = 400,
    CUDNN_POINTWISE_LOGICAL_OR = 401,
    CUDNN_POINTWISE_LOGICAL_NOT = 402,
    CUDNN_POINTWISE_GEN_INDEX = 501,
    CUDNN_POINTWISE_BINARY_SELECT = 601,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnResampleMode_t {
    CUDNN_RESAMPLE_NEAREST = 0,
    CUDNN_RESAMPLE_BILINEAR = 1,
    CUDNN_RESAMPLE_AVGPOOL = 2,
    CUDNN_RESAMPLE_MAXPOOL = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnSignalMode_t {
    CUDNN_SIGNAL_SET = 0,
    CUDNN_SIGNAL_WAIT = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnGenStatsMode_t {
    CUDNN_GENSTATS_SUM_SQSUM = 0,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBnFinalizeStatsMode_t {
    CUDNN_BN_FINALIZE_STATISTICS_TRAINING = 0,
    CUDNN_BN_FINALIZE_STATISTICS_INFERENCE = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendAttributeName_t {
    CUDNN_ATTR_POINTWISE_MODE = 0,
    CUDNN_ATTR_POINTWISE_MATH_PREC = 1,
    CUDNN_ATTR_POINTWISE_NAN_PROPAGATION = 2,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP = 3,
    CUDNN_ATTR_POINTWISE_RELU_UPPER_CLIP = 4,
    CUDNN_ATTR_POINTWISE_RELU_LOWER_CLIP_SLOPE = 5,
    CUDNN_ATTR_POINTWISE_ELU_ALPHA = 6,
    CUDNN_ATTR_POINTWISE_SOFTPLUS_BETA = 7,
    CUDNN_ATTR_POINTWISE_SWISH_BETA = 8,
    CUDNN_ATTR_POINTWISE_AXIS = 9,
    CUDNN_ATTR_CONVOLUTION_COMP_TYPE = 100,
    CUDNN_ATTR_CONVOLUTION_CONV_MODE = 101,
    CUDNN_ATTR_CONVOLUTION_DILATIONS = 102,
    CUDNN_ATTR_CONVOLUTION_FILTER_STRIDES = 103,
    CUDNN_ATTR_CONVOLUTION_POST_PADDINGS = 104,
    CUDNN_ATTR_CONVOLUTION_PRE_PADDINGS = 105,
    CUDNN_ATTR_CONVOLUTION_SPATIAL_DIMS = 106,
    CUDNN_ATTR_ENGINEHEUR_MODE = 200,
    CUDNN_ATTR_ENGINEHEUR_OPERATION_GRAPH = 201,
    CUDNN_ATTR_ENGINEHEUR_RESULTS = 202,
    CUDNN_ATTR_ENGINECFG_ENGINE = 300,
    CUDNN_ATTR_ENGINECFG_INTERMEDIATE_INFO = 301,
    CUDNN_ATTR_ENGINECFG_KNOB_CHOICES = 302,
    CUDNN_ATTR_EXECUTION_PLAN_HANDLE = 400,
    CUDNN_ATTR_EXECUTION_PLAN_ENGINE_CONFIG = 401,
    CUDNN_ATTR_EXECUTION_PLAN_WORKSPACE_SIZE = 402,
    CUDNN_ATTR_EXECUTION_PLAN_COMPUTED_INTERMEDIATE_UIDS = 403,
    CUDNN_ATTR_EXECUTION_PLAN_RUN_ONLY_INTERMEDIATE_UIDS = 404,
    CUDNN_ATTR_EXECUTION_PLAN_JSON_REPRESENTATION = 405,
    CUDNN_ATTR_INTERMEDIATE_INFO_UNIQUE_ID = 500,
    CUDNN_ATTR_INTERMEDIATE_INFO_SIZE = 501,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_DATA_UIDS = 502,
    CUDNN_ATTR_INTERMEDIATE_INFO_DEPENDENT_ATTRIBUTES = 503,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_TYPE = 600,
    CUDNN_ATTR_KNOB_CHOICE_KNOB_VALUE = 601,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_ALPHA = 700,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_BETA = 701,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_CONV_DESC = 702,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_W = 703,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_X = 704,
    CUDNN_ATTR_OPERATION_CONVOLUTION_FORWARD_Y = 705,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_ALPHA = 706,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_BETA = 707,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_CONV_DESC = 708,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_W = 709,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DX = 710,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_DATA_DY = 711,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_ALPHA = 712,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_BETA = 713,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_CONV_DESC = 714,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DW = 715,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_X = 716,
    CUDNN_ATTR_OPERATION_CONVOLUTION_BWD_FILTER_DY = 717,
    CUDNN_ATTR_OPERATION_POINTWISE_PW_DESCRIPTOR = 750,
    CUDNN_ATTR_OPERATION_POINTWISE_XDESC = 751,
    CUDNN_ATTR_OPERATION_POINTWISE_BDESC = 752,
    CUDNN_ATTR_OPERATION_POINTWISE_YDESC = 753,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA1 = 754,
    CUDNN_ATTR_OPERATION_POINTWISE_ALPHA2 = 755,
    CUDNN_ATTR_OPERATION_POINTWISE_DXDESC = 756,
    CUDNN_ATTR_OPERATION_POINTWISE_DYDESC = 757,
    CUDNN_ATTR_OPERATION_POINTWISE_TDESC = 758,
    CUDNN_ATTR_OPERATION_GENSTATS_MODE = 770,
    CUDNN_ATTR_OPERATION_GENSTATS_MATH_PREC = 771,
    CUDNN_ATTR_OPERATION_GENSTATS_XDESC = 772,
    CUDNN_ATTR_OPERATION_GENSTATS_SUMDESC = 773,
    CUDNN_ATTR_OPERATION_GENSTATS_SQSUMDESC = 774,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_STATS_MODE = 780,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_MATH_PREC = 781,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SUM_DESC = 782,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_Y_SQ_SUM_DESC = 783,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SCALE_DESC = 784,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_BIAS_DESC = 785,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_MEAN_DESC = 786,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_PREV_RUNNING_VAR_DESC = 787,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_MEAN_DESC = 788,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_UPDATED_RUNNING_VAR_DESC = 789,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_MEAN_DESC = 790,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_SAVED_INV_STD_DESC = 791,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_SCALE_DESC = 792,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EQ_BIAS_DESC = 793,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_ACCUM_COUNT_DESC = 794,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EPSILON_DESC = 795,
    CUDNN_ATTR_OPERATION_BN_FINALIZE_EXP_AVERATE_FACTOR_DESC = 796,
    CUDNN_ATTR_OPERATIONGRAPH_HANDLE = 800,
    CUDNN_ATTR_OPERATIONGRAPH_OPS = 801,
    CUDNN_ATTR_OPERATIONGRAPH_ENGINE_GLOBAL_COUNT = 802,
    CUDNN_ATTR_TENSOR_BYTE_ALIGNMENT = 900,
    CUDNN_ATTR_TENSOR_DATA_TYPE = 901,
    CUDNN_ATTR_TENSOR_DIMENSIONS = 902,
    CUDNN_ATTR_TENSOR_STRIDES = 903,
    CUDNN_ATTR_TENSOR_VECTOR_COUNT = 904,
    CUDNN_ATTR_TENSOR_VECTORIZED_DIMENSION = 905,
    CUDNN_ATTR_TENSOR_UNIQUE_ID = 906,
    CUDNN_ATTR_TENSOR_IS_VIRTUAL = 907,
    CUDNN_ATTR_TENSOR_IS_BY_VALUE = 908,
    CUDNN_ATTR_TENSOR_REORDERING_MODE = 909,
    CUDNN_ATTR_VARIANT_PACK_UNIQUE_IDS = 1000,
    CUDNN_ATTR_VARIANT_PACK_DATA_POINTERS = 1001,
    CUDNN_ATTR_VARIANT_PACK_INTERMEDIATES = 1002,
    CUDNN_ATTR_VARIANT_PACK_WORKSPACE = 1003,
    CUDNN_ATTR_LAYOUT_INFO_TENSOR_UID = 1100,
    CUDNN_ATTR_LAYOUT_INFO_TYPES = 1101,
    CUDNN_ATTR_KNOB_INFO_TYPE = 1200,
    CUDNN_ATTR_KNOB_INFO_MAXIMUM_VALUE = 1201,
    CUDNN_ATTR_KNOB_INFO_MINIMUM_VALUE = 1202,
    CUDNN_ATTR_KNOB_INFO_STRIDE = 1203,
    CUDNN_ATTR_ENGINE_OPERATION_GRAPH = 1300,
    CUDNN_ATTR_ENGINE_GLOBAL_INDEX = 1301,
    CUDNN_ATTR_ENGINE_KNOB_INFO = 1302,
    CUDNN_ATTR_ENGINE_NUMERICAL_NOTE = 1303,
    CUDNN_ATTR_ENGINE_LAYOUT_INFO = 1304,
    CUDNN_ATTR_ENGINE_BEHAVIOR_NOTE = 1305,
    CUDNN_ATTR_MATMUL_COMP_TYPE = 1500,
    CUDNN_ATTR_OPERATION_MATMUL_ADESC = 1520,
    CUDNN_ATTR_OPERATION_MATMUL_BDESC = 1521,
    CUDNN_ATTR_OPERATION_MATMUL_CDESC = 1522,
    CUDNN_ATTR_OPERATION_MATMUL_DESC = 1523,
    CUDNN_ATTR_OPERATION_MATMUL_IRREGULARLY_STRIDED_BATCH_COUNT = 1524,
    CUDNN_ATTR_REDUCTION_OPERATOR = 1600,
    CUDNN_ATTR_REDUCTION_COMP_TYPE = 1601,
    CUDNN_ATTR_OPERATION_REDUCTION_XDESC = 1610,
    CUDNN_ATTR_OPERATION_REDUCTION_YDESC = 1611,
    CUDNN_ATTR_OPERATION_REDUCTION_DESC = 1612,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MATH_PREC = 1620,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_MEAN_DESC = 1621,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_INVSTD_DESC = 1622,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_BN_SCALE_DESC = 1623,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_X_DESC = 1624,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DY_DESC = 1625,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_SCALE_DESC = 1626,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_DBN_BIAS_DESC = 1627,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_DY_SCALE_DESC = 1628,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_X_SCALE_DESC = 1629,
    CUDNN_ATTR_OPERATION_BN_BWD_WEIGHTS_EQ_BIAS = 1630,
    CUDNN_ATTR_RESAMPLE_MODE = 1700,
    CUDNN_ATTR_RESAMPLE_COMP_TYPE = 1701,
    CUDNN_ATTR_RESAMPLE_SPATIAL_DIMS = 1702,
    CUDNN_ATTR_RESAMPLE_POST_PADDINGS = 1703,
    CUDNN_ATTR_RESAMPLE_PRE_PADDINGS = 1704,
    CUDNN_ATTR_RESAMPLE_STRIDES = 1705,
    CUDNN_ATTR_RESAMPLE_WINDOW_DIMS = 1706,
    CUDNN_ATTR_RESAMPLE_NAN_PROPAGATION = 1707,
    CUDNN_ATTR_RESAMPLE_PADDING_MODE = 1708,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_XDESC = 1710,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_YDESC = 1711,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_IDXDESC = 1712,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_ALPHA = 1713,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_BETA = 1714,
    CUDNN_ATTR_OPERATION_RESAMPLE_FWD_DESC = 1716,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DXDESC = 1720,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DYDESC = 1721,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_IDXDESC = 1722,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_ALPHA = 1723,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_BETA = 1724,
    CUDNN_ATTR_OPERATION_RESAMPLE_BWD_DESC = 1725,
    CUDNN_ATTR_OPERATION_CONCAT_AXIS = 1800,
    CUDNN_ATTR_OPERATION_CONCAT_INPUT_DESCS = 1801,
    CUDNN_ATTR_OPERATION_CONCAT_INPLACE_INDEX = 1802,
    CUDNN_ATTR_OPERATION_CONCAT_OUTPUT_DESC = 1803,
    CUDNN_ATTR_OPERATION_SIGNAL_MODE = 1900,
    CUDNN_ATTR_OPERATION_SIGNAL_FLAGDESC = 1901,
    CUDNN_ATTR_OPERATION_SIGNAL_VALUE = 1902,
    CUDNN_ATTR_OPERATION_SIGNAL_XDESC = 1903,
    CUDNN_ATTR_OPERATION_SIGNAL_YDESC = 1904,
    CUDNN_ATTR_OPERATION_NORM_FWD_MODE = 2000,
    CUDNN_ATTR_OPERATION_NORM_FWD_PHASE = 2001,
    CUDNN_ATTR_OPERATION_NORM_FWD_XDESC = 2002,
    CUDNN_ATTR_OPERATION_NORM_FWD_MEAN_DESC = 2003,
    CUDNN_ATTR_OPERATION_NORM_FWD_INV_VARIANCE_DESC = 2004,
    CUDNN_ATTR_OPERATION_NORM_FWD_SCALE_DESC = 2005,
    CUDNN_ATTR_OPERATION_NORM_FWD_BIAS_DESC = 2006,
    CUDNN_ATTR_OPERATION_NORM_FWD_EPSILON_DESC = 2007,
    CUDNN_ATTR_OPERATION_NORM_FWD_EXP_AVG_FACTOR_DESC = 2008,
    CUDNN_ATTR_OPERATION_NORM_FWD_INPUT_RUNNING_MEAN_DESC = 2009,
    CUDNN_ATTR_OPERATION_NORM_FWD_INPUT_RUNNING_VAR_DESC = 2010,
    CUDNN_ATTR_OPERATION_NORM_FWD_OUTPUT_RUNNING_MEAN_DESC = 2011,
    CUDNN_ATTR_OPERATION_NORM_FWD_OUTPUT_RUNNING_VAR_DESC = 2012,
    CUDNN_ATTR_OPERATION_NORM_FWD_YDESC = 2013,
    CUDNN_ATTR_OPERATION_NORM_FWD_PEER_STAT_DESCS = 2014,
    CUDNN_ATTR_OPERATION_NORM_BWD_MODE = 2100,
    CUDNN_ATTR_OPERATION_NORM_BWD_XDESC = 2101,
    CUDNN_ATTR_OPERATION_NORM_BWD_MEAN_DESC = 2102,
    CUDNN_ATTR_OPERATION_NORM_BWD_INV_VARIANCE_DESC = 2103,
    CUDNN_ATTR_OPERATION_NORM_BWD_DYDESC = 2104,
    CUDNN_ATTR_OPERATION_NORM_BWD_SCALE_DESC = 2105,
    CUDNN_ATTR_OPERATION_NORM_BWD_EPSILON_DESC = 2106,
    CUDNN_ATTR_OPERATION_NORM_BWD_DSCALE_DESC = 2107,
    CUDNN_ATTR_OPERATION_NORM_BWD_DBIAS_DESC = 2108,
    CUDNN_ATTR_OPERATION_NORM_BWD_DXDESC = 2109,
    CUDNN_ATTR_OPERATION_NORM_BWD_PEER_STAT_DESCS = 2110,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendAttributeType_t {
    CUDNN_TYPE_HANDLE = 0,
    CUDNN_TYPE_DATA_TYPE = 1,
    CUDNN_TYPE_BOOLEAN = 2,
    CUDNN_TYPE_INT64 = 3,
    CUDNN_TYPE_FLOAT = 4,
    CUDNN_TYPE_DOUBLE = 5,
    CUDNN_TYPE_VOID_PTR = 6,
    CUDNN_TYPE_CONVOLUTION_MODE = 7,
    CUDNN_TYPE_HEUR_MODE = 8,
    CUDNN_TYPE_KNOB_TYPE = 9,
    CUDNN_TYPE_NAN_PROPOGATION = 10,
    CUDNN_TYPE_NUMERICAL_NOTE = 11,
    CUDNN_TYPE_LAYOUT_TYPE = 12,
    CUDNN_TYPE_ATTRIB_NAME = 13,
    CUDNN_TYPE_POINTWISE_MODE = 14,
    CUDNN_TYPE_BACKEND_DESCRIPTOR = 15,
    CUDNN_TYPE_GENSTATS_MODE = 16,
    CUDNN_TYPE_BN_FINALIZE_STATS_MODE = 17,
    CUDNN_TYPE_REDUCTION_OPERATOR_TYPE = 18,
    CUDNN_TYPE_BEHAVIOR_NOTE = 19,
    CUDNN_TYPE_TENSOR_REORDERING_MODE = 20,
    CUDNN_TYPE_RESAMPLE_MODE = 21,
    CUDNN_TYPE_PADDING_MODE = 22,
    CUDNN_TYPE_INT32 = 23,
    CUDNN_TYPE_CHAR = 24,
    CUDNN_TYPE_SIGNAL_MODE = 25,
    CUDNN_TYPE_FRACTION = 26,
    CUDNN_TYPE_NORM_MODE = 27,
    CUDNN_TYPE_NORM_FWD_PHASE = 28,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendDescriptorType_t {
    CUDNN_BACKEND_POINTWISE_DESCRIPTOR = 0,
    CUDNN_BACKEND_CONVOLUTION_DESCRIPTOR = 1,
    CUDNN_BACKEND_ENGINE_DESCRIPTOR = 2,
    CUDNN_BACKEND_ENGINECFG_DESCRIPTOR = 3,
    CUDNN_BACKEND_ENGINEHEUR_DESCRIPTOR = 4,
    CUDNN_BACKEND_EXECUTION_PLAN_DESCRIPTOR = 5,
    CUDNN_BACKEND_INTERMEDIATE_INFO_DESCRIPTOR = 6,
    CUDNN_BACKEND_KNOB_CHOICE_DESCRIPTOR = 7,
    CUDNN_BACKEND_KNOB_INFO_DESCRIPTOR = 8,
    CUDNN_BACKEND_LAYOUT_INFO_DESCRIPTOR = 9,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_FORWARD_DESCRIPTOR = 10,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_FILTER_DESCRIPTOR = 11,
    CUDNN_BACKEND_OPERATION_CONVOLUTION_BACKWARD_DATA_DESCRIPTOR = 12,
    CUDNN_BACKEND_OPERATION_POINTWISE_DESCRIPTOR = 13,
    CUDNN_BACKEND_OPERATION_GEN_STATS_DESCRIPTOR = 14,
    CUDNN_BACKEND_OPERATIONGRAPH_DESCRIPTOR = 15,
    CUDNN_BACKEND_VARIANT_PACK_DESCRIPTOR = 16,
    CUDNN_BACKEND_TENSOR_DESCRIPTOR = 17,
    CUDNN_BACKEND_MATMUL_DESCRIPTOR = 18,
    CUDNN_BACKEND_OPERATION_MATMUL_DESCRIPTOR = 19,
    CUDNN_BACKEND_OPERATION_BN_FINALIZE_STATISTICS_DESCRIPTOR = 20,
    CUDNN_BACKEND_REDUCTION_DESCRIPTOR = 21,
    CUDNN_BACKEND_OPERATION_REDUCTION_DESCRIPTOR = 22,
    CUDNN_BACKEND_OPERATION_BN_BWD_WEIGHTS_DESCRIPTOR = 23,
    CUDNN_BACKEND_RESAMPLE_DESCRIPTOR = 24,
    CUDNN_BACKEND_OPERATION_RESAMPLE_FWD_DESCRIPTOR = 25,
    CUDNN_BACKEND_OPERATION_RESAMPLE_BWD_DESCRIPTOR = 26,
    CUDNN_BACKEND_OPERATION_CONCAT_DESCRIPTOR = 27,
    CUDNN_BACKEND_OPERATION_SIGNAL_DESCRIPTOR = 28,
    CUDNN_BACKEND_OPERATION_NORM_FORWARD_DESCRIPTOR = 29,
    CUDNN_BACKEND_OPERATION_NORM_BACKWARD_DESCRIPTOR = 30,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendNumericalNote_t {
    CUDNN_NUMERICAL_NOTE_TENSOR_CORE = 0,
    CUDNN_NUMERICAL_NOTE_DOWN_CONVERT_INPUTS = 1,
    CUDNN_NUMERICAL_NOTE_REDUCED_PRECISION_REDUCTION = 2,
    CUDNN_NUMERICAL_NOTE_FFT = 3,
    CUDNN_NUMERICAL_NOTE_NONDETERMINISTIC = 4,
    CUDNN_NUMERICAL_NOTE_WINOGRAD = 5,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_4x4 = 6,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_6x6 = 7,
    CUDNN_NUMERICAL_NOTE_WINOGRAD_TILE_13x13 = 8,
    CUDNN_NUMERICAL_NOTE_TYPE_COUNT = 9,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendBehaviorNote_t {
    CUDNN_BEHAVIOR_NOTE_RUNTIME_COMPILATION = 0,
    CUDNN_BEHAVIOR_NOTE_REQUIRES_FILTER_INT8x32_REORDER = 1,
    CUDNN_BEHAVIOR_NOTE_REQUIRES_BIAS_INT8x32_REORDER = 2,
    CUDNN_BEHAVIOR_NOTE_TYPE_COUNT = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendKnobType_t {
    CUDNN_KNOB_TYPE_SPLIT_K = 0,
    CUDNN_KNOB_TYPE_SWIZZLE = 1,
    CUDNN_KNOB_TYPE_TILE_SIZE = 2,
    CUDNN_KNOB_TYPE_USE_TEX = 3,
    CUDNN_KNOB_TYPE_EDGE = 4,
    CUDNN_KNOB_TYPE_KBLOCK = 5,
    CUDNN_KNOB_TYPE_LDGA = 6,
    CUDNN_KNOB_TYPE_LDGB = 7,
    CUDNN_KNOB_TYPE_CHUNK_K = 8,
    CUDNN_KNOB_TYPE_SPLIT_H = 9,
    CUDNN_KNOB_TYPE_WINO_TILE = 10,
    CUDNN_KNOB_TYPE_MULTIPLY = 11,
    CUDNN_KNOB_TYPE_SPLIT_K_BUF = 12,
    CUDNN_KNOB_TYPE_TILEK = 13,
    CUDNN_KNOB_TYPE_STAGES = 14,
    CUDNN_KNOB_TYPE_REDUCTION_MODE = 15,
    CUDNN_KNOB_TYPE_CTA_SPLIT_K_MODE = 16,
    CUDNN_KNOB_TYPE_SPLIT_K_SLC = 17,
    CUDNN_KNOB_TYPE_IDX_MODE = 18,
    CUDNN_KNOB_TYPE_SLICED = 19,
    CUDNN_KNOB_TYPE_SPLIT_RS = 20,
    CUDNN_KNOB_TYPE_SINGLEBUFFER = 21,
    CUDNN_KNOB_TYPE_LDGC = 22,
    CUDNN_KNOB_TYPE_SPECFILT = 23,
    CUDNN_KNOB_TYPE_KERNEL_CFG = 24,
    CUDNN_KNOB_TYPE_WORKSPACE = 25,
    CUDNN_KNOB_TYPE_COUNTS = 26,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendLayoutType_t {
    CUDNN_LAYOUT_TYPE_PREFERRED_NCHW = 0,
    CUDNN_LAYOUT_TYPE_PREFERRED_NHWC = 1,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD4CK = 2,
    CUDNN_LAYOUT_TYPE_PREFERRED_PAD8CK = 3,
    CUDNN_LAYOUT_TYPE_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendHeurMode_t {
    CUDNN_HEUR_MODE_INSTANT = 0,
    CUDNN_HEUR_MODE_B = 1,
    CUDNN_HEUR_MODE_FALLBACK = 2,
    CUDNN_HEUR_MODE_A = 3,
    CUDNN_HEUR_MODES_COUNT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendTensorReordering_t {
    CUDNN_TENSOR_REORDERING_NONE = 0,
    CUDNN_TENSOR_REORDERING_INT8x32 = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnPaddingMode_t {
    CUDNN_ZERO_PAD = 0,
    CUDNN_NEG_INF_PAD = 1,
    CUDNN_EDGE_VAL_PAD = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendNormMode_t {
    CUDNN_LAYER_NORM = 0,
    CUDNN_INSTANCE_NORM = 1,
    CUDNN_BATCH_NORM = 2,
    CUDNN_GROUP_NORM = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum cudnnBackendNormFwdPhase_t {
    CUDNN_NORM_FWD_INFERENCE = 0,
    CUDNN_NORM_FWD_TRAINING = 1,
}
extern "C" {
    pub fn cudnnBackendCreateDescriptor(
        descriptorType: cudnnBackendDescriptorType_t,
        descriptor: *mut cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendDestroyDescriptor(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendInitialize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendFinalize(descriptor: cudnnBackendDescriptor_t) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendSetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        elementCount: i64,
        arrayOfElements: *const ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendGetAttribute(
        descriptor: cudnnBackendDescriptor_t,
        attributeName: cudnnBackendAttributeName_t,
        attributeType: cudnnBackendAttributeType_t,
        requestedElementCount: i64,
        elementCount: *mut i64,
        arrayOfElements: *mut ::core::ffi::c_void,
    ) -> cudnnStatus_t;
}
extern "C" {
    pub fn cudnnBackendExecute(
        handle: cudnnHandle_t,
        executionPlan: cudnnBackendDescriptor_t,
        variantPack: cudnnBackendDescriptor_t,
    ) -> cudnnStatus_t;
}
