# ChatGLM2-6B_fastllm

## 论文

`GLM: General Language Model Pretraining with Autoregressive Blank Infilling`

- [https://arxiv.org/abs/2103.10360](https://arxiv.org/abs/2103.10360)

## 模型结构

ChatGLM**2**-6B 是开源中英双语对话模型 [ChatGLM-6B](https://github.com/THUDM/ChatGLM-6B) 的第二代版本，在保留了初代模型对话流畅、部署门槛较低等众多优秀特性的基础之上，ChatGLM**2**-6B 引入了更好的模型效果，更长的上下文等新特性

<div align="center">
<img src="doc/transformers.jpg" width="300" height="400">
</div>




以下是ChatGLM2-6B的主要网络参数配置：


| 模型名称    | 隐含层维度 | 层数 | 头数 | 词表大小 | 位置编码 | 最大序列长度 |
| ----------- | ---------- | ---- | ---- | -------- | -------- | ------------ |
| ChatGLM2-6B | 4096       | 28   | 32   | 65024    | RoPE     | 32768        |

## 算法原理

ChatGLM2-6B基于GLM架构开发。GLM是一种基于Transformer的语言模型，以自回归空白填充为训练目标， 同时具备自回归和自编码能力。

<div align="center">
<img src="doc/GLM.png" width="550" height="200">
</div>

本项目主要针对ChatGLM2-6B推理性能优化，达到DCU平台较快的对话效果

## 环境配置

### 环境准备

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0
```

### 容器启动

模型推理容器启动命令参考如下，用户根据需要修改：

```
# <container_name> 自定义容器名
# <project_path> 当前工程所在路径
docker run -it --name=<container_name> -v <project_path>:/work -w /work --device=/dev/kfd --device=/dev/dri --security-opt seccomp=unconfined --cap-add=SYS_PTRACE --shm-size=16G --group-add 39 image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0 /bin/bash
```

### 安装方法

```
#进入本工程目录
cd package
python setup.py install
```

## 数据集

无

## 推理

### 原版模型下载

[原版模型下载]([THUDM/chatglm2-6b · Hugging Face](https://huggingface.co/THUDM/chatglm2-6b))

### ChatGLM2原版模型转换

```
# 将模型转换脚本chatglm_export.py移动到原版ChatGLM2-6B环境中，也可以使用"pip3 install -r requirements.txt"命令根据工程自带的requirements.txt安装相关依赖
# 如果使用自己finetune的模型需要修改chatglm_export.py文件中创建tokenizer, model时的模型存放路径
# 执行：
python3 chatglm_export.py chatglm2-6b-fp16.bin float16 # 导出fp16模型，参数为导出的模型路径
python3 chatglm_export.py chatglm2-6b-int8.bin int8 #    导出int8模型，参数为导出的模型路径
```


### 运行ChatGLM2-6B模型实例

```
# 命令行聊天程序，使用了模型创建以及流式对话效果
python cli_demo.py -p chatglm2-6b-fp16.bin

# 简易webui，需要先安装streamlit-chat，并且需要在容器启动时映射streamlit的端口到外部网络
streamlit run web_demo.py chatglm2-6b-fp16.bin 
```

### 推理性能测试

可以使用benchmark程序进行测速，根据./benchmark -h描述进行配置和测试，不同配置、不同输入，推理速度也会有一些差别

```
# 进入benchmark所在目录
cd benchmark

# 添加benchmark可执行权限
chmod +x benchmark

# 测试示例
./benchmark -p ../chatglm2-6b-int8.bin -f ../benchmark/prompts/beijing.txt -b 1
./benchmark -p ../chatglm2-6b-fp16.bin -f ../benchmark/prompts/hello.txt -b 512 -l 18
```

## result

![chatglm2-6b推理](doc/chatglm2-6b.gif)

### 精度

无

## 应用场景

### 算法类别

`自然语言处理`

### 热点应用行业

`医疗,科研,金融,教育`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/chatglm2-6b_fastllm

## 参考资料

https://github.com/THUDM/ChatGLM2-6B
