# ChatGLM2-6B_CPP

## 模型介绍
ChatGLM**2**-6B 是开源中英双语对话模型 [ChatGLM-6B](https://github.com/THUDM/ChatGLM-6B) 的第二代版本，在保留了初代模型对话流畅、部署门槛较低等众多优秀特性的基础之上，ChatGLM**2**-6B 引入了如下新特性：

1. **更强大的性能**：基于 ChatGLM 初代模型的开发经验，我们全面升级了 ChatGLM2-6B 的基座模型。ChatGLM2-6B 使用了 [GLM](https://github.com/THUDM/GLM) 的混合目标函数，经过了 1.4T 中英标识符的预训练与人类偏好对齐训练，[评测结果](https://github.com/THUDM/ChatGLM2-6B#评测结果)显示，相比于初代模型，ChatGLM2-6B 在 MMLU（+23%）、CEval（+33%）、GSM8K（+571%） 、BBH（+60%）等数据集上的性能取得了大幅度的提升，在同尺寸开源模型中具有较强的竞争力。
2. **更长的上下文**：基于 [FlashAttention](https://github.com/HazyResearch/flash-attention) 技术，我们将基座模型的上下文长度（Context Length）由 ChatGLM-6B 的 2K 扩展到了 32K，并在对话阶段使用 8K 的上下文长度训练。对于更长的上下文，我们发布了 [ChatGLM2-6B-32K](https://huggingface.co/THUDM/chatglm2-6b-32k) 模型。[LongBench](https://github.com/THUDM/LongBench) 的测评结果表明，在等量级的开源模型中，ChatGLM2-6B-32K 有着较为明显的竞争优势。
3. **更高效的推理**：基于 [Multi-Query Attention](http://arxiv.org/abs/1911.02150) 技术，ChatGLM2-6B 有更高效的推理速度和更低的显存占用：在官方的模型实现下，推理速度相比初代提升了 42%，INT4 量化下，6G 显存支持的对话长度由 1K 提升到了 8K。
4. **更开放的协议**：ChatGLM2-6B 权重对学术研究**完全开放**，在填写[问卷](https://open.bigmodel.cn/mla/form)进行登记后**亦允许免费商业使用**。

本项目主要针对ChatGLM2-6B在DCU平台的推理性能优化，达到DCU平台较快的对话效果。

## 模型推理

### 下载镜像

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:glm-ft-v1.0
```

### 安装方法

```
#进入本工程目录
cd package
python setup install
```

### ChatGLM2原版模型转换

```
# 将模型转换脚本chatglm_export.py移动到原版ChatGLM2-6B环境中，也可以根据工程自带的requirements.txt安装相关依赖
# 如果使用自己finetune的模型需要修改chatglm_export.py文件中创建tokenizer, model时的模型存放路径
# 执行：
python3 chatglm_export.py chatglm2-6b-fp16.bin float16 # 导出fp16模型，参数为导出的模型路径
python3 chatglm_export.py chatglm2-6b-fp16.bin int8 #    导出int8模型，参数为导出的模型路径
```


### 运行ChatGLM2-6B模型实例

```
# 命令行聊天程序，使用了模型创建以及流式对话效果
python cli_demo.py -p chatglm2-6b-fp16.bin

# 简易webui，需要先安装streamlit-chat
streamlit run web_demo.py chatglm2-6b-fp16.bin 
```

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/chatglm2-6b_cpp

## 参考

https://github.com/THUDM/ChatGLM2-6B
