# SAMURAI
SAMURAI 基于SAM2的Zero-Shot视觉跟踪模型。

## 论文
`SAMURAI: Adapting Segment Anything Model for Zero-Shot Visual Tracking with Motion-Aware Memory
`
- https://arxiv.org/abs/2411.11922

## 模型结构
<!-- 此处一句话简要介绍模型结构 -->
虽然 SAM2 模型在视频流上的目标分割效果非常出色，但是在精准的目标跟踪方面却略显粗糙，很难应对跟踪任务的复杂环境和各种遮挡、丢失等挑战。与此，SAMURAI 在 SAM2 模型基础上，通过结合时间运动线索和提出的运动感知记忆选择机制，有效地预测了对象运动并优化了掩码选择，在无需重新训练或微调的情况下实现了稳健且准确的跟踪。

<div align=center>
    <img src="./doc/sam2.png"/>
    <div >SAM2</div>
</div>


## 算法原理
SAMURAI 的算法原理如下图所示。主体结构设计遵循SAM2，并设计运动建模和记忆选择机制。\
运动建模（Motion Modeling）合并运动信息，有效地处理快速移动和遮挡的对象来增强 SAM2 的视觉跟踪准确性。\
运动感知的记忆选择机制（Memory Selection），该机制通过选择性存储相关框架来减少拥挤的场景中的错误，以运动和亲和力得分的混合来决定。

<div align=center>
    <img src="./doc/overview.jpg"/>
    <div >SAMURAI</div>
</div>

## 环境配置
```
mv samurai_pytorch samurai # 去框架名后缀
# docker的-v 路径、docker_name和imageID根据实际情况修改
# pip安装时如果出现下载慢可以尝试别的镜像源
```
### Docker（方法一）
<!-- 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤 -->
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu22.04-dtk24.04.3-py3.10 # 本镜像imageID为：0291c26699b0
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --network=host --name docker_name imageID bash
cd /your_code_path/samurai
cd sam2
pip install -e .
pip install -e ".[notebooks]"
cd ..
pip install -r requirements.txt
```
### Dockerfile（方法二）
<!-- 此处提供dockerfile的使用方法 -->
```
cd /your_code_path/samurai/docker
docker build --no-cache -t codestral:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --network=host --name docker_name imageID bash
cd /your_code_path/samurai
cd sam2
pip install -e .
pip install -e ".[notebooks]"
cd ..
pip install -r requirements.txt
```
### Anaconda（方法三）
<!-- 此处提供本地配置、编译的详细步骤，例如： -->

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动: dtk24.04.3
python: python3.10
pytorch: 2.3.0
```
`Tips：以上DTK驱动、python、pytorch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：
```
cd /your_code_path/samurai
cd sam2
pip install -e .
pip install -e ".[notebooks]"
cd ..
pip install -r requirements.txt
```
## 数据集
无

## 训练
无

## 推理
模型下载：
```
cd sam2/checkpoints
sh download_ckpts.sh
```

SAM2.1模型也可从 [SCNet](http://113.200.138.88:18080/aimodels/facebook) 上快速下载；

推理图片下载：

可以用 [GOT10k](http://113.200.138.88:18080/aidatasets/project-dependency/got10k) 的测试图片；\
也可以自行选择视频或者图片序列进行测试，只需要提供初始帧目标的坐标保存成txt即可，比如 data/GOT-10k_Test_000001，可供参考。

```
# 视频/图片序列
python scripts/demo.py --video_path <your_video.mp4 or your_frame_directory> --txt_path <path_to_first_frame_bbox.txt>
```

## result
<!-- 此处填算法效果测试图（包括输入、输出） -->


<div align=center>
    <img src="./doc/GOT-10k_Test_000001.mp4" width=600/>
    <div >推理结果</div>
</div>



### 精度
无。

<!-- | 加速卡 | lpips | clip sim |
| :-----| :----- | :---- |
| K100_AI | 0.115 | 0.977 | -->
<!-- | 单元格 | 单元格 | 单元格 | -->


## 应用场景
### 算法类别

<!-- 超出以上分类的类别命名也可参考此网址中的类别名：https://huggingface.co/ \ -->
`目标跟踪`

### 热点应用行业
<!-- 应用行业的填写需要做大量调研，从而为使用者提供专业、全面的推荐，除特殊算法，通常推荐数量>=3。 -->
`零售,制造,电商,医疗,教育`


## 源码仓库及问题反馈
<!-- - 此处填本项目gitlab地址 -->
- https://developer.sourcefind.cn/codes/modelzoo/samurai_pytorch
## 参考资料
- https://github.com/yangchris11/samurai

