# LettuceDetect

轻量级大模型RAG幻觉输出检测模型。

## 论文

`LettuceDetect: A Hallucination Detection Framework for RAG Applications`

* https://arxiv.org/pdf/2502.17125

## 模型结构

概模型基于`ModernBert`。ModernBERT是 BERT 的直接替代品，是一种最先进的纯编码器变压器架构，它结合了对原始 BERT 模型的多项现代设计改进，例如它使用旋转位置嵌入 （RoPe） 来处理多达 8,192 个令牌的序列，取消填充优化以消除填充令牌上的浪费计算，以及用于增强表达力和交替注意力以实现更高效的注意力计算的 GeGLU 激活层。

![alt text](readme_imgs/arch.png)


## 算法原理

该算法基于Bert，在计算loss时将`question`和`context`遮住，并对`answer`进行二分类，以此达到token级别的`幻觉`判断。

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10

    docker run --shm-size 100g --network=host --name=detect --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -e .

    pip install streamlit


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 100g --network=host --name=detect --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    
    pip install -e .

    pip install streamlit

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
python: 3.10
torch: 2.4.1
```

2、其他非特殊库直接按照requirements.txt安装

```
pip install -e .

pip install streamlit
```

## 数据集

RAGTruth [github](https://github.com/ParticleMedia/RAGTruth/tree/main/dataset) | [SCnet](http://113.200.138.88:18080/aidatasets/particlemedia/RAGTruth)

数据下载后保存在`data/ragtruth`目录（需自行创建），并使用如下脚本处理

```bash
python lettucedetect/preprocess/preprocess_ragtruth.py --input_dir data/ragtruth --output_dir data/ragtruth
```

## 训练

```bash
python scripts/train.py \
    --data-path data/ragtruth/ragtruth_data.json \
    --model-name /path/to/ModerBERT-base \
    --output-dir outputs/hallucination_detector \
    --batch-size 4 \
    --epochs 6 \
    --learning-rate 1e-5
```

## 推理

```bash
python scripts/evaluate.py \
    --model_path /path/to/hallucination_detector \
    --data_path data/ragtruth/ragtruth_data.json \
    --evaluation_type example_level
```

### streamlit

```bash
streamlit run demo/streamlit_demo.py
```

注意，在运行前请修改文件中的模型地址。

## result


### 精度

||F1-score|
|:---:|:---:|
|DCU|0.5588|
|N卡|0.5544|


## 应用场景

### 算法类别

`文本检测`

### 热点应用行业

`教育,零售,金融,通信`

## 预训练权重

|model|url|
|:---:|:---:|
|lettucedect-base-modernbert-en-v1|[hf](https://hf-mirror.com/KRLabsOrg/lettucedect-base-modernbert-en-v1) \| [SCnet](http://113.200.138.88:18080/aimodels/krlabsorg/lettucedect-base-modernbert-en-v1) |
|lettucedect-large-modernbert-en-v1|[hf](https://hf-mirror.com/KRLabsOrg/lettucedect-large-modernbert-en-v1) \| [SCnet](http://113.200.138.88:18080/aimodels/krlabsorg/lettucedect-large-modernbert-en-v1) |
|ModernBERT-base|[hf](https://hf-mirror.com/answerdotai/ModernBERT-base/tree/main) \| [SCnet](http://113.200.138.88:18080/aimodels/answerdotai/ModernBERT-base)|
|ModernBERT-large|[hf](https://hf-mirror.com/answerdotai/ModernBERT-large) \| [SCnet](http://113.200.138.88:18080/aimodels/answerdotai/ModernBERT-large) |


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/lettucedetect_pytorch

## 参考资料

* https://github.com/KRLabsOrg/LettuceDetect
