set -x

CHECKPOINT=${1}
DATASET=${2}
export PYTHONPATH="${PYTHONPATH}:$(pwd)"
echo "CHECKPOINT: ${CHECKPOINT}"

if  [ ${DATASET} == "caption" ]; then
  torchrun \
    --nnodes=1 \
    --node_rank=0 \
    --master_addr=127.0.0.1 \
    --nproc_per_node=8 \
    --master_port=63667 \
    eval/evaluate_caption.py --checkpoint ${CHECKPOINT}
fi

if  [ ${DATASET} == "caption-coco" ]; then
  torchrun \
    --nnodes=1 \
    --node_rank=0 \
    --master_addr=127.0.0.1 \
    --nproc_per_node=8 \
    --master_port=63667 \
    eval/evaluate_caption.py --checkpoint ${CHECKPOINT} --datasets coco
fi

if  [ ${DATASET} == "caption-flickr30k" ]; then
  torchrun \
    --nnodes=1 \
    --node_rank=0 \
    --master_addr=127.0.0.1 \
    --nproc_per_node=8 \
    --master_port=63667 \
    eval/evaluate_caption.py --checkpoint ${CHECKPOINT} --datasets flickr30k
fi

if  [ ${DATASET} == "caption-nocaps" ]; then
  torchrun \
    --nnodes=1 \
    --node_rank=0 \
    --master_addr=127.0.0.1 \
    --nproc_per_node=8 \
    --master_port=63667 \
    eval/evaluate_caption.py --checkpoint ${CHECKPOINT} --datasets nocaps
fi
