import { app } from "../../../scripts/app.js";
import { ComfyWidgets } from "../../../scripts/widgets.js";

// Displays input text on a node
app.registerExtension({
	name: "EditOpenposeText",
	async beforeRegisterNodeDef(nodeType, nodeData, app) {
		if (nodeData.name === "OpenposeEditorNode") {
			function populate(text) {
                let removed = 0;
				if (this.widgets) {
					for (let i = 8; i < this.widgets.length; i++) {
                        if (this.widgets[i].name === "display_only") {
                            this.widgets[i].onRemove?.();
                            removed++;
                        }
					}
					this.widgets.length = this.widgets.length - removed;
				}

                if (this.inputs?.[0].link || this.inputs?.[this.inputs.length-1].widget) {
                    const v = [...text];
                    if (!v[0]) {
                        v.shift();
                    }
                    for (const list of v) {
                        // const w = this.widgets[0];
                        // w.value = list;
                        // if (this.inputs?.[this.inputs.length-1].widget) {

                        const w = ComfyWidgets["STRING"](this, "display_only", ["STRING", { multiline: true }], app).widget;
                        w.inputEl.readOnly = true;
                        w.inputEl.style.opacity = 0.6;
                        w.value = list;

                        //}
                    }
                } 

				requestAnimationFrame(() => {
					const sz = this.computeSize();
					if (sz[0] < this.size[0]) {
						sz[0] = this.size[0];
					}
					if (sz[1] < this.size[1]) {
						sz[1] = this.size[1];
					}
					this.onResize?.(sz);
					app.graph.setDirtyCanvas(true, false);
				});
			}

			// When the node is executed we will be sent the input text, display this in the widget
			const onExecuted = nodeType.prototype.onExecuted;
			nodeType.prototype.onExecuted = function (message) {
				onExecuted?.apply(this, arguments);
				populate.call(this, message.POSE_JSON);
			};

			const onConfigure = nodeType.prototype.onConfigure;
			nodeType.prototype.onConfigure = function () {
				onConfigure?.apply(this, arguments);
				if (this.widgets_values?.length) {
					// populate.call(this, this.widgets_values.slice(+this.widgets_values.length > 1));
				}
			};
		}
	},
});
