import {getLocale} from './utils.js'
const locale = getLocale()

const zhCN = {
    "Workflow created by": "工作流创建者",
    "Watch more video content": "观看更多视频内容",
    "Workflow Guide":"工作流指南",
    // ExtraMenu
    "💎 View Checkpoint Info...": "💎 查看 Checkpoint 信息...",
    "💎 View Lora Info...": "💎 查看 Lora 信息...",
    "🔃 Reload Node": "🔃 刷新节点",
    // ModelInfo
    "Updated At:": "最近更新：",
    "Created At:": "首次发布：",
    "✏️ Edit": "✏️ 编辑",
    "💾 Save": "💾 保存",
    "No notes": "当前还没有备注内容",
    "Saving Notes...": "正在保存备注...",
    "Type your notes here":"在这里输入备注内容",
    "ModelName":"模型名称",
    "Models Required":"所需模型",
    "Download Model": "下载模型",
    "Source Url": "模型源地址",
    "Notes": "备注",
    "Type": "类型",
    "Trained Words": "训练词",
    "BaseModel": "基础算法",
    "Details": "详情",
    "Description": "描述",
    "Download": "下载量",
    "Source": "来源",
    "Saving Preview...": "正在保存预览图...",
    "Saving Succeed":"保存成功",
    "Clean SuccessFully":"清理成功",
    "Clean Failed": "清理失败",
    "Saving Failed":"保存失败",
    "No COMBO link": "沒有找到COMBO连接",
    "Reboot ComfyUI":"重启ComfyUI",
    "Are you sure you'd like to reboot the server?": "是否要重启ComfyUI？",
    // GroupMap
    "Groups Map": "管理组",
    "Cleanup Of GPU Usage": "清理GPU占用",
    "Please stop all running tasks before cleaning GPU": "请在清理GPU之前停止所有运行中的任务",
    "Always": "启用中",
    "Bypass": "已忽略",
    "Never": "已停用",
    "Auto Sorting": "自动排序",
    "Toggle `Show/Hide` can set mode of group, LongPress can set group nodes to never": "点击`启用中/已忽略`可设置组模式, 长按可停用该组节点",
    // Quick
    "Enable ALT+1~9 to paste nodes from nodes template (ComfyUI-Easy-Use)": "启用ALT1~9从节点模板粘贴到工作流 (ComfyUI-Easy-Use)",
    "Enable process bar in queue button (ComfyUI-Easy-Use)": "启用提示词队列进度显示条 (ComfyUI-Easy-Use）",
    "Enable ContextMenu Auto Nest Subdirectories (ComfyUI-Easy-Use)": "启用上下文菜单自动嵌套子目录 (ComfyUI-Easy-Use)",
    "Enable tool bar fixed on the left-bottom (ComfyUI-Easy-Use)": "启用工具栏固定在左下角 (ComfyUI-Easy-Use)",
    "Too many thumbnails, have closed the display": "模型缩略图太多啦，为您关闭了显示",
    // selector
    "Empty All": "清空所有",
    "🔎 Type here to search styles ...": "🔎 在此处输入以搜索样式 ...",
    // account
    "Loading UserInfo...": "正在获取用户信息...",
    "Please set the APIKEY first": "请先设置APIKEY",
    "Setting APIKEY": "设置APIKEY",
    "Save Account Info": "保存账号信息",
    "Choose": "选择",
    "Delete": "删除",
    "Edit": "编辑",
    "At least one account is required": "删除失败: 至少需要一个账户",
    "APIKEY is not Empty": "APIKEY 不能为空",
    "Add Account": "添加账号",
    "Getting Your APIKEY": "获取您的APIKEY",
    // choosers
    "Choose Selected Images": "选择选中的图片",
    "Choose images to continue": "选择图片以继续",
    // seg
    "Background": "背景",
    "Hat": "帽子",
    "Hair": "头发",
    "Body": "身体",
    "Face": "脸部",
    "Clothes": "衣服",
    "Others": "其他",
    "Glove": "手套",
    "Sunglasses": "太阳镜",
    "Upper-clothes": "上衣",
    "Dress": "连衣裙",
    "Coat": "外套",
    "Socks": "袜子",
    "Pants": "裤子",
    "Jumpsuits": "连体衣",
    "Scarf": "围巾",
    "Skirt": "裙子",
    "Left-arm": "左臂",
    "Right-arm": "右臂",
    "Left-leg": "左腿",
    "Right-leg": "右腿",
    "Left-shoe": "左鞋",
    "Right-shoe": "右鞋",
}
export const $t = (key) => {
    const cn = zhCN[key]
    return locale === 'zh-CN' && cn ? cn : key
}