#!/usr/bin/env bash
set -euo pipefail

SERVER="${SERVER:-http://127.0.0.1:8000}"
MODEL="${MODEL:-qwen3-tts}"
LANGUAGE="${LANGUAGE:-Auto}"

curl -sS "${SERVER}/v1/audio/speech" \
  -H "Content-Type: application/json" \
  -o output.wav \
  -d @- <<EOF
{
  "model": "${MODEL}",
  "text": "哥哥，你回来啦，人家等了你好久好久了，要抱抱！",
  "task_type": "VoiceDesign",
  "language": "${LANGUAGE}",
  "instruct": "体现撒娇稚嫩的萝莉女声，音调偏高且起伏明显，营造出黏人、做作又刻意卖萌的听觉效果。",
  "generation_params": {
    "max_new_tokens": 4096,
    "do_sample": true,
    "top_k": 50,
    "top_p": 1.0,
    "temperature": 0.9
  },
  "response_format": "wav"
}
EOF

