# Qwen3-TTS
## 论文
[Qwen3-TTS Technical Report](https://arxiv.org/abs/2601.15621)

## 模型简介
由通义千问（Qwen）开发的一系列强大的语音生成能力，全面支持声音克隆、音色设计、超高质量拟人化语音合成以及基于自然语言的语音控制，为开发者和用户提供了目前最丰富的语音生成功能集。
<div align=center>
    <img src="./doc/qwen3-tts.png"/>
</div>
Qwen3-TTS 覆盖10种主要语言（中文、英文、日文、韩文、德文、法文、俄文、葡萄牙文、西班牙文和意大利文），并提供多种方言音色配置，以满足全球化的应用需求。此外，该模型具备强大的上下文理解能力，可根据指令和文本语义自适应调节语调、语速和情感表达，并对含噪声的输入文本展现出显著增强的鲁棒性。
主要特性如下：
强大的语音表征能力：基于自研的 Qwen3-TTS-Tokenizer-12Hz，实现对语音信号的高效声学压缩与高维语义建模，完整保留副语言信息（如语气、情绪）及声学环境特征，并通过轻量级非 DiT 架构实现高速、高保真的语音重建。
通用端到端架构：采用离散多码本语言模型（LM）架构，实现全信息端到端语音建模，彻底规避了传统“语言模型 + DiT”方案中存在的信息瓶颈与级联误差问题，显著提升模型的通用性、生成效率和性能上限。
极致低延迟流式生成：基于创新的双轨混合流式生成架构，单个模型同时支持流式与非流式生成模式。在用户仅输入单个字符后即可立即输出首个音频包，端到端合成延迟低至 97 毫秒，充分满足实时交互场景的严苛要求。
智能文本理解与语音控制：支持由自然语言指令驱动的语音生成，可灵活调控音色、情感、韵律等多维度声学属性。通过深度融合文本语义理解能力，模型能自适应调整语调、节奏与情感表达，实现“所想即所听”的拟人化语音输出。


## 环境依赖
- 列举基础环境需求，根据实际情况填写

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.3 |
| vllm | 0.9.2+das.opt2.dtk25042 |
| torchaudio | 2.5.1+das.opt1.dtk25042.20251127.g10a9ffcd |
| transformer_engine | 2.5.0+das.opt1.dtk25042 |

推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk26.04-0130-py3.10-20260202
- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name qwen3-tts \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装
其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

镜像内其他环境配置
```
1.重新安装torchaudio
    pip uninstall torchaudio
    pip install torchaudio-2.5.1+das.opt1.dtk25042.20251127.g10a9ffcd-cp310-cp310-manylinux_2_28_x86_64.whl

2.解压vllm.zip到/usr/local/lib/python3.10/dist-packages直接覆盖需要修改的文件
    unzip -o vllm.zip -d /usr/local/lib/python3.10/dist-packages
```


## 数据集
暂无

## 训练
暂无

## 推理

### transformers
#### 单机推理
```
VoiceDesign推理
python test_model_12hz_voice_design.py

CustomVoice
python test_model_12hz_custom_voice.py

Voice Clone
python test_model_12hz_base.py
```
### vllm
#### 单机推理（以VoiceDesign为例子，CustomVoice和Voice Clone需要切换模型）
启动服务
```bash
VLLM_USE_V1=0  python -m vllm.entrypoints.openai.api_server --model Qwen3-TTS/Qwen3-TTS-12Hz-1.7B-VoiceDesign --served-model-name qwen3-tts --host 0.0.0.0 --port 8000 --trust-remote-code --dtype bfloat16 --disable-async-output-proc
```
调用服务：
```
VoiceDesign
curl -sS http://127.0.0.1:8000/v1/audio/speech \
  -H "Content-Type: application/json" \
  -o output.wav \
  -d '{
    "model":"qwen3-tts",
    "text":"哥哥，你回来啦，人家等了你好久好久了，要抱抱！",
    "task_type":"VoiceDesign",
    "language":"Auto",
    "instruct":"体现撒娇稚嫩的萝莉女声，音调偏高且起伏明显，营造出黏人、做作又刻意卖萌的听觉效果。",
    "generation_params":{
      "max_new_tokens":4096,
      "do_sample":true,
      "top_k":50,
      "top_p":1.0,
      "temperature":0.9
    },
    "response_format":"wav"
  }'

CustomVoice
curl -sS http://127.0.0.1:8000/v1/audio/speech \
  -H "Content-Type: application/json" \
  -o output_customvoice.wav \
  -d '{
    "model":"qwen3-tts",
    "text":"哥哥，你回来啦，人家等了你好久好久了，要抱抱！",
    "task_type":"CustomVoice",
    "speaker":"YourSpeakerName",
    "language":"Auto",
    "instruct":"",
    "generation_params":{
      "max_new_tokens":4096,
      "do_sample":true,
      "top_k":50,
      "top_p":1.0,
      "temperature":0.9
    },
    "response_format":"wav"
  }'

Voice Clone
curl -sS http://127.0.0.1:8000/v1/audio/speech \
  -H "Content-Type: application/json" \
  -o output_clone_icl.wav \
  -d '{
    "model":"qwen3-tts",
    "text":"今天的风很温柔，我们一起出去走走吧。",
    "task_type":"Base",
    "language":"Auto",
    "ref_audio":"/path/to/ref.wav",
    "ref_text":"参考音频对应的文本内容",
    "x_vector_only_mode":false,
    "generation_params":{
      "max_new_tokens":4096,
      "do_sample":true,
      "top_k":50,
      "top_p":1.0,
      "temperature":0.9
    },
    "response_format":"wav"
  }'


```


## 效果展示

示例输出音频：output_audio\output.wav

### 精度
`DCU与GPU精度一致，推理框架：vllm`

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Qwen3-TTS-12Hz-1.7B-VoiceDesign | 1.7B | K100AI | 1 | [Modelscope] https://www.modelscope.cn/models/Qwen/Qwen3-TTS-12Hz-1.7B-VoiceDesign|
| Qwen3-TTS-12Hz-1.7B-CustomVoice | 1.7B | K100AI | 1 | [Modelscope] https://www.modelscope.cn/models/Qwen/Qwen3-TTS-12Hz-1.7B-CustomVoice|
| Qwen3-TTS-12Hz-1.7B-Base | 1.7B | K100AI | 1 | [Modelscope] https://www.modelscope.cn/models/Qwen/Qwen3-TTS-12Hz-1.7B-Base|

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/weishb/qwen3-tts_pytorch

## 参考资料
- https://github.com/QwenLM/Qwen3-TTS