// 常用工具

#ifndef __COMMON_UTILITY_H__
#define __COMMON_UTILITY_H__

#include <mutex>
#include <string>
#include <vector>
#include <CommonDefinition.h>
#include <migraphx/onnx.hpp>
#include <migraphx/gpu/target.hpp>
#include <migraphx/gpu/hip.hpp>
#include <migraphx/generate.hpp>
#include <migraphx/quantization.hpp>

using namespace std;

namespace migraphxSamples
{

 string GetCurrentTimeString();
 std::vector<string> SplitString(string str,std::string separator);

// 排序规则: 按照置信度或者按照面积排序
 bool CompareConfidence(const ResultOfDetection &L,const ResultOfDetection &R);
 bool CompareArea(const ResultOfDetection &L,const ResultOfDetection &R);

 void NMS(std::vector<ResultOfDetection> &detections, float IOUThreshold);

 migraphx::parameter_map CreateParameterMap(migraphx::program & p);

}

#endif //
