# 分类器
本示例使用了经典的mnist模型，模型下载地址：https://github.com/onnx/models/blob/main/vision/classification/mnist/model/mnist-12.onnx，模型结构如下图所示（可以通过netron (https://netron.app/) 查看），该模型的输入shape为[1,1,28,28] ，数据排布为NCHW，输出是10个类别的概率（未归一化）。

![image-20221212165226581](../Images/Classifier_01.png)

​																														

## 预处理

在将数据输入到模型之前，需要对图像做如下预处理操作：

1. 转换为单通道灰度图
2. resize到28x28
3. 将像素值归一化到[0.0, 1.0]
4. 转换数据排布为NCHW



本示例代码采用了OpenCV实现了预处理操作：

```
def Preprocessing(pathOfImage):
    gray = cv2.imread(pathOfImage,cv2.IMREAD_GRAYSCALE)
    gray = cv2.resize(gray, (28,28)).astype(np.float32)/255
    input = np.reshape(gray, (1,1,28,28))
    return input
```



## 推理

完成预处理后，就可以执行推理了：

```
if __name__ == '__main__':
    ...
    
    # 预处理
    pathOfImage ="../../Resource/Images/9.jpg"
    image = Preprocessing(pathOfImage)

    # 推理
    results = model.run({inputName: migraphx.argument(image)}) # 推理结果，list类型

    # 获取输出节点属性
    result=results[0] # 获取第一个输出节点的数据,migraphx.argument类型
    outputShape=result.get_shape() # 输出节点的shape,migraphx.shape类型
    outputSize=outputShape.lens() # 每一维大小，维度顺序为(N,C,H,W),list类型
    numberOfOutput=outputShape.elements() # 输出节点元素的个数

    # 计算softmax
    result=results[0].tolist() # 将migraphx.argument转换为list
    result=np.array(result)
    scores=Softmax(result)

    # 打印10个类别的概率
    print(scores)
```

1. Preprocessing()函数返回输入数据（numpy类型），然后通过{inputName: migraphx.argument(image)}构造一个字典输入模型执行推理，如果模型有多个输入，则在字典中需要添加多个输入数据。
2. model.run()返回模型的推理结果，返回结果是一个list类型，results[0]表示第一个输出节点的输出，是一个migraphx.argument类型，由于示例模型只有一个输出节点，所以results[0]对应Plus214_Output_0节点，如果想将migraphx.argument类型转换为list类型，可以通过tolist()方法实现。
3. 由于该模型输出的是一个未归一化的概率，所以如果需要得到每一类的实际的概率值，还需要计算softmax。



## 运行示例



1. 参考《MIGraphX教程》中的安装方法安装MIGraphX并设置好PYTHONPATH
2. 安装依赖：

```
# 进入migraphx samples工程根目录
cd <path_to_migraphx_samples> 

# 进入示例程序目录
cd Python/Classifier

# 安装依赖
pip install -r requirements.txt
```

3. 在Python/Classifier目录下执行如下命令运行该示例程序：

```
# 运行示例
python Classifier.py
```

输出结果为：

```
...
[1.59622257e-07 3.41601745e-05 1.17416399e-05 1.69055674e-04
 4.37055434e-05 1.19463621e-06 5.51138837e-11 7.25694010e-04
 2.78295036e-04 9.98735994e-01]
```

输出结果中，每个值分别对应每个label的实际概率，比如1.59622257e-07表示label为0的概率，由于示例图像为数字9，所以结果中label为9的概率最高。

![image-20221212173655309](../Images/Classifier_02.png)
