// YOLOV3检测器

#ifndef __DETECTOR_YOLOV3_H__
#define __DETECTOR_YOLOV3_H__

#include <string>
#include <migraphx/program.hpp>
#include <opencv2/opencv.hpp>
#include <CommonDefinition.h>
#include "Decoder.h"

using namespace std;
using namespace cv;
using namespace migraphx;

namespace migraphxSamples
{

// YOLOV3参数
typedef struct _YOLOV3Parameter
{
    int numberOfClasses;// 类别数
    float confidenceThreshold;// 置信度阈值
    float nmsThreshold;// NMS阈值
    float objectThreshold;// 目标置信度值

}YOLOV3Parameter;

class DetectorYOLOV3
{
public:
    DetectorYOLOV3();
    
    ~DetectorYOLOV3();

    ErrorCode Initialize(InitializationParameterOfDetector initializationParameterOfDetector);

    ErrorCode Detect(const cv::Mat &srcImage, std::vector<ResultOfDetection> &resultsOfDetection, double* dprep_time, double* deval_time, double* dpostp_time);

    ErrorCode Detect(DCU_Frame &srcImage, std::vector<ResultOfDetection> &resultsOfDetection);

    float* preprocess_Image = NULL;

private:
    ErrorCode DoCommonInitialization(InitializationParameterOfDetector initializationParameterOfDetector);

private:
    cv::FileStorage configurationFile;
    InitializationParameterOfDetector initializationParameter;
    FILE *logFile;

    // net
    migraphx::program net;
    cv::Size inputSize;
    string inputName;
    migraphx::shape inputShape;
    
    bool useFP16;
    vector<string> classNames;

    YOLOV3Parameter yolov3Parameter;
    migraphx::parameter_map ParameterMap;
};

}


#endif
