import cupy as cp
import numpy as np
from skimage import data
from skimage import filters
from skimage import img_as_float

# 加载示例图像
image = img_as_float(data.coins())

# 将图像从NumPy数组转换为CuPy数组，以利用GPU
image_gpu = cp.array(image)

# 定义一个使用GPU的函数（例如，应用高斯滤波器）
def gaussian_filter_gpu(image, sigma=1):
    from cupyx.scipy.ndimage import gaussian_filter
    return gaussian_filter(image, sigma)

# 应用高斯滤波器
filtered_image_gpu = gaussian_filter_gpu(image_gpu, sigma=1)

# 将结果转换回NumPy数组
filtered_image = cp.asnumpy(filtered_image_gpu)

# 测试输出
print("Original Image Shape:", image.shape)
print("Filtered Image Shape:", filtered_image.shape)