# 下载DCU支持的cupy 


```
wget https://cancon.hpccube.com:65024/directlink/1/DTK-24.04.1_apps-20240611/NFS3.2_CentOS7.6/cupy_v12.0.0b3_py38_nfs3.2_DTK24.04_29Mar2024.tar.gz
tar -zxvf cupy_v12.0.0b3_py38_nfs3.2_DTK24.04_29Mar2024.tar.gz
```

# 建立conda 环境



```
conda create -n  scikit  python=3.8
pip install cupy_v12.0.0b3_py38_nfs3.2_DTK24.04_29Mar2024/dist-py38/cupy-12.0.0b3-cp38-cp38-linux_x86_64.whl
pip install scikit-image -i https://pypi.tuna.tsinghua.edu.cn/simple 

```
安装后环境如下：

```
cupy         12.0.0b3
fastrlock    0.8.2
imageio      2.35.0
lazy_loader  0.4
networkx     3.1
numpy        1.24.4
packaging    24.1
pillow       10.4.0
pip          24.2
PyWavelets   1.4.1
scikit-image 0.21.0
scipy        1.10.1
setuptools   72.1.0
tifffile     2023.7.10
wheel        0.43.0

```



# 执行测试

```
import cupy as cp
import numpy as np
from skimage import data
from skimage import filters
from skimage import img_as_float

# 加载示例图像
image = img_as_float(data.coins())

# 将图像从NumPy数组转换为CuPy数组，以利用GPU
image_gpu = cp.array(image)

# 定义一个使用GPU的函数（例如，应用高斯滤波器）
def gaussian_filter_gpu(image, sigma=1):
    from cupyx.scipy.ndimage import gaussian_filter
    return gaussian_filter(image, sigma)

# 应用高斯滤波器
filtered_image_gpu = gaussian_filter_gpu(image_gpu, sigma=1)

# 将结果转换回NumPy数组
filtered_image = cp.asnumpy(filtered_image_gpu)

# 测试输出
print("Original Image Shape:", image.shape)
print("Filtered Image Shape:", filtered_image.shape)
```