
# 拉取镜像

```
git clone -b  paddle/release/2.5 http://developer.hpccube.com/codes/wangsen/paddle_dbnet.git
cd paddle_dbnet
```



# 安装环境

```
conda create -n dbnet python=3.10 
source activate dbnet 

pip install paddlepaddle  -i https://pypi.tuna.tsinghua.edu.cn/simple
pip install -r requirments.txt
pip install numpy==1.23.5
```


# 下载数据集


```
mkdir /datasets


wget https://bj.bcebos.com/ai-studio-online/a3e8c3692678433082ca73af675558098a8b64c03bef4659aa2540607d54a341?authorization=bce-auth-v1%2F5cfe9a5e1454405eb2a975c43eace6ec%2F2022-09-04T15%3A26%3A02Z%2F-1%2F%2F912a4d6fd021f5db138a325ebcb6ac726f628565deeb9b3204807d4fca761e12&responseContentDisposition=attachment%3B%20filename%3Dicdar2015.zip 

unzip a3e8c3692678433082ca73af675558098a8b64c03bef4659aa2540607d54a341?authorization=bce-auth-v1%2F5cfe9a5e1454405eb2a975c43eace6ec%2F2022-09-04T15:26:02Z%2F-1%2F%2F912a4d6fd021f5db138a325ebcb6ac726f628565deeb9b3204807d4fca761e12
```

数据集修改方法，修改label_file_list的路径
```
vim configs/det/det_mv3_db.yml
```


# 下载预训练模型
```
wget -P ./pretrain_models/ https://paddleocr.bj.bcebos.com/pretrained/MobileNetV3_large_x0_5_pretrained.pdparams
```



# 运行环境




```
source /opt/dtk-24.04.1/env.sh
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export HSA_FORCE_FINE_GRAIN_PCIE=1
export FLAGS_cudnn_batchnorm_spatial_persistent=1

export NCCL_MAX_NCHANNELS=20
export NCCL_MIN_NCHANNELS=20
export NCCL_P2P_LEVEL=SYS
export GPU_MAX_HW_QUEUES=16

# 获取训练时间戳
start=$(date +%s.%N)


# recommended paddle.__version__ == 2.0.0

numactl --cpunodebind=0 --membind=0 python3 -m paddle.distributed.launch --log_dir=./debug/ --gpus '0,1,2,3,4,5,6,7' tools/train.py \
                -c configs/det/det_mv3_db.yml -o Global.epoch_num=1500  Global.eval_batch_step=[0,60] Train.loader.batch_size_per_card=48 \
                Train.loader.num_workers=8 Eval.loader.num_workers=0

wait
# 获取训练结束时间戳，并计算差值得到总耗时，单位为秒
end=$(date +%s.%N)
runtime=$(echo "$end - $start" | bc)
echo "Total Time: $runtime" >> ttal_time.log
```






