# paddleocr package使用说明

## 快速上手

### 安装whl包

pip安装
```bash
pip install paddleocr
```

本地构建并安装
```bash
python setup.py bdist_wheel
pip install dist/paddleocr-0.0.3-py3-none-any.whl
```
### 1. 代码使用

* 检测+识别全流程
```python
from paddleocr import PaddleOCR, draw_ocr
ocr = PaddleOCR(model_storage_directory='./model') # need to run only once to load model into memory
img_path = 'PaddleOCR/doc/imgs/11.jpg'
result = ocr.ocr(img_path)
for line in result:
    print(line)

# 显示结果
from PIL import Image
image = Image.open(img_path).convert('RGB')
boxes = [line[0] for line in result]
txts = [line[1][0] for line in result]
scores = [line[1][1] for line in result]
im_show = draw_ocr(image, boxes, txts, scores, font_path='/path/to/PaddleOCR/doc/simfang.ttf')
im_show = Image.fromarray(im_show)
im_show.save('result.jpg')
```
结果是一个list，每个item包含了文本框，文字和识别置信度
```bash
[[[24.0, 36.0], [304.0, 34.0], [304.0, 72.0], [24.0, 74.0]], ['纯臻营养护发素', 0.964739]]
[[[24.0, 80.0], [172.0, 80.0], [172.0, 104.0], [24.0, 104.0]], ['产品信息/参数', 0.98069626]]
[[[24.0, 109.0], [333.0, 109.0], [333.0, 136.0], [24.0, 136.0]], ['（45元/每公斤，100公斤起订）', 0.9676722]]
[[[22.0, 140.0], [284.0, 140.0], [284.0, 167.0], [22.0, 167.0]], ['每瓶22元，1000瓶起订）', 0.97444016]]
[[[22.0, 174.0], [85.0, 174.0], [85.0, 198.0], [22.0, 198.0]], ['【品牌】', 0.8187138]]
[[[89.0, 176.0], [301.0, 176.0], [301.0, 196.0], [89.0, 196.0]], ['：代加工方式/OEMODM', 0.9421848]]
[[[23.0, 205.0], [85.0, 205.0], [85.0, 229.0], [23.0, 229.0]], ['【品名】', 0.76008326]]
[[[88.0, 204.0], [235.0, 206.0], [235.0, 229.0], [88.0, 227.0]], ['：纯臻营养护发素', 0.9633639]]
[[[23.0, 236.0], [121.0, 236.0], [121.0, 261.0], [23.0, 261.0]], ['【产品编号】', 0.84101385]]
[[[110.0, 239.0], [239.0, 239.0], [239.0, 256.0], [110.0, 256.0]], ['1：YM-X-3011', 0.8621878]]
[[[414.0, 233.0], [430.0, 233.0], [430.0, 304.0], [414.0, 304.0]], ['ODM OEM', 0.9084018]]
[[[23.0, 268.0], [183.0, 268.0], [183.0, 292.0], [23.0, 292.0]], ['【净含量】：220ml', 0.9278281]]
[[[24.0, 301.0], [118.0, 301.0], [118.0, 321.0], [24.0, 321.0]], ['【适用人群】', 0.90901047]]
[[[127.0, 300.0], [254.0, 300.0], [254.0, 323.0], [127.0, 323.0]], ['：适合所有肤质', 0.95465785]]
[[[24.0, 332.0], [117.0, 332.0], [117.0, 353.0], [24.0, 353.0]], ['【主要成分】', 0.88936955]]
[[[139.0, 332.0], [236.0, 332.0], [236.0, 352.0], [139.0, 352.0]], ['鲸蜡硬脂醇', 0.9447544]]
[[[248.0, 332.0], [345.0, 332.0], [345.0, 352.0], [248.0, 352.0]], ['燕麦B-葡聚', 0.89748293]]
[[[54.0, 363.0], [232.0, 363.0], [232.0, 383.0], [54.0, 383.0]], [' 椰油酰胺丙基甜菜碱', 0.902023]]
[[[25.0, 364.0], [64.0, 364.0], [64.0, 383.0], [25.0, 383.0]], ['糖、', 0.985203]]
[[[244.0, 363.0], [281.0, 363.0], [281.0, 382.0], [244.0, 382.0]], ['泛服', 0.44537082]]
[[[367.0, 367.0], [475.0, 367.0], [475.0, 388.0], [367.0, 388.0]], ['（成品包材）', 0.9834532]]
[[[24.0, 395.0], [120.0, 395.0], [120.0, 416.0], [24.0, 416.0]], ['【主要功能】', 0.88684446]]
[[[128.0, 397.0], [273.0, 397.0], [273.0, 414.0], [128.0, 414.0]], ['：可紧致头发磷层', 0.9342501]]
[[[265.0, 395.0], [361.0, 395.0], [361.0, 415.0], [265.0, 415.0]], ['琴，从而达到', 0.8253762]]
[[[25.0, 425.0], [372.0, 425.0], [372.0, 448.0], [25.0, 448.0]], ['即时持久改善头发光泽的效果，给干燥的头', 0.97785276]]
[[[26.0, 457.0], [137.0, 457.0], [137.0, 477.0], [26.0, 477.0]], ['发足够的滋养', 0.9577897]]
```
结果可视化

<div align="center">
    <img src="../imgs_results/whl/11_det_rec.jpg" width="800">
</div>

* 单独执行检测
```python
from paddleocr import PaddleOCR, draw_ocr
ocr = PaddleOCR(model_storage_directory='./model') # need to run only once to load model into memory
img_path = 'PaddleOCR/doc/imgs/11.jpg'
result = ocr.ocr(img_path,rec=False)
for line in result:
    print(line)

# 显示结果
from PIL import Image

image = Image.open(img_path).convert('RGB')
im_show = draw_ocr(image, result, txts=None, scores=None, font_path='/path/to/PaddleOCR/doc/simfang.ttf')
im_show = Image.fromarray(im_show)
im_show.save('result.jpg')
```
结果是一个list，每个item只包含文本框
```bash
[[26.0, 457.0], [137.0, 457.0], [137.0, 477.0], [26.0, 477.0]]
[[25.0, 425.0], [372.0, 425.0], [372.0, 448.0], [25.0, 448.0]]
[[128.0, 397.0], [273.0, 397.0], [273.0, 414.0], [128.0, 414.0]]
[[265.0, 395.0], [361.0, 395.0], [361.0, 415.0], [265.0, 415.0]]
[[24.0, 395.0], [120.0, 395.0], [120.0, 416.0], [24.0, 416.0]]
[[367.0, 367.0], [475.0, 367.0], [475.0, 388.0], [367.0, 388.0]]
[[54.0, 363.0], [232.0, 363.0], [232.0, 383.0], [54.0, 383.0]]
[[25.0, 364.0], [64.0, 364.0], [64.0, 383.0], [25.0, 383.0]]
[[244.0, 363.0], [281.0, 363.0], [281.0, 382.0], [244.0, 382.0]]
[[248.0, 332.0], [345.0, 332.0], [345.0, 352.0], [248.0, 352.0]]
[[139.0, 332.0], [236.0, 332.0], [236.0, 352.0], [139.0, 352.0]]
[[24.0, 332.0], [117.0, 332.0], [117.0, 353.0], [24.0, 353.0]]
[[127.0, 300.0], [254.0, 300.0], [254.0, 323.0], [127.0, 323.0]]
[[24.0, 301.0], [118.0, 301.0], [118.0, 321.0], [24.0, 321.0]]
[[23.0, 268.0], [183.0, 268.0], [183.0, 292.0], [23.0, 292.0]]
[[110.0, 239.0], [239.0, 239.0], [239.0, 256.0], [110.0, 256.0]]
[[23.0, 236.0], [121.0, 236.0], [121.0, 261.0], [23.0, 261.0]]
[[414.0, 233.0], [430.0, 233.0], [430.0, 304.0], [414.0, 304.0]]
[[88.0, 204.0], [235.0, 206.0], [235.0, 229.0], [88.0, 227.0]]
[[23.0, 205.0], [85.0, 205.0], [85.0, 229.0], [23.0, 229.0]]
[[89.0, 176.0], [301.0, 176.0], [301.0, 196.0], [89.0, 196.0]]
[[22.0, 174.0], [85.0, 174.0], [85.0, 198.0], [22.0, 198.0]]
[[22.0, 140.0], [284.0, 140.0], [284.0, 167.0], [22.0, 167.0]]
[[24.0, 109.0], [333.0, 109.0], [333.0, 136.0], [24.0, 136.0]]
[[24.0, 80.0], [172.0, 80.0], [172.0, 104.0], [24.0, 104.0]]
[[24.0, 36.0], [304.0, 34.0], [304.0, 72.0], [24.0, 74.0]]
```
结果可视化


<div align="center">
    <img src="../imgs_results/whl/11_det.jpg" width="800">
</div>

* 单独执行识别
```python
from paddleocr import PaddleOCR
ocr = PaddleOCR(model_storage_directory='./model') # need to run only once to load model into memory
img_path = 'PaddleOCR/doc/imgs_words/ch/word_1.jpg'
result = ocr.ocr(img_path,det=False)
for line in result:
    print(line)
```
结果是一个list，每个item只包含识别结果和识别置信度
```bash
['韩国小馆', 0.9907421]
```

### 通过命令行使用

查看帮助信息
```bash
paddleocr -h
```

* 检测+识别全流程
```bash
paddleocr --image_dir PaddleOCR/doc/imgs/11.jpg
```
结果是一个list，每个item包含了文本框，文字和识别置信度
```bash
[[[24.0, 36.0], [304.0, 34.0], [304.0, 72.0], [24.0, 74.0]], ['纯臻营养护发素', 0.964739]]
[[[24.0, 80.0], [172.0, 80.0], [172.0, 104.0], [24.0, 104.0]], ['产品信息/参数', 0.98069626]]
[[[24.0, 109.0], [333.0, 109.0], [333.0, 136.0], [24.0, 136.0]], ['（45元/每公斤，100公斤起订）', 0.9676722]]
[[[22.0, 140.0], [284.0, 140.0], [284.0, 167.0], [22.0, 167.0]], ['每瓶22元，1000瓶起订）', 0.97444016]]
[[[22.0, 174.0], [85.0, 174.0], [85.0, 198.0], [22.0, 198.0]], ['【品牌】', 0.8187138]]
[[[89.0, 176.0], [301.0, 176.0], [301.0, 196.0], [89.0, 196.0]], ['：代加工方式/OEMODM', 0.9421848]]
[[[23.0, 205.0], [85.0, 205.0], [85.0, 229.0], [23.0, 229.0]], ['【品名】', 0.76008326]]
[[[88.0, 204.0], [235.0, 206.0], [235.0, 229.0], [88.0, 227.0]], ['：纯臻营养护发素', 0.9633639]]
[[[23.0, 236.0], [121.0, 236.0], [121.0, 261.0], [23.0, 261.0]], ['【产品编号】', 0.84101385]]
[[[110.0, 239.0], [239.0, 239.0], [239.0, 256.0], [110.0, 256.0]], ['1：YM-X-3011', 0.8621878]]
[[[414.0, 233.0], [430.0, 233.0], [430.0, 304.0], [414.0, 304.0]], ['ODM OEM', 0.9084018]]
[[[23.0, 268.0], [183.0, 268.0], [183.0, 292.0], [23.0, 292.0]], ['【净含量】：220ml', 0.9278281]]
[[[24.0, 301.0], [118.0, 301.0], [118.0, 321.0], [24.0, 321.0]], ['【适用人群】', 0.90901047]]
[[[127.0, 300.0], [254.0, 300.0], [254.0, 323.0], [127.0, 323.0]], ['：适合所有肤质', 0.95465785]]
[[[24.0, 332.0], [117.0, 332.0], [117.0, 353.0], [24.0, 353.0]], ['【主要成分】', 0.88936955]]
[[[139.0, 332.0], [236.0, 332.0], [236.0, 352.0], [139.0, 352.0]], ['鲸蜡硬脂醇', 0.9447544]]
[[[248.0, 332.0], [345.0, 332.0], [345.0, 352.0], [248.0, 352.0]], ['燕麦B-葡聚', 0.89748293]]
[[[54.0, 363.0], [232.0, 363.0], [232.0, 383.0], [54.0, 383.0]], [' 椰油酰胺丙基甜菜碱', 0.902023]]
[[[25.0, 364.0], [64.0, 364.0], [64.0, 383.0], [25.0, 383.0]], ['糖、', 0.985203]]
[[[244.0, 363.0], [281.0, 363.0], [281.0, 382.0], [244.0, 382.0]], ['泛服', 0.44537082]]
[[[367.0, 367.0], [475.0, 367.0], [475.0, 388.0], [367.0, 388.0]], ['（成品包材）', 0.9834532]]
[[[24.0, 395.0], [120.0, 395.0], [120.0, 416.0], [24.0, 416.0]], ['【主要功能】', 0.88684446]]
[[[128.0, 397.0], [273.0, 397.0], [273.0, 414.0], [128.0, 414.0]], ['：可紧致头发磷层', 0.9342501]]
[[[265.0, 395.0], [361.0, 395.0], [361.0, 415.0], [265.0, 415.0]], ['琴，从而达到', 0.8253762]]
[[[25.0, 425.0], [372.0, 425.0], [372.0, 448.0], [25.0, 448.0]], ['即时持久改善头发光泽的效果，给干燥的头', 0.97785276]]
[[[26.0, 457.0], [137.0, 457.0], [137.0, 477.0], [26.0, 477.0]], ['发足够的滋养', 0.9577897]]
```

* 单独执行检测
```bash
paddleocr --image_dir PaddleOCR/doc/imgs/11.jpg --rec false
```
结果是一个list，每个item只包含文本框
```bash
[[26.0, 457.0], [137.0, 457.0], [137.0, 477.0], [26.0, 477.0]]
[[25.0, 425.0], [372.0, 425.0], [372.0, 448.0], [25.0, 448.0]]
[[128.0, 397.0], [273.0, 397.0], [273.0, 414.0], [128.0, 414.0]]
[[265.0, 395.0], [361.0, 395.0], [361.0, 415.0], [265.0, 415.0]]
[[24.0, 395.0], [120.0, 395.0], [120.0, 416.0], [24.0, 416.0]]
[[367.0, 367.0], [475.0, 367.0], [475.0, 388.0], [367.0, 388.0]]
[[54.0, 363.0], [232.0, 363.0], [232.0, 383.0], [54.0, 383.0]]
[[25.0, 364.0], [64.0, 364.0], [64.0, 383.0], [25.0, 383.0]]
[[244.0, 363.0], [281.0, 363.0], [281.0, 382.0], [244.0, 382.0]]
[[248.0, 332.0], [345.0, 332.0], [345.0, 352.0], [248.0, 352.0]]
[[139.0, 332.0], [236.0, 332.0], [236.0, 352.0], [139.0, 352.0]]
[[24.0, 332.0], [117.0, 332.0], [117.0, 353.0], [24.0, 353.0]]
[[127.0, 300.0], [254.0, 300.0], [254.0, 323.0], [127.0, 323.0]]
[[24.0, 301.0], [118.0, 301.0], [118.0, 321.0], [24.0, 321.0]]
[[23.0, 268.0], [183.0, 268.0], [183.0, 292.0], [23.0, 292.0]]
[[110.0, 239.0], [239.0, 239.0], [239.0, 256.0], [110.0, 256.0]]
[[23.0, 236.0], [121.0, 236.0], [121.0, 261.0], [23.0, 261.0]]
[[414.0, 233.0], [430.0, 233.0], [430.0, 304.0], [414.0, 304.0]]
[[88.0, 204.0], [235.0, 206.0], [235.0, 229.0], [88.0, 227.0]]
[[23.0, 205.0], [85.0, 205.0], [85.0, 229.0], [23.0, 229.0]]
[[89.0, 176.0], [301.0, 176.0], [301.0, 196.0], [89.0, 196.0]]
[[22.0, 174.0], [85.0, 174.0], [85.0, 198.0], [22.0, 198.0]]
[[22.0, 140.0], [284.0, 140.0], [284.0, 167.0], [22.0, 167.0]]
[[24.0, 109.0], [333.0, 109.0], [333.0, 136.0], [24.0, 136.0]]
[[24.0, 80.0], [172.0, 80.0], [172.0, 104.0], [24.0, 104.0]]
[[24.0, 36.0], [304.0, 34.0], [304.0, 72.0], [24.0, 74.0]]
```

* 单独执行识别
```bash
paddleocr --image_dir PaddleOCR/doc/imgs_words/ch/word_1.jpg --det false
```

结果是一个list，每个item只包含识别结果和识别置信度
```bash
['韩国小馆', 0.9907421]
```

## 参数说明

| 字段                    | 说明                                                                                                                                                                                                                 | 默认值                  |
|-------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------|
| use_gpu                 | 是否使用GPU                                                                                                                                                                                                          | TRUE                    |
| gpu_mem                 | 初始化占用的GPU内存大小                                                                                                                                                                                              | 8000M                   |
| image_dir               | 通过命令行调用时执行预测的图片或文件夹路径                                                                                                                                                                           |                         |
| det_algorithm           | 使用的检测算法类型                                                                                                                                                                                                   | DB                      |
| det_model_name          | 有两种使用方式： 1. 检测算法名称，此名称必须在支持列表内(目前只内置了ch_det_mv3_db)，传入错误参数时会显示支持的列表 2. 自己转换好的inference模型路径，此时模型路径下必须包含model和params文件。选择此方式时，需要手动指定det_algorithm的值 | ch_det_mv3_db           |
| det_max_side_len        | 检测算法前向时图片长边的最大尺寸，当长边超出这个值时会将长边resize到这个大小，短边等比例缩放                                                                                                                         | 960                     |
| det_db_thresh           | DB模型输出预测图的二值化阈值                                                                                                                                                                                         | 0.3                     |
| det_db_box_thresh       | DB模型输出框的阈值，低于此值的预测框会被丢弃                                                                                                                                                                           | 0.5                     |
| det_db_unclip_ratio     | DB模型输出框扩大的比例                                                                                                                                                                                               | 2                       |
| det_east_score_thresh   | EAST模型输出预测图的二值化阈值                                                                                                                                                                                       | 0.8                     |
| det_east_cover_thresh   | EAST模型输出框的阈值，低于此值的预测框会被丢弃                                                                                                                                                                         | 0.1                     |
| det_east_nms_thresh     | EAST模型输出框NMS的阈值                                                                                                                                                                                              | 0.2                     |
| rec_algorithm           | 使用的识别算法类型                                                                                                                                                                                                   | CRNN                    |
| rec_model_name          | 有两种使用方式： 1. 识别算法名称，此名称必须在支持列表内(目前支持CRNN,Rosetta,STAR,RARE等算法,但是内置的只有ch_rec_mv3_crnn_enhance)，传入错误参数时会显示支持的列表 2. 自己转换好的inference模型路径，此时模型路径下必须包含model和params文件。选择此方式时，需要手动指定rec_algorithm的值 | ch_rec_mv3_crnn_enhance |
| rec_image_shape         | 识别算法的输入图片尺寸                                                                                                                                                                                             | "3,32,320"              |
| rec_char_type           | 识别算法的字符类型，中文(ch)或英文(en)                                                                                                                                                                               | ch                      |
| rec_batch_num           | 进行识别时，同时前向的图片数                                                                                                                                                                                         | 30                      |
| rec_char_dict_path      | 识别模型字典路径，当rec_model_name使用方式2传参时需要修改为自己的路径                                                                                                                                                |                         |
| use_space_char          | 是否识别空格                                                                                                                                                                                                         | TRUE                    |
| enable_mkldnn           | 是否启用mkldnn                                                                                                                                                                                                       | FALSE                   |
| model_storage_directory | 下载模型保存路径                                                                                                                                                                                                     | ～/.paddleocr                |
| det                     | 前向时使用启动检测                                                                                                                                                                                                   | TRUE                    |
| rec                     | 前向时是否启动识别                                                                                                                                                                                                   | TRUE                    |
