这是一个为您量身定制的 `README.md`。它整合了您提供的 DCU 特殊容器环境、MLPerf v5.1 流程以及针对 `val_map.txt` 缺失问题的解决方案。

---

# MLPerf Inference v5.1 - ResNet50 (TensorFlow on DCU) 手册

本指南旨在指导用户在 DCU 硬件环境下，使用 **MLPerf Inference v5.1** 标准集运行 ResNet50 推理性能测试。

## 1. 环境准备

### 1.1 容器部署

首先，拉取并运行专为 DCU 优化的 TensorFlow 镜像。该镜像已包含 DTK 等必要驱动支持。

```bash
# 拉取镜像
docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10

# 创建并进入容器
docker run -it \
  --network=host \
  --ipc=host \
  --shm-size=16G \
  --device=/dev/kfd \
  --device=/dev/mkfd \
  --device=/dev/dri \
  -v /opt/hyhal:/opt/hyhal \
  --group-add video \
  --cap-add=SYS_PTRACE \
  --security-opt seccomp=unconfined \
  image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10 \
  /bin/bash

```

### 1.2 源码获取

克隆 MLPerf 推理标准库 v5.1 分支：

```bash
git clone -b v5.1 https://github.com/mlcommons/inference.git

```

## 2. 软件依赖安装

进入目录并安装 LoadGen 及视觉任务相关的 Python 包：

```bash
cd inference/loadgen && pip install .
cd ../vision/classification_and_detection && python setup.py install

# 安装 MLCommons 自动化工具
pip install cmind mlc-scripts

```

## 3. 准备数据集与模型

### 3.1 数据集下载

使用 `mlcr` 工具下载 ImageNet-2012 验证集：

```bash
mlcr get,dataset,imagenet,validation --outdirname=<YOUR_DATA_PATH> -j

```

### 3.2 修复标签映射文件 (重要)

下载后的数据集通常缺少 `val_map.txt`，请按以下步骤手动补全，否则推理脚本无法读取标签：

1. **获取文件**：访问 [GitHub 资源](https://github.com/Abhishekghosh1998/MLPerf_ImageNet_val_vap_map_txt/blob/main/val_map.txt)。
2. **放置路径**：将该文件存放在解压后的 `imagenet-2012-val` 文件夹根目录下。
```bash
# 示例
ls <YOUR_DATA_PATH>/imagenet-2012-val/val_map.txt

```



### 3.3 模型下载

自动获取 MLPerf 官方指定的 ResNet50 TensorFlow 预训练模型：

```bash
mlcr run-mlperf,inference,_full,_r5.1 --model=resnet50 --implementation=reference --framework=tensorflow --download

```

## 4. 执行推理测试

你可以通过以下两种方式之一来运行，确保脚本能找到文件：

**方式 A：先 Export（推荐，不容易出错）**

```bash
export MODEL_DIR=/workspace/inference/vision/classification_and_detection/models/
export DATA_DIR=/workspace/inference/vision/classification_and_detection/data
./run_local.sh tf resnet50 gpu

```

**方式 B：在命令行前直接定义**

```bash
MODEL_DIR==/path/to/model.pb DATA_DIR=/path/to/data ./run_local.sh tf resnet50 gpu

```

---

### 四个场景要求的命令汇总

不同场景的正确命令如下：

| 测试目标 | 命令（前提是已 export 变量） |
| --- | --- |
| **最大吞吐量** | `./run_local.sh tf resnet50 gpu --scenario Offline` |
| **最低延迟** | `./run_local.sh tf resnet50 gpu --scenario SingleStream` |
| **最大并发流** | `./run_local.sh tf resnet50 gpu --scenario MultiStream` |
| **P99 20ms 吞吐量** | `./run_local.sh tf resnet50 gpu --scenario Server --user_conf user.conf` |

---


## 5. 如何验证四个场景的“合格性”？

检查 `output/` 目录下生成的 `mlperf_log_summary.txt`：

* **Offline**: 寻找 `Samples per second`。
* **SingleStream**: 寻找 `Mean latency`。
* **MultiStream**: 寻找 `Samples per query`。
* **Server**: 确保 `Result is : VALID`，这代表你的 P99 延迟满足了 20ms（前提是你已按前文建议在 `user.conf` 中设置了 `target_latency = 20`）。

