# MLPerf™ Inference v5.1: BERT-99 on DCU (TensorFlow)

本指南详细说明了如何在海光 **DCU (K100_AI)** 环境下，使用 **TensorFlow** 框架运行 MLPerf™ Inference v5.1 中的 **BERT-Large** 推理任务。

## 1. 环境准备

### 1.1 启动 Docker 容器

使用包含海光 DTK 25.04.2 的 TensorFlow 官方镜像：

```bash
docker run -it \
  --network=host \
  --ipc=host \
  --shm-size=16G \
  --device=/dev/kfd \
  --device=/dev/mkfd \
  --device=/dev/dri \
  -v /opt/hyhal:/opt/hyhal \
  --group-add video \
  --cap-add=SYS_PTRACE \
  --security-opt seccomp=unconfined \
  image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.18.0-ubuntu22.04-dtk25.04.2-py3.10
```

---


### 1.2 安装核心组件

进入容器后，安装 MLPerf LoadGen 和 MLCommons 自动化工具 `mlcr` (CM Framework)：

```bash
# 安装 LoadGen
cd inference/loadgen && pip install .

# 安装 MLCommons 自动化框架
pip install cmind mlc-scripts

```

---

## 2. 数据集准备 (SQuAD v1.1)

BERT 任务使用 **SQuAD v1.1** (Stanford Question Answering Dataset) 验证集。

```bash
# 使用 mlcr 注册数据集 (v5.1 版本适配)
mlcr get,dataset,squad,language-processing,_v1.1 --outdirname=/root -j
# 下载 SQuAD dev-v1.1.json(网络不佳时候可单独进行下载）
wget https://raw.githubusercontent.com/rajpurkar/SQuAD-explorer/master/dataset/dev-v1.1.json -O /root/dev-v1.1.json

```

---

## 3. 模型获取 (BERT-Large)

BERT-99 代表该模型精度需达到参考模型 (FP32) 的 **99%** (F1 分数需  89.96%)。

```bash
mlcr run-mlperf,inference,_full,_r5.1 --model=bert-99 --implementation=reference --framework=tensorflow --download

# 创建目录并使用 aria2c 多线程下载 (网络不佳时)
apt-get install -y aria2
mkdir -p /root/MLC/repos/local/cache/download-file_bert-large-ml-m_229ad317/
aria2c -x 16 -s 16 -k 1M https://zenodo.org/record/3939747/files/model.pb \
  -d /root/MLC/repos/local/cache/download-file_bert-large-ml-m_229ad317/ -o model.pb

```

---

## 4. 目录结构与软链接配置

为了确保 `run.py` 能够找到对应的模型和数据，请执行以下目录初始化操作：

```bash
cd inference/language/bert

# 拷贝依赖代码
cp -r /root/MLC/repos/local/cache/get-git-repo_inference-src_7b09f8ca/inference/language/bert/DeepLearningExamples  .

# 初始化 build 目录结构
mkdir -p build/data/bert_tf_v1_1_large_fp32_384_v2/
mkdir -p build/result/

# 建立文件软链接 (防止 FileNotFoundError)
ln -sf /root/dev-v1.1.json build/data/dev-v1.1.json
ln -sf /root/MLC/repos/local/cache/download-file_bert-large-ml-m_229ad317/model.pb \
       build/data/bert_tf_v1_1_large_fp32_384_v2/model.pb
# 链接词表文件
ln -sf /root/MLC/repos/local/cache/download-file_bert-get-datase_8f14db6c/vocab.txt \
       build/data/bert_tf_v1_1_large_fp32_384_v2/vocab.txt

```

---

## 5. 执行推理测试
---

### 5.1.测试命令


|目标指标 | 场景 | 测试命令 |
| --- | --- |--- |
|最大吞吐量| **Offline** | `python3 run.py --backend tf --scenario Offline` |
|最低延时| **SingleStream** | `python3 run.py --backend tf --scenario SingleStream` |
|最大并发流| **MultiStream** | `python3 run.py --backend tf --scenario MultiStream` |
|20ms约束QPS| **Server** | `python3 run.py --backend tf --scenario Server(需配合 user.conf)` |

---

### 5.2. 如何设置“P99 20ms”和“目标QPS”？

要实现你要求的特定约束（如 Server 场景下 P99 < 20ms），你需要修改或创建一个 `user.conf` 文件。

**操作步骤：**

1. 在 `inference/language/bert` 目录下查找或新建一个名为 `user.conf` 的文件。
2. 在文件中添加以下内容（根据你的需求自定义数值）：

```ini
# 设置 Server 场景的目标 QPS 和延迟约束
bert.Server.target_qps = 100
bert.Server.target_latency = 20

# 设置 Offline 场景的目标吞吐量
bert.Offline.target_qps = 1000

# 设置 MultiStream 的延迟约束
bert.MultiStream.target_latency = 50

```

3. **运行命令时指定配置文件：**
使用 `--user_conf` 参数加载该配置：

```bash
python3 run.py --backend tf --scenario Server --user_conf user.conf

```

---

### 5.3. 如何找到最终的性能指标？

运行成功后，请忽略图片 1 中显示的“No warnings/errors”，直接抓取 `mlperf_log_summary.txt` 中的数据：

* **最大吞吐量 (Offline):** 查找 `Samples per second`。
* **最低延时 (SingleStream):** 查找 `Mean latency` 或 `90.00% percentile latency`。
* **P99 20ms 下的吞吐量 (Server):** 1. 首先确认 `Result is : VALID`（表示 99% 的请求都在你设定的 20ms 内完成了）。
2. 查找 `Scheduled samples per second`，这就是该约束下的最大吞吐量。
* **最大并发流数 (MultiStream):** 查找 `Samples per query`。





### 参数说明：

* `--backend tf`: 指定使用 TensorFlow 后端。
* `--scenario SingleStream`: 模拟单流低延迟推理场景。
* `--accuracy`: 开启精度验证模式。
* `--max_examples 100`: 快速验证环境，正式测试请移除此参数以跑完完整数据集。

---


