# Research Article 

## The effects of AZD3582 [4-(nitroxy)butyl-(2S)-2-(6-methoxy-2naphthyl) propanoate], and naproxen on key pathogenic steps in NSAID-enteropathy in the rat.

M. Walley, G. Sigthorsson, C. Hotz-Behofsits, R. Simpson, I. Bjarnason*

Guy's, King's and St Thomas' School of Medicine, Department of Gastroenterology, King's College Hospital Foundation Trust, Denmark Hill,<br>London SE5 9PJ, London, UK, Tel: ++2032992417, Fax: ++2032996474, e-mail: ingvar.Bjarnason @kcl.ac.uk

Received 9 October 2006; revised 27 January 2007; accepted 1 February 2007


Abstract. Background: The pathogenesis of NSAID-induced enteropathy may involve dual inhibition of the cyclooxygenase (1 and 2 ) and a topical effect with sequential increased intestinal permeability, development of inflammation and ulcers. It has been suggested that nitric-oxide donating drugs cause significantly less gastrointestinal injury by counteracting for NSAID-induced reductions in blood flow.

Aims: To compare the effects of AZD3582 [4-(nitroxy)butyl(2S)-2-(6-methoxy-2-naphthyl) propanoate], and naproxen on key pathogenic steps in NSAID-enteropathy in the rat.

Methods: Single doses of AZD3582, naproxen (dose range $10-300 \mu \mathrm{mol} / \mathrm{kg}$ ) or vehicle were given to male Sprague Dawley rats. Intestinal permeability ( ${ }^{1} \mathrm{CrEDTA}$ ) and intestinal inflammation (granulocyte marker protein) was quantitated and ulcer counts made.

Results: Intestinal permeability (all doses) and inflammation (highest dose of the drugs) increased significantly from control levels following naproxen and AZD3582 and there was no significant difference between the drugs. Median ulcer counts were, however, significantly ( $\mathrm{p}<0.01$ ) lower with AZD3582 (4 $\pm 2$ ) than with naproxen $(17 \pm 4)$.

Conclusions: Naproxen and AZD3582 are equally associated with increased small intestinal permeability and inflammation, which is the consequence of their topical effect. The reduced small bowel ulcer counts with AZD3582 accords with the suggestion that vascular factors are the main driving force for NSAID-induced ulcer formation.

Key words: NSAIDs; CINODs; Nitric oxide; Naproxen; AZD3582[^0]

## Introduction

Nonsteroidal anti-inflammatory drugs (NSAIDs) cause gastrointestinal side effects which involve the stomach as well as the small bowel mucosa (Hawkey and Langman, 2003). Although the serious gastric side effects of bleeding and perforation have attracted the most attention, it is increasingly clear that the small bowel is associated with similar types and prevalence of complications (Bjarnason et al., 1993; Laine et al., 2002)

The pathogenesis of NSAID-induced gastrointestinal damage is uncertain. There is substantial evidence to suggest that NSAID-enteropathy in rodents is caused by various combinations of the selective biochemical effects of NSAIDs including cyclooxygenase (COX)-1 and COX-2 inhibition together with the topical effect (Somasundaram et al., 1995). The topical effect is thought to relate to the physicochemical properties of NSAIDs to act as detergents (Lichtenberger et al., 1995) and uncouplers of mitochondrial oxidative phosphorylation (Somasundaram et al., 1995). Collectively, it is suggested that the topical effect results in increased intestinal permeability with mucosal exposure of luminal aggressive factors and hence inflammation. It is also suggested that NSAID-induced inhibition of COX1, with decreased amounts of vasoactive prostaglandins, drives this inflammation to ulcers (Wallace et al., 2000). Interestingly small bowel damage occurs with long-term COX-2 absence or inhibition (small bowel inflammation and ulcers) although the mechanisms are unclear (Sigthorsson et al., 2002).

One of the more recent suggestions for reducing the intestinal side effects of NSAIDs is to attach a nitric oxide (NO) moiety to the NSAID, in the hope that the NO might counteract the effect of prostaglandin deficiency on the intestinal microcirculation. NO donors have been used in patients with cardiovascular disease for more than a century (Burgaud et al., 2002). NO is recognised as an important modulator of a large number of physiological processes (Wallace and Miller, 2000). More specifically, NO increases mucosal blood flow and mucus secretion and decreases leukocyte adherence (Cirino et al., 1996; Wallace and Miller, 2000). As these actions could, in theory, counteract the effects of mucosal prostaglandin deficiency induced by NSAIDs, a class of COX-inhibiting nitric oxide donors (CINODs) have been developed. CINODs are frequently produced by the addition of a nitroxybutyl moiety to the carboxylic group of the NSAID (which mediates the binding to the COX enzymes) by means of an ester linkage (Fiorucci, 2001). As well as potentially offering improved gastrointestinal tolerability, CINODs may result in enhanced anti-inflammatory, anti-pyretic and analgesic effects when compared to NSAIDs (Fiorucci et al., 2002) or COX-2 selective agents, although this is a controversial issue.

Previous animal studies have indicated that CINODs may offer reduced adverse gastrointestinal effects when compared to the parent compounds (Elliott et al., 1995; Davies et al., 1997). More recently, human studies have demonstrated that NO-aspirin (NCX-4016) maintains COX-1 and platelet inhibition whilst nearly avoiding the short-term gastric damage (Fiorucci, et al., 2003) and that AZD3582 [4-(nitroxy)butyl(2S)-2-(6-methoxy-2-naphthyl) propanoate] reduces gastrointestinal toxicity when compared to naproxen (Hawkey et al., 2003).

The precise reason that these CINODs reduce the gastrointestinal damage of the parent drug is controversial. Their ester linkage to the NSAID abolishes their topical effect and their effect on the COX enzymes. In order to maintain therapeutic efficacy the CINOD needs to undergo hydrolysis yielding the parent NSAID and the NO moiety. If the beneficial effects of CINODs are due to their counteracting or compensating for the vascular effects of prostaglandin deficiency it might be expected that CINODs would be equally associated with the permeability and inflammatory changes of the comparator NSAID (consequence of the topical effect) whilst reducing the number of ulcers. We tested this hypothesis by comparing the effects of AZD3582 with those of naproxen on small bowel permeability (using ${ }^{51} \mathrm{CrEDTA}$ ), intestinal inflammation (quantitated by measurement of granulocyte marker protein (GMP)) and small bowel ulcer counts in rats.

## Methods

## Animals

Male Sprague Dawley rats (Charles Rivers), 6-8 weeks old, weighing $200-250 \mathrm{~g}$ were used throughout these studies. Two groups of animals were used. The first group was used for the measurement of intestinal permeability and ulcer counts while the second group was used to assess intestinal inflammation via the measurement of granulocyte marker protein (GMP) in stool samples. Animals were housed singly in metabolism cages for up to 9 days and fed standard laboratory diet and water. For measurement of intestinal inflammation, stool samples were collected each day from day 2 to day 9 (with the drugs being administered on day 5). Following an overnight fast (day 4), animals received AZD3582 or naproxen diluted in solvent (oil in water emulsion) from $60 \mu \mathrm{mol} / \mathrm{ml}$ emulsions and given by gastric gavage at the doses of $10,30,100$ or $300 \mu \mathrm{mol} / \mathrm{kg}$ ( $\mathrm{n}=8$ in each group). Control animals received solvent only. Ulcer counts were performed 48 hours after administration of the drugs or vehicle. The naproxen and AZD3582 were obtained from AstraZeneca, R\&D Sodertalje, Sweden.

## Intestinal Permeability

One hour after administration of the study drugs or vehicle, the rats were administered $10 \mu \mathrm{Ci}{ }^{51} \mathrm{CrEDTA}$ via a tube in a volume of $0.5 \mathrm{ml}$ water followed by $1 \mathrm{ml}$ of water. Animals were allowed food and fluids 2 hours later. All urine passed during the following 5 hours was collected and the samples were assayed for gamma-radioactivity along with standards ( $10 \%$ of the dose given) in a Wallac 1284 gamma counter (Pharmacia, Sweden) for 1 minute. Results are expressed as percentage of the oral dose that was excreted in urine, which provides a measure of intestinal permeability as previously described (Somasundaram et al., 2000).

## Intestinal Inflammation

Stool samples were collected on each day of the study and $1 \mathrm{~g}$ wet weight of each were added to $4 \mathrm{ml}$ of extraction buffer (Tris $50 \mathrm{mM}$, $\mathrm{NaCl} 150 \mathrm{mM}, \mathrm{CaCl}_{2} 10 \mathrm{mM}$, Thiomersal $0.25 \mathrm{mM}, \mathrm{pH}$ to 8.4$)$. The samples were then homogenized for 30 seconds at $20,000 \mathrm{rpm}$ using an Ultra Turrax homogenizer (IKE Werke, Germany) and spun in a microcentrifuge for 10 minutes at $13,000 \mathrm{rpm}$. The supernatant was decanted off into an eppendorf tube and the samples were assayed for GMP as previously described (Sigthorsson et al., 2002). In short $50 \mu 1$ of a 1:200 dilution in duplicate to 96 well microtitre plates were added. The plates were pre-coated with anti-GMP antibody. Equal volumes of 9 standards were also added to the plates in duplicate. The plates were incubated at room temperature on a plate shaker for 45 minutes, washed 4 times with rinsing buffer (Tris $50 \mathrm{mM}, \mathrm{NaCl} 150 \mathrm{mM}, \mathrm{MgCl}_{2} 0.5 \mathrm{mM}, \mathrm{KCl}$ $2.5 \mathrm{mM}$, Thiomersal $0.25 \mathrm{mM}$, Tween- $200.05 \%, \mathrm{pH}$ to 8.0 ) allowed to dry and then $50 \mu \mathrm{l}$ of alkaline phosphatase (ALP) conjugated anti-GMP (diluted 1:800 in assay buffer) was added to each well. The plates were incubated under the same conditions as before, washed and dried as before and then $100 \mu \mathrm{l}$ of substrate (p-nitrophenyl phosphate, $1 \mathrm{mg} / \mathrm{ml}$, in substrate buffer ( $10 \%$ diethanolamine), $\mathrm{MgCl}_{2} 0.5 \mathrm{mM}$, Thiomersal $0.25 \mathrm{mM}, \mathrm{pH} 9.6$ ) was added to each well. The optical density of the highest standard was monitored and when it read between 1.2-1.8, the reaction was stopped by adding $50 \mu 11 \mathrm{M} \mathrm{NaOH}$ to each well. The plates were read at $405 \mathrm{~nm}$ using an MRX plate reader plus Dynex Revelation software (Dynex Technologies, USA). The results are expressed in $\mathrm{mg} / \mathrm{l}$ of extract.

## Macroscopic studies

To assess ulceration within the small bowel, animals were euthanazed by $\mathrm{CO}_{2}$ inhalation 48 hours after administration of the drugs. The abdomen was opened via a midline incision and the small intestine isolated, removed and gently flushed with $0.9 \%$ saline. The intestinal mucosa was exposed by cutting along the anti-mesenteric side of the intestine. Ulcer counts were performed by noting both the number and size of the ulcers ( $\leq 5 \mathrm{~mm}$ were recorded as pointed, $>5 \mathrm{~mm}$ were recorded as longitudinal).

## Statistical analysis

Results are presented as median and range as not all data was normally distributed. Wilcoxon's rank sum test was used to assess statistical differences between groups and the Wilcoxon's signed rank test for sequential data.

## Results

## Intestinal Permeability

Figure 1 shows that administration of both naproxen and AZD3582 significantly increased intestinal permeability at all doses given when compared with baseline (vehicle only) ( $p<0.001$ ). There was no significant difference ( $p>0.05$ ) in intestinal permeability between AZD3582 and naproxen at any of the doses given.

## Intestinal Inflammation

There was no significant increase in GMP with the 10 or $30 \mu \mathrm{mol} / \mathrm{kg}$ doses of either drug (Figure 2). Rats given AZD3582 at a dose of $100 \mu \mathrm{mol} / \mathrm{kg}$ had GMP values significantly higher than the control group ( $p<0.05$ ). At doses of $300 \mu \mathrm{mol} / \mathrm{kg}$, a significant increase in intestinal inflammation was noted with both naproxen and AZD3582 when compared to the vehicle group ( $\mathrm{p}<0.01$ ). No significant difference was observed between the two drugs at any of the dose range tested.

## Macroscopic examination

On macroscopic examination, no ulcers were seen with either drug over a dose range of $0-100 \mu \mathrm{mol} / \mathrm{kg}$. The mean number of ulcers with naproxen $300 \mu \mathrm{mol} / \mathrm{kg}$ ) was 17.1 (range 10 29). The rats treated with AZD3582 had significantly fewer ulcers ( $\mathrm{p}<0.001$ ) (median 2.5; range 0-12) (Figure 3).



Fig. 1 Urinary excretion of 51 CrEDTA after Naproxen and AZD3582. The white circles represent median (bars represent range) values obtained from rats dosed with naproxen. The black circles represent values obtained from rats dosed with AZD3582. Urinary excretion of $51 \mathrm{CrEDTA}$ was measured 5 hours following dosing.



Fig. 2 GMP concentrations after Naproxen and AZD3582. The white circles represent median (bars represent range) GMP values obtained from rats dosed with naproxen. The black circles represent the GMP values obtained from rats dosed with AZD3582. Data shown is taken from the day following dosing.



Fig. 3 Small bowel ulcer counts after Naproxen and AZD3582. The white circles represent the number of ulcers in rats dosed with naproxen. The black circles represent the number of ulcers in rats dosed with AZD3582. Counts were made 48 hours after dosing with $300 \mu \mathrm{mol} / \mathrm{kg}$.

## Discussion

These studies show that AZD3582 is associated with significantly less small bowel ulcerative damage than naproxen while the postulated consequences of the topical effect, intestinal permeability and inflammation, is equally evident with both drugs. The findings are consistent (assuming that the NO is released prior to or during drug absorption ren-dering intact naproxen) with the aforementioned pathogenic framework for NSAID-induced small bowel damage and the suggestion that the NO maintains vascular perfusion following the administration of naproxen.

A number of studies show that virtually all acidic NSAIDs increase small intestinal permeability, by virtue of their acidity and lipid solubility, and it is suggested that that this is a prerequisite for the development of small intestinal inflammation (Sigthorsson et al., 2000). Unlike non-selective NSAIDs, the NO moiety of AZD3582 renders the molecule non-acidic, and hence it can not exert a topical effect in this form. Nevertheless it is still associated with increased intestinal permeability in the current experiments suggesting hydrolyses of the ester bond, presumably by gastric and more importantly pancreatic esterases (Somasundaram et al., 1997). This raises the possibility that the beneficial action of AZD3582 on the stomach (Hawkey et al., 2003; WilderSmith et al., 2006) may simply be due to its lack of topical toxicity (Rainsford and Whitehouse, 1980).

While both drugs were associated with similar increases in intestinal permeability there were no inflammatory changes following the lower ( 10 or $30 \mu \mathrm{mol} / \mathrm{kg}$ ) doses of the drugs unlike previous studies where inflammation invariably follows the intestinal permeability changes (Somasundaram et al., 1997; Somasundaram et al., 2000). The reasons for this may be that much higher doses of NSAIDs were administered in previous studies. Indeed at the higher doses of 100 and $300 \mu \mathrm{mol} / \mathrm{kg}$, dose dependent inflammation was seen for naproxen and AZD3582, the inflammation being similar for both drugs. It is noteworthy that NO itself, despite its potentially beneficial effect on microvascular blood flow and healing, may be directly toxic to the epithelial cells at high concentrations (Menconi et al., 1998).

The results of studies on AZD3582 can not be extrapolated over to other NO-NSAIDs as their method of production, stability, pharmacokinetics and rate of hydrolyses may differ. A similar study to the current one (Davies et al., 1997) nevertheless found more contrasting degrees of inflammation with naproxen compared to the CINOD. This study used higher drug doses and a much stricter dosing regime (twice daily dosing for over 2 weeks compared to our single dose over 8 days). However, Somasundaram (1997) using nitroxybutyl-flurbiprtofen obtained almost identical results to the current study.

Previous studies have clearly dissociated the consequences of the topical effect (increased intestinal permeability and inflammation) from the COX-1 inhibitory effect, which seems to drive the inflamed mucosa to an ulcerated one (Somasundaram et al., 2000). The ulcerative damage with AZD3582 was significantly less than for naproxen. The precise mechanism for this is nevertheless uncertain. Estimates of the metabolism of CINODs and NO-releasing drugs suggest that the rate of NO release from these compounds both in vitro and in vivo is slow in comparison to other NO donors such as sodium nitroprusside (SNP) and S-nitroso-N-acetyl-D,L-penicillamine (Keeble and Moore, 2002). However NO certainly has the potential to increase microvascular blood flow (Whittle, 2003) and thus reduce the damage (Wallace et al., 2000), but it also increases mucous secretion, reduces secretion and adhesion of neu- trophils and reduces cytokine release from macrophages, all of which may be impaired by COX inhibition (Wallace et al., 2000). It has also been suggested that cytochrome P450 may play a role in the metabolism of CINODs (Grosser and Schroder, 2000). Alternatively the bioavailability of naproxen from a dose of AZD3582 may be lower than from a dose of naproxen.

In summary, AZD3582 is associated with equal changes in increased intestinal permeability and inflammation as equimolar doses of naproxen. At the same time it is associated with significantly less ulcerative small bowel damage. These findings are consistent to the suggestions that NO derived from AZD3582 counteracts the vascular effects of NSAID-induced inhibition of COX.

Acknowledgements. The drugs and solvents were supplied by AstraZeneca, Sweden who supported this project.

## References

Bjarnason, I., Hayllar, J., Macpherson, A. J. et al. (1993). Side effects of nonsteroidal anti-inflammatory drugs on the small and large intestine in humans. Gastroenterology 104: 1832-1847.

Burgaud, J. L., Ongini, E. and Del Soldato, P. (2002). Nitric oxidereleasing drugs - A novel class of effective and safe therapeutic agents. Ann N. Y. Acad. Sci. 962: 360-371.

Cirino, G., Wheeler-Jones, C. P., Wallace, J. L. et al. (1996). Inhibition of inducible nitric oxide synthase expression by novel nonsteroidal anti-inflammatory derivatives with gastrointestinal-sparing properties. Br. J. of Pharmacol. 117: 1421-1426.

Davies, N. M., Roseth, A. G., Appleyard, C. B. et al. (1997). NO-naproxen vs naproxen: Ulcerogenic, analgesic and anti- inflammatory effects. Aliment. Pharmacol. Ther. 11: 69-79.

Elliott, S. N., McKnight, W., Cirino, G. et al. (1995). A Nitric Oxide-Releasing Nonsteroidal Antiinflammatory Drug Accelerates GastricUlcer Healing in Rats. Gastroenterology 109: 524-530.

Fiorucci, S. (2001). NO-releasing NSAIDs are caspase inhibitors. Trends in Immunology 22: 232-235.

Fiorucci, S., Antonelli, E., Mencarelli, A. et al. (2002). A NO-releasing derivative of acetaminophen spares the liver by acting at several checkpoints in the Fas pathway. Br. J. of Pharmacol. 135: 589-599.

Fiorucci, S., Santucci, L., Greasele, P. et al. (2003). Gastrointestinal safety of NO-aspirin (NCX-4016) in healthy human volunteers: a proof of concept endoscopic study. Gastroenterology 124: 600-607.

Grosser, N. and Schroder, H. (2000). A common pathway for nitric oxide release from NO-aspirin and glyceryl trinitrate. Biochem. Biophys. Res. Commun. 274: 255-258.

Hawkey, C. J., Jones, I. J., Atherton, C. T. et al. (2003). Gastrointestinal safety of AZD3582, a cyclooxygenase inhibiting nitric oxide donator: proof of concept study in humans. Gut 52: 1537-1542.

Hawkey, C. J. and Langman, M. J. (2003). Non-steroidal anti-inflammatory drugs: overall risks and management. Complementary roles for COX-2 inhibitors and proton pump inhibitors. Gut 52: 600-608.

Keeble, J. E. and Moore, P. K. (2002). Pharmacology and potential therapeutic applications of nitric oxide-releasing non-steroidal anti-inflammatory and related nitric oxide-donating drugs. $B r . J$. of Pharmacol. 137: 295-310.

Laine, L., Bombardier, C., Hawkey, C. J. et al. (2002). Stratifying the risk of NSAID-related upper gastrointestinal clinical events: Results of a double-blind outcomes study in patients with rheumatoid arthritis. Gastroenterology 123: 1006-1012.

Lichtenberger, L. M., Wang, Z-M., Romero. J. J. et al. (1995) Non-steroidal anti-inflammatory drugs (NSAIDs) associate with zwitterionic phospholipids: Insight into the mechanism and reversal of NSAID-induced gastrointestinal injury. Nat Med 1: 154-158

Menconi, M. J., Unno, N., Smith, M. et al. (1998). Nitric oxide donor-induced hyperpermeability of cultured intestinal epithelial monolayers: role of superoxide radical, hydroxyl radical, and peroxynitrite. Biochim. Biophys. Acta. 1425: 189-203.

Rainsford, K. D. and Whitehouse, M. W. (1980). Anti-inflammatory antipyretic salicylic acid esters, with low gastric ulcerogenic activity. Agents Actions. 10: 451-456.

Sigthorsson, G., Tibble, J., Mahmud, T. et al. (2000). NSAID-Induced gastrointestinal damage: the biochemical consequences of the "ion trapping" hypothesis. Inflammopharmacology 8: 31-41.

Sigthorsson, G., Simpson, R. J., Walley, M. et al. (2002). COX-1 and 2 , intestinal integrity and pathogenesis of NSAID-enteropathy in mice. Gastroenterology 122: 1913-1923.

Somasundaram, S., Hayllar, J., Rafi S. et al. (1995). The biochemical basis of NSAID-induced damage to the gastrointestinal tract: A review and a hypothesis. Scand J Gastroenterology. 30: 289-299.

Somasundaram, S., Rafi, S., Jacob, M. et al. (1997). Intestinal tolerability of nitroxybutyl-flurbiprofen in rats. Gut 40: 608-613.

Somasundaram, S., Sigthorsson, G., Simpson, R. J. et al. (2000). Uncoupling of intestinal mitochondrial oxidative phosphorylation and inhibition of cyclooxygenase are required for the development of NSAID-enteropathy in the rat. Aliment Pharmacol Ther 14: 639650.

Wallace, J. L. and Miller, M. J. S. (2000). Nitric oxide in mucosal defense: A little goes a long way. Gastroenterology 119: 512-520.

Wallace, J. L., McKnight, W., Reuter B. K. et al. (2000). NSAID-induced gastric damage in rats: requirement for inhibition of both cyclooxygenase 1 and 2. Gastroenterology. 119: 706-714.

Wilder-Smith CH, J. B., Fornstedt-Wallin, B., Hedman, A. et al. (2006). Dose-effect comparisons of the CINOD AZD3582 and naproxen on upper gastrointestinal tract mucosal injury in healthy subjects. Scand J Gastroenterol 41: 264-273.

Whittle, B. J. (2003). Nitric oxide and the gut injury induced by nonsteroidalanti-inflammatory drugs. Inflammopharmacology 11:415422.
