# Characterization of severely deformed new composites fabricated by powder metallurgy including a stage of mechanical alloying 

H. Ashuri, A. Hassani*<br>Faculty of Materials Science and Engineering, Semnan University, Semnan 35131-19111, Iran

## ARTICLE    INFO

## Article history:

Received 11 February 2014

Received in revised form 11 June 2014

Accepted 4 August 2014

Available online 12 August 2014

## Keywords:

Nanocomposite

Mechanical alloying

Twist extrusion

Powder metallurgy


#### Abstract

 Mechanical properties of new composites having a binary matrix of $\mathrm{Al}-4 \mathrm{Cu}$ reinforced with $\mathrm{TiO}_{2}$ nano particles were investigated. The composites which consisted of $2 \mathrm{wt} \%$ and $8 \mathrm{wt} \%$ of $\mathrm{TiO}_{2}$ reinforcement particles, were fabricated using mechanical alloying and a powder metallurgy route. Morphology, phases and compounds formed during ball milling and densification of samples were studied. With increasing percentages of the reinforcement particles, mechanical properties of the composites were enhanced. Microstructural evolution and mechanical properties changes of the composites after application of twist extrusion (TE), as a severe plastic deformation (SPD) process, were also investigated. It was revealed that the more TE passes the higher hardness and yield strength obtained. In addition, increasing TE passes, led to occurrence of a more homogeneous distribution of the reinforcement particles within the structure, and development of an ultrafine-grained nano-structure. The maximum allowable number of TE passes was found to be four, above which the materials failed.



## 1. Introduction

In recent decades, aluminum matrix composites (AMC) with discontinuous reinforcements have vastly been attracted by different industries due to their good mechanical properties. Large number of manufacture routes have been developed to produce these materials among which powder metallurgy (PM) routes have been more considered with several causes. First, in powder metallurgy a controlled phase microstructure can be achieved. On the other hand, lower temperatures used in PM processes make the interphase kinetics be precisely controlled. In PM routes, the powders of elements and alloys are used which might be more inexpensive, and of course, much more effective in reinforcement of the composites. Traditional stages of PM-AMCs fabrication include mixing and blending the powders; degassing the solidified product in vacuum; homogenizing through hot pressing or hot isostatic pressing (HIP) [1].

AMCs are widely used in automotive, aerospace and transport industries because of their light weight, high elastic modulus, improved strength and good wear resistance. Strength and wear resistance of these materials are strongly dependent on volume fraction, size and type of reinforcement particles. They are well established that compared to their un-reinforced matrix alloys show higher wear resistance. AMCs with ceramic particles including $\mathrm{SiC}, \mathrm{TiC}, \mathrm{C}_{4} \mathrm{~B}, \mathrm{TiB}_{2}$ and $\mathrm{Al}_{2} \mathrm{O}_{3}$ are relatively easy to process and, in comparison with fiber-reinforced composites, are nearly isotropic [2].

Particulate AMCs have introduced most wide spread applications and hold the greatest promise for future growth because of their tailored properties, low cost-effectiveness and high volume production methods [3]. Aluminum matrix composites are known to be hard materials exhibiting a low forming capacity through the conventional techniques. Nevertheless, many promising attempts have been made to produce Al composites with a high potential of being formed plastically and even superplastically while their strength is retained [4].

Mechanical alloying (MA) is an interesting powder metallurgy route for producing of powders with high homogeneity and uniformity. This technique is very effective in dispersion of reinforcement particles and enhances grain refinement, which induces an increase of strength and hardness [5].

In recent years, manifestation of severe plastic deformation (SPD) methods in material science has shed light on new prospects in achieving a unique combination of high strength and ductility [6] as well as attaining ultrafine-grained materials with improved properties. SPD is a family of metal forming techniques that use extensive hydrostatic pressure to impose a very high strain on bulk solids, producing exceptional grain refinement without introducing any significant change in the overall dimensions of the sample[7]. Several different SPD techniques are now available; these include high-pressure torsion (HPT) [8], equal channel angular pressing (ECAP) [9], multi-directional forging (MDF) [10], accumulative roll-bonding (ARB) [11], repetitive corrugation and strengthening (RCS) [12], spread extrusion (SE) [13], simple shear extrusion (SSE) [14] and twist extrusion (TE) [15,16]. The SPD products have much higher structural efficiency in comparison with their coarsegrained counterparts. However, high cost-effectiveness of most SPD methods is a central drawback to produce such materials in high quantities. Therefore, development of new SPD methods to tackle cost problem is important.

In 1999, Beygelzimer proposed a severe plastic deformation process that became known as Twist Extrusion (TE) [17]. This process can change the structure of materials, significantly improving some of their physical and mechanical properties and, even in certain cases, gaining new properties. TE works by extruding a prism specimen through a matrix whose profile consists of two prismlike regions separated by a twist passage. The extruded material undergoes an intense shift, with the properties that the final cross-section of the specimen is identical to the initial cross-section [18]. These properties allow for a repeated extrusion that accumulates the value of deformation. TE is carried out under high hydrostatic pressure in the center of deformation which is created by applying anti-pressure (back pressure) to the specimen when it exits the matrix. It is possible to produce more isotropic and homogeneous deformation by turning the samples $90^{\circ}$ in each consecutive deformation or alternatively, make the use of consecutive clockwise-anticlockwise-clockwise twists [19]. A comparison between TE and the two most widely used SPD methods, ECAE and HPT, reveals that firstly, TE provides some advantages over ECAE such as the ability to extrude the hollow parts and the rectangular cross-sections [6]. Secondly, HPT involves order of magnitude higher pressures than in any other SPD process which provides attainment of uniquely high strains and formation of ultrafine grained structures. From another point of view, twist extrusion that combines extrusion with torsion, was introduced to tackle the insufficiency of HPT, that is, its being limited to laboratory conditions due to small size of the samples [19]. There are currently three main application areas of TE: (a) obtaining ultrafine grained crystalline and nano-crystalline structures in bulk specimens, (b) increasing the plasticity of secondary non-ferrous metals and alloys, which allows one to significantly broaden the range of production, (c) obtaining bulk specimens by consolidating porous materials which allows one to create substantially different, new compositions with unique characteristics [20].

In TE, strain distribution along the cross-section of the specimen is inhomogeneous; getting away from the axe, plastic strain increases, thus, the grains being finer. The microstructural inhomogeneity leads to inhomogeneities in the mechanical properties of the composite; the central area of the cross section having lowest strength. It is expected that with increasing the number of TE cycles, the microstructure becomes uniform [21].

In the present study, a powder metallurgy route combined with mechanical alloying was employed to produce some particulate $\mathrm{Al}-\mathrm{Cu} / \mathrm{TiO}_{2}$ composites with low $\mathrm{TiO}_{2}$ contents. The products were then severely deformed by twist extrusion technique. The microstructures, densities, wear resistances, hardness and strengths of the resulted composites, in two different $\mathrm{TiO}_{2}$ reinforcement content of 2 and $8 \mathrm{wt} \%$ and at various TE cycles were examined.

## 2. Experimental procedures

To attain a uniform distribution of the $\mathrm{TiO}_{2}$ reinforcement particles in $\mathrm{Al}-\mathrm{Cu}$ matrix, a high-energy planetary ball-mill machine, manufactured by the authors was utilized and, the powder behavior was studied during the process. Milling time and the effects of volume fraction of the reinforcement and its particle size were also investigated. Aluminum powder with mean grain size of $<45 \mu \mathrm{m}$ and commercial purity of $99.9 \%$ and copper powder of $40 \mu \mathrm{m}$ with $99.0 \%$ purity were supplied. Nano-scale anatase $\mathrm{TiO}_{2}$ powder, as the reinforcement, having a mean size of $50 \mathrm{~nm}$ was also obtained. The powders specifications are shown in Table 1.

The appropriate proportions of $\mathrm{Al}$ and $\mathrm{Cu}$ powders were weighed using a digital balance of $0.001 \mathrm{mg}$ accuracy. Internal surfaces of the cups were wetted with a thin layer of glycerin to prevent sticking the powders mixtures on them. The powders were then mixed and blended in a high energy planetary ball mill to produce the matrix alloy powder. For ball-milling, chromium steel balls with diameters of 17 , $19,22,25$ and $30 \mathrm{~mm}$, ball-to-powder weight ratio of $20: 1$, constant rotational speed of $300 \mathrm{rpm}$ and argon atmosphere were used. Ball milling time was $16 \mathrm{~h}$. To reinforce the product, $2 \mathrm{wt} \%$ and $8 \mathrm{wt} \%$ of $\mathrm{TiO}_{2}$ particles were added and blended to a homogeneous mixture. The mixture was cold compacted into a two-piece die of DIN-1.2344 hot die steel having a hole of $15 \times 15 \times 80 \mathrm{~mm}$ dimensions for $15 \mathrm{~min}$ under $600 \mathrm{MPa}$. Then, to enhance apparent densities of powders, they were put into the die under $100 \mathrm{MPa}$ pressure being heated to temperatures of $550^{\circ} \mathrm{C}, 580^{\circ} \mathrm{C}$ and $640^{\circ} \mathrm{C}$. After reaching these temperatures, the pressure was turned up to $700 \mathrm{MPa}$ at which the samples were kept for 30,60 and $120 \mathrm{~min}$ to obtain three different densities. After sintering, the samples were furnace cooled and homogenized to room temperature at a rate of $21.8^{\circ} \mathrm{C} / \mathrm{h}$.

For twist extrusion testing, the samples were lubricated with $\mathrm{MoS}_{2}$ to reduce friction. Then, they were inserted into the entrance guide of the twist extrusion die being pushed to the distorted channel using a steel plunger with speed of $1.1 \mathrm{~mm} / \mathrm{s}$. The twist extrusion die of $14.6 \times 14.6 \mathrm{~mm}$ internal cross-section with a twist line slope of $\beta=60^{\circ}$ in the counter-clockwise direction was used (Fig. 1). In order to apply a backpressure on the sample, the output channel was built steeped. This channel, itself, acted as a direct extrusion die. Thus, after the specimen passes the twisted channel, enters a straight output passage of $29 \mathrm{~mm}$ length during which its cross-section changed from $14.6 \times 14.6 \mathrm{~mm}$ to $14.2 \times 14.2 \mathrm{~mm}$. In addition, for preventing deviation of the sample to the sides and making sure of upright entering of the sample into the twisted channel, an $80 \mathrm{~mm}$ channel with $15 \times 15 \mathrm{~mm}$ crosssection was developed at the entrance as the sample guide. Also, to inhibit stress concentration, the right angle corners of the die interior walls were blunted. In this research, two sets of $\mathrm{Al}-4 \mathrm{wt} \% \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{Al}-4 \mathrm{wt} \% \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ samples were extruded at velocity of $68.4 \mathrm{~mm} / \mathrm{min}$ (maximum velocity of the available press) for 1,2 and 4 passes. The maximum allowed number of TE passes was found to be four, above which material failure occurred during twist extrusion operation.

To investigate the microstructure changes in the materials due to twist extrusion, the samples were prepared by cutting from the cross-section perpendicular to the axial direction of the extruded billets. The microstructure evolution was then studied in the central, lateral and corner regions of the cross-section using scanning electron microscopy (SEM).

Densities of the compacted powders were determined through Archimedes procedure according to the standard ASTM B93-13 [22]. The microstructures of samples from both composites were studied using SEM model ISI ABT SR-50 equipped with EDX analyzer after their preparation including grinding, polishing and etching with Keller etchant solution. To investigate the formation of deleterious phases like $\mathrm{Al}_{7} \mathrm{Cu}_{2} \mathrm{Fe}$ and $\mathrm{Al}_{4} \mathrm{C}_{3}, \mathrm{X}$-ray diffraction examinations and scanning electron microscopy observations were carried out on the sintered composites. To evaluate grain size and lattice strain, spectroscope system equipped with copper ray lamp (wavelength $1.5405 \AA$ ) was utilized. Williamson-Hall equation was used to determine crystallite size and lattice strain in diffracting domain. For hardness measurements of the sintered samples, Vickers hardness testing machine with the applied force of $1000 \mathrm{~g}$ was utilized.

To evaluate wear resistance of the composite specimens, tribological studies were conducted according to ASTM G99-04 standard [23] using a WAZAU pin-ondisk wear testing machine connected to computer interface from Tribo V4.3L software. The samples were cut from the cross-section perpendicular to the extrusion direction. Hardness testing was performed on the points across cross-section diameter with $1 \mathrm{~mm}$ intervals from one corner to the other. The samples were cut by a Merck lathe from the upper part of the cylindrical samples to make disks of $50 \mathrm{~mm}$ diameter and $4 \mathrm{~mm}$ thickness. To polish the sample surfaces, they were ground against 100,200 , and 500 grit emery papers. As the wearing apparatus, pins of $5 \mathrm{~mm}$ length and $2 \mathrm{~mm}$ diameter from 2160 steel with 60 HRC were prepared. The applied force and sliding distance were selected to be $30 \mathrm{~N}$ and $1000 \mathrm{~m}$, respectively. Wear coefficient, K, was predicted using the Archard equation [24]:

$V=K W L / H$

where $V$ is the lost volume of the worn material, $H$ Brinell hardness, $W$ normal applied load equal to $30 \mathrm{~N}, L$ the sliding distance (m) and $K$ wear coefficient.

Table 1

Specifications of powders used in this study.

| Powder | Particle size | Purity (\%) |
| :--- | :--- | :--- |
| $\mathrm{Al}$ | $<45 \mu \mathrm{m}$ | 99.9 |
| $\mathrm{Cu}$ | $<40 \mu \mathrm{m}$ | 99 |
| $\mathrm{TiO}_{2}$ | $<50 \mathrm{~nm}$ | 99 |



Fig. 1. Twist channel of TE die with $\alpha=90^{\circ}$ and $\beta=60^{\circ}$.

To investigate mechanical properties of the composites and to plot true stresstrue strain relation, compression tests were carried out. The cylindrical compression samples were cut from the centre of the billets for 1,2 and 4 cycles with ratio of $H / D=1$, separately out of the samples containing 2 and $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ and, then were prepared and polished. The tests were conducted at ambient temperature. True stress-true strain relation of samples in each pass were inferred from compressive stress-strain curves.

## 3. Results and discussion

### 3.1. Powders specifications

Firstly, to determine the adequate milling duration, aluminum powder and $4 \mathrm{wt} \% \mathrm{Cu}$ powder were mixed and ball-milled for 5, 6 and $8 \mathrm{~h}$. The XRD patterns are compared in Fig. 2a. As seen, with increasing the milling time, the XRD peak intensities for aluminum and copper phases decreased and the XRD peak intensity of $\mathrm{Al}_{2} \mathrm{Cu}$ phase increased, therefore, it is inferred that after $8 \mathrm{~h}$ milling, the phase $\mathrm{Al}_{2} \mathrm{Cu}$ was formed and alloying process was completed.Now, $2 \mathrm{wt} \% \mathrm{TiO}_{2}$ reinforcement powder was added to the mixture and milled for 4 more hours (two-stage alloying). Next, aluminum, copper and $\mathrm{TiO}_{2}$ powders were mixed together and were milled in two portions for 12 and $16 \mathrm{~h}$ (one-stage alloying). Compressive results are shown in Fig. 2b. In two-stage conditions, as observed in Table 2, the subgrain size is smaller, but formation of $\mathrm{Al}_{7} \mathrm{Cu}_{2} \mathrm{Fe}$ brittle phase occurred that might be due to gradual intrusion of $\mathrm{Fe}$ into the mixture during ball-milling through surface erosion of the balls and cups. On the other hand, the weak signs of the formation of that phase were observed in one-stage milling for $16 \mathrm{~h}$. Therefore, to minimize the possible formation of the deleterious brittle phase of $\mathrm{Al}_{7} \mathrm{Cu}_{2} \mathrm{Fe}$ in the final product, all samples were produced through one-stage, $16 \mathrm{~h}$ ball-milling. In Fig. 2c, the results of X-ray diffraction experiments for milling of $\mathrm{Al}-4 \mathrm{wt} \% \mathrm{Cu}$ powder mixture containing $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ for $16 \mathrm{~h}$ are depicted. The results indicated the formation of $\mathrm{Al}_{2} \mathrm{Cu}$ phase which witnesses that the alloying was performed successfully. The deleterious brittle phase of $\mathrm{Al}_{7} \mathrm{Cu}_{2} \mathrm{Fe}$ was not observed in the final product.



Fig. 2. XRD results (a) for different milling times of Al-4Cu, (b) comparison of results for $12 \mathrm{~h} 2$-stage with $12 \mathrm{~h}$ and $16 \mathrm{~h} 1$-stage mechanical alloying and (c) for $16 \mathrm{~h}$ milling of powder mixture containing $8 \mathrm{wt} \% \mathrm{TiO}_{2}$.

Table 2

A comparison of subgrain size and grain strain in different milling times.

| Sample | Type of milling | Milling time $(\mathrm{h})$ | Subgrain size $(\mathrm{nm})$ | Grain strain |
| :--- | :--- | :--- | :--- | :--- |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | Two stage | 12 | 11 | 0.0017 |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | One stage | 12 | 33 | 0.0045 |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | One stage | 16 | 31.51 | 0.00475 |
| $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ | One stage | 16 | 28.41 | 0.00481 |

Table 3

Relative densities of samples at 700 Mpa pressure for $30 \mathrm{~min}$ at different temperatures.

| Sample | Theoretical density $\left(\mathrm{g} / \mathrm{cm}^{3}\right)$ | Bulk density $\left(\mathrm{g} / \mathrm{cm}^{3}\right)$ | Temperature $\left({ }^{\circ} \mathrm{C}\right)$ | Relative density $(\%)$ | Porosity percentage $(\%)$ |
| :--- | :--- | :---: | :--- | :--- | :--- |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | 2.797 | $2.256 \pm 0.0006$ | 550 | 90.31 | 9.69 |
|  |  | $2.7095 \pm 0.0004$ | 580 | 96.87 | 3.13 |
| $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ | 2.856 | $2.7452 \pm 0.003$ | 640 | 98.15 | 1.85 |
|  |  | $2.759 \pm 0.004$ | 640 | 98.64 | 1.36 |

### 3.2. Evaluation of composites

For hot compacting, the twist extruded samples having $2 \mathrm{wt} \% \mathrm{TiO}_{2}$, first, temperature of $550^{\circ} \mathrm{C}$ and, then $580{ }^{\circ} \mathrm{C}$ were applied. Densities of those samples were calculated using dipping-in-water procedure (Eqs. (2) and (3)) and, since their measured densities at above two temperatures were found to be very low ( $<97 \%)$, higher temperatures were applied. The applied pressure for all samples was fixed at $700 \mathrm{MPa}$ for $30 \mathrm{~min}$. Porosity volume fraction was also determined using Eq. (3); the results are presented in Table 3. For applying a uniform axial pressure, the ratio of height to diameter $(h / d)$ was about 1.5 .

$\rho=\frac{W_{\text {air }}\left\lfloor\rho_{\text {water }}-0.0012\right\rfloor}{0.99983\left\lfloor W_{\text {air }}-W_{\text {water }}\right\rfloor}+0.0012$

$\rho_{T}=\sum_{i=1}^{n} f_{i} \rho_{i}$

$\%$ Porosity $=\frac{\rho_{T}-\rho}{\rho_{T}} \times 100$

where $W_{\text {air }}$ is the measured weight of the sample in air, $W_{\text {water }}$ the weight in water, $\rho$ measured density, $\rho_{\text {water }}$ density in water, $\rho_{T}$ theoretical density.In hot compression test performed on composite, temperature of $640^{\circ} \mathrm{C}$ was applied for the other samples, but their holding time in the furnace increased to 60 and $120 \mathrm{~min}$. The final densities are tabulated in Table 4. In hot compression situations at $640{ }^{\circ} \mathrm{C}$ for $120 \mathrm{~min}$, the density of the sintered sample was nearly equal to the theoretical density of the composite. Therefore, the same conditions were repeated for the mixture powder containing $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ reinforcement. Because the density of $\mathrm{TiO}_{2}$ particles was higher than that of the matrix alloy $\left(4.5 \mathrm{~g} / \mathrm{cm}^{3}\right)$, it was anticipated that with increasing volume fraction of reinforcement particles, the relative density of the composite increased [5] which was consistent with the results depicted in Table 4.



Fig. 4. SEM micrograph of sample $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ showing large agglomerated $\mathrm{TiO}_{2}$ particles.

Table 4

Relative densities of samples at $700 \mathrm{MPa}$ pressure at $640^{\circ} \mathrm{C}$ and different times.

| Sample | Theoretical density $\left(\mathrm{g} / \mathrm{cm}^{3}\right)$ | Bulk density $\left(\mathrm{g} / \mathrm{cm}^{3}\right)$ | Time $(\mathrm{min})$ | Relative density $(\%)$ | Porosity percentage $(\%)$ |
| :--- | :--- | :--- | :--- | :--- | :--- |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | 2.797 | $2.252 \pm 0.0008$ | 30 | 98.15 | 1.85 |
|  |  | $2.757 \pm 0.0005$ | 60 | 98.59 | 1.41 |
| $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ | 2.856 | $2.769 \pm 0.0003$ | 120 | 99.01 | 0.99 |
|  |  | $2.833 \pm 0.0004$ | 120 | 99.20 | 0.80 |



Fig. 3. SEM images of samples reinforced with (a) 2 and (b) $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ particles prior to $\mathrm{TE}$.



Fig. 5. (a and b) XRD patterns of composites reinforced with $2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ nano-particles and (c and d) EDX analysis results for those composites, respectively.

Table 5

Weight percentage of elements in $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ derived from EDX analysis.

| Element | wt\% of element in $\mathrm{Al}-4 \mathrm{Cu} /$ <br> $2 \mathrm{wt} \% \mathrm{TiO}_{2}$ | wt\% of element in $\mathrm{Al}-4 \mathrm{Cu} /$ <br> $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ |
| :---: | :---: | :---: |
| $\mathrm{Al}$ | 84.1 | 77.14 |
| $\mathrm{Cu}$ | 3.88 | 3.68 |
| $\mathrm{Ti}$ | 2.08 | 7.86 |
| 0 | 9.94 | 11.32 |
| Total | 100 | 100 |

Fig. 3 shows SEM micrographs of the samples containing $2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ prior to TE with coarse distinct grains. As seen, the reinforcement particles are distributed uniformly within the matrix. The particles became finer with smooth edges and corners during ball-milling. Uniform distribution of nanoparticles within matrix, because of their high surface to volume ratio, is difficult. In the composites with $8 \mathrm{wt} \% \mathrm{TiO}_{2}$, distribution of these nano-particles was inhomogeneous resulting in formation of their large agglomerates; these usually impair mechanical properties of materials. This is more evident in Fig. 4.



Fig. 6. (a) $\mathrm{SE}$ images of composite reinforced with $2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{EDX}$ analysis of point $\mathrm{A}$ and $\mathrm{B}$, (b) $\mathrm{SE}$ micrograph of composite reinforced with 8 wt $\% \mathrm{TiO}_{2}$ with $\mathrm{EDX}$ analysis of points $A$ and $B$.



Fig. 7. Compression true stress-true strain curves for annealed samples until beginning of barreling.

According to XRD results shown in Fig. 5a, presence of the brittle phase (i.e. $\mathrm{Al}_{7} \mathrm{Cu}_{2} \mathrm{Fe}$ in the sintered $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ sample, which causes brittle fracture of the material, is confirmed. However, X-ray diffraction pattern in Fig. $5 \mathrm{~b}$ indicates that in the $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ sample, the brittle phase is absent. In the next stages of experiments, it will be noticed that with application of severe plastic strains, fracture of latter samples occurred more frequently in comparison with the former ones. For performing quantitative analysis of the existing elements in the samples, EDX was utilized. The results are depicted in Fig. 5(c) and (d) as well as in Table 5. Those results were obtained from surfaces of the samples showing the total weight percentage of the elements in the sintered samples. The analysis showed no contamination.

Fig. 6(a) shows secondary electron (SE) micrograph of a sample with composition of $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ together with $\mathrm{EDX}$ analyses of points A and B (specified with circles), which are nearly identical. Therefore, it is concluded that the reinforcing particles are uniformly distributed within the matrix, as mentioned earlier. However, EDX analyses of points A and B of SE micrograph of the sample $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ shown in Fig. 6 (b) are quite dissimilar. It means that a non-uniform distribution of $\mathrm{TiO}_{2}$ nano-particles coupled with their large agglomerates, which usually contribute to deterioration of mechanical properties of the composite, occurred.

Compression true stress-true strain curves of the annealed samples, in the case of $\mathrm{Al}-4 \mathrm{Cu}, \mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{Al}-4 \mathrm{Cu} /$ $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ are illustrated and compared in Fig. 7 and the results are shown in Table 6. It is evident that with increasing $\mathrm{TiO}_{2}$ content in the composite, yield stress and Young modulus increase but, ductility decreases. Perhaps, deletion of porosities during hot compression at $640^{\circ} \mathrm{C}$ for $120 \mathrm{~min}$ was effective in enhancement of the sample strength. On the other hand, $\mathrm{TiO}_{2}$ particles are stable thermodynamically, and do not react with the matrix phase at high temperatures. These particles act as barriers against movement of dislocations leading to ductility decrease [25].

Fig. 8 shows variation of lost volume of composites during wear test vs. sliding distance. As previously shown, with increasing the percentage of $\mathrm{TiO}_{2}$ reinforcement, the lost volume decreases. To predict wear coefficient, Eq. (1) was used. The graph in Fig. 9 shows variation of wear coefficient with sliding distance for all samples. As indicated, the lowest wear coefficient belongs to the composite having $8 \mathrm{wt} \% \mathrm{TiO}_{2}$. It is also evident in Table 7 that with increasing weight percentage of $\mathrm{TiO}_{2}$ particles, the hardness of the material increases. Such a hardness increasing can be attributed to the increasing of dislocation densities improving material resistance. Hardness increasing leads to enhancement of wear resistance of the composite [25].



Fig. 8. Variation of lost volume of matrix alloy and composite vs. sliding distance in wear test.



Fig. 9. Variation of wear coefficient for matrix alloy and composites vs. sliding distance at pressure of $30 \mathrm{~N}$.

Table 7

Mean Brinell hardness for different samples.

| Specimen | Hardness (Brinell) |
| :--- | :--- |
| $\mathrm{Al}-4 \mathrm{Cu}$ | 107 |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | 138 |
| $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ | 200 |

Fig. 10 are the backscattered electron BSE images of samples $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ from central and lateral regions. EDX examinations revealed that the two discrete dark and light regions corresponding to $\mathrm{TiO}_{2}$ clusters and the matrix, respectively. Fig. 10(a), (b), (e) and (f) shows the microstructure of two composites in central area after two passes and four passes of twist extrusion, respectively. It is revealed that grains became finer and the microstructure was more uniform with increasing the number of TE passes and this is same for Fig. 10(c), (d), (g) and (h) that illustrate the microstructure of lateral region of cross-section of both composites after two passes and four passes of TE, respectively. After four passes of TE in both composites, formation of nano-sized grains are evident. Unlike significant effect of billet axial rotations between ECAP passes [26,27], the billet rotations between TE passes have no effect on the plastic flow. This is due to the axial symmetry of the process.

Table 6

Results of uniaxial compression testing for annealed samples.

| Specimen | Young modulus (GPa) | Yield strength (GPa) | Barreling stress (MPa) | Barreling strain (\%) |
| :--- | :--- | :--- | :--- | :--- |
| $\mathrm{Al}-4 \mathrm{Cu}$ | 66 | 256 | 270 | 0.96 |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ | 70 | 246 | 0.93 |  284|
| $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ | 79.6 | 278 | 284 | 0.87 |



Fig. 10. BSC images of composites, up: $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and down: $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$, (a, b, e and f) central regions, after 2 and 4 passes, (c, d, $\mathrm{g}$ and $\mathrm{h}$ ) lateral regions, after 2 and 4 passes.



Fig. 11. Grain size measurement for a corner of cross-section of a sample containing $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ extruded for 2 passes.

Clustering of fine particles has been reported by Ritasalo et al. [28]. With increasing twist extrusion passes, $\mathrm{TiO}_{2}$ clusters became smaller having a more homogeneous distribution in the matrix. For the sample $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$, as observed, with increasing the number of TE passes, very fine equiaxed grains are formed. It is also evident that in the centre of the sample, the microstructure is less homogeneous and the formation of $\mathrm{TiO}_{2}$ clusters is observed. As indicated, in both types of samples, the microstructures in the corners and edges of the cross-section are more homogenous than those in the centers. This means that the corners experienced larger strains compared to the centre. In each pass of TE process, applying plastic deformation leads to an increase in dislocation density and, consequently formation of subgrains that impede dislocations glide gradually. With accumulation of plastic strains in subsequent passes, misorientation between neighboring grains increases and elongated grains turn to fine equiaxed ones resulting in a recrystallized microstructure [29]. This is the same phenomenon normally observed in SPD processes and is termed dynamic recrystallization [30].

Mishra et al. [29] suggested that when grains become smaller and also when the total area of grain boundaries increases, discrete dislocations emitted by a boundary are absorbed by the opposite grain boundary. Therefore, in higher passes of TE, dislocation density decreases gradually and high angle grain boundaries form. Shape of grains and rate of converting low angle boundaries to high angle ones in TE process depend on twist path and twist angle $(\alpha)$. It is worth noting that strain distribution and the boundary of deformation zones depend strongly on the geometry of die crosssection, i.e. deviation angle $(\beta)$ and twist angle $(\alpha)$, and by varying these factors, one can change strain intensity in different regions.

Grain sizes of the extruded samples were determined after each TE pass using a scaling-measuring utility installed to scanning electron microscope, as shown in Fig. 11 and the results are depicted in Table 8. It is inferred from Table 8 that with increasing TE passes, grain size in the centre and in the corners decreases. However, with increase of passes, the amount of strain that can be imposed on the sample, decreases. Such a decrease is further observed at edge regions. Therefore, uniformity of deformed structure increases and gradually, extent of grain refinement increases in central and lateral regions of the sample. This is due to structure stability brought about by saturation of the mechanical properties after the strain exceeds saturation limit. Such stability and saturation are not confined to TE, but are extended to all deformations based on pure shear like ECAP and so on. Mechanisms of this effect in PSD processes are such that with increasing passes (i.e. with increasing the strains), grain boundary surfaces also increase with a rate proportional to deformation state. During plastic deformation, cells or subgrains form and after a rather large strain, a considerable change does not occur in them. Therefore, with increasing strain, amount of high angle boundaries increases [29]. It is then concluded that with increasing the number of passes, the difference in grain sizes decreases in various regions of the sample. To determine extent of this difference in various passes, a variable index $(V)$ is defined as a ratio of standard deviation, SD to a parameter average value $\bar{x}$ as follows [31]:

$V=\frac{S D}{\bar{x}} \times 100$

Table 8

Mean grain size $(\mu \mathrm{m})$ of centers and corners of cross sections of two composites at various passes of TE.

| Sample | Position | Annealed | 1-pass | 2-pass | 4-pass |
| :--- | :--- | :--- | :--- | :--- | :--- |
| $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ | Corner | $20.9 \mu \mathrm{m}$ | $11 \mu \mathrm{m}$ | $9 \mu \mathrm{m}$ | $7.1 \mu \mathrm{m}$ |
|  | Center | $21.7 \mu \mathrm{m}$ | $20 \mu \mathrm{m}$ | $12 \mu \mathrm{m}$ | $8.4 \mu \mathrm{m}$ |
| $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ | Corner | $18.2 \mu \mathrm{m}$ | $10 \mu \mathrm{m}$ | $7.8 \mu \mathrm{m}$ | $5.6 \mu \mathrm{m}$ |
|  | Center | $18.8 \mu \mathrm{m}$ | $14 \mu \mathrm{m}$ | $9.8 \mu \mathrm{m}$ | $6.5 \mu \mathrm{m}$ |



Fig. 12. Grain size heterogeneity index for different passes for two composites.

Fig. 12 shows inhomogeneity of grain size for different passes and various $\mathrm{TiO}_{2}$ contents in composites. As indicated, the annealed sample is more homogeneous in grain size and, the sample extruded for one pass shows highest inhomogeneity. It is evident that with increasing the number of passes, the inhomogeneity of grain size decreases to a minimum of $V=\sim 16 \%$ for fourpass TE operation.

Fig. 13(a) shows the effect of $\mathrm{TiO}_{2}$ content on Vickers microhardness of the composites. A more uniform dispersion of $\mathrm{TiO}_{2}$ particle in the matrix impedes dislocation movements resulting in an increase of the hardness [32]. Fig. 13(b) and (c) shows the variation of hardness in the centre and corners of cross-section as well as mean hardness, in different passes of TE, for both types of composites. As seen, during first pass, the hardness increases dramatically, but in next passes, an obvious decrease in the curve slope is observed. This has been attributed to increase in dislocation density resulted from application of severe plastic deformation [29].Since corners get higher plastic strains than the centre, they possess higher hardness. However, with increasing the number of passes and gradual saturation of microstructure with strain due to saturation in dislocation density and, then development of a fine substructure, the heterogeneity in hardness distribution on the cross-section of the sample decreases. Therefore, despite occurrence of heterogeneity in deformation, hardness distribution is homogeneous at higher strains. Zendehdel et al. also reported homogeneity of hardness distribution at higher passes when they investigated influence of $\mathrm{TE}$ process on microstructure and mechanical properties of 6063 aluminum alloy [33]. Fig. 14(a) and (b) illustrates Vickers microhardness measured along diagonal line on cross-section of different samples. As indicated, hardness of samples increased noticeably after first pass compared to the annealed specimens. For the samples containing $2 \mathrm{wt} \% \mathrm{TiO}_{2}$, the hardness increased by $52 \%$ in average, but for the sample having $8 \mathrm{wt} \% \mathrm{TiO}_{2}$, the hardness increasing was $46 \%$. The hardness increase is lower for the central regions that undergoes lower strain levels and, higher for the lateral areas deformed by higher strains; this is due to higher redundant strains $\left(\varepsilon_{\mathrm{r}}\right)$ at the lateral regions [34]. The variation index, $V$, is also defined for description of heterogeneity level in hardness values. Using the variation index, $V$, calculated through Eq. (5) for different passes, Table 9 for the sample $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and Table 10 for the sample $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ are tabulated. Fig. 15 shows the heterogeneity index of hardness values $(V)$ for different passes of TE. It is inferred from Tables 9 and 10, and Fig. 15 that, in addition to increase in hardness within the central and lateral areas, and also increasing average hardness in whole sample, heterogeneity increased as well. Hardness heterogeneity index value in the sample of $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{TiO}_{2}$ extruded for 4 passes reached to 8.44 from 1.37 for the conditions before TE and, also in the sample of $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{TiO}_{2}$ extruded for 4 passes, $V$ value reached to 12.45 from 1.42 for the conditions before TE. It seems that heterogeneous distribution of hardness within whole sample was not significant due to application of backpressure during the process. Because backpressure is necessary for completion of cinematic conditions of applied plastic flow through tool geometry of $\mathrm{TE}$, and facilitates development of more homogeneous structure and mechanical properties [30].



Fig. 13. (a) Variation of Vickers hardness of composites with different $\mathrm{TiO}_{2}$ contents, prior to TE. (b) Variation of hardness at central and lateral regions of cross-section and mean hardness at different $\mathrm{TE}$ passes for composite $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$. (c) Variation of hardness at central and lateral regions of cross-section and mean hardness at different TE passes for composite $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$.



Fig. 14. Vickers hardness measured along diagonal line over cross section of (a) sample $\mathrm{Al}-4 \mathrm{Cu} 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ at various passes of $\mathrm{TE}$.



Fig. 15. Heterogeneity index of hardness values for various TE passes.

Table 9

Vickers microhardness values for samples $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ at different passes and their heterogeneity values.

| Sample | Hardness in center (HV) | Mean hardness (HV) | Hardness of edge (HV) | Heterogeneity V (\%) |
| :--- | :--- | :--- | :--- | :--- |
| Annealed | 145 | 146 | 147 | 1.3 |
| 1-pass | 217 | 224 | 231 |  6.25 |
| 2-pass | 225 | 234 | 243 |  7.69 |
| 4-pass | 227 | 237 | 247 |  8.44 |

Table 10

Vickers microhardness values for samples $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ at different passes and their heterogeneity values.

| Sample | Hardness in center (HV) | Mean hardness (HV) | Hardness of edge (HV) | Heterogeneity V (\%) |
| :--- | :--- | :--- | :--- | ---: |
| Annealed | 210 | 211.5 | 213 | 1.42 |
| 1-pass | 296 | 308.5 | 321 | 8.10 |
| 2-pass | 318 | 335.5 | 353 | 10.43 |
| 4-pass | 324 | 345.5 | 367 | 12.45 |



Fig. 16. Results of compression tests: (a) true stress-true strain curves for $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$, (b) true stress-true strain curves for $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO} \mathrm{O}_{2}$. (c) Variation of yield strength at different passes for both composites.

Table 11

Results of uniaxial compression testing on samples $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{Al}-4 \mathrm{Cu} / 8 \mathrm{wt} \% \mathrm{TiO}_{2}$ (Type 1 and Type 2, respectively) at different passes.

<table><thead><tr><th rowspan="2">Sample</th><th colspan="2">Young modulus (GPa)</th><th colspan="2"> Yield strength (MPa)</th><th colspan="2">Barreling strain MPa</th><th colspan="2"> Barreling strain (%)</th></tr><tr><th>Type 1</th><th>Type 2</th><th>Type 1</th><th>Type 2</th><th>Type 1</th><th>Type 2</th><th>Type 1</th><th>Type 2</th></tr></thead><tr><td>Annealed</td><td>70</td><td>79.6</td><td>246</td><td>278</td><td>284</td><td>298</td><td> 0.93</td><td> 0.87</td></tr><tr><td>1-pass</td><td>84</td><td> 94.9</td><td> 304</td><td> 325</td><td>241</td><td>347</td><td>0.80</td><td>0.74</td></tr><tr><td>2-pass</td><td>85</td><td>96.6</td><td>334</td><td>354</td><td>358</td><td>366</td><td>0.66</td><td>0.62</td></tr><tr><td>4-pass</td><td>87.6</td><td>97.2</td><td>368</td><td>372</td><td>383</td><td>391</td><td>0.65</td><td>0.61</td></tr></table>

Fig. 16(a) and (b) shows graphs obtained from compression tests including true stres-true strain curves derived from uniaxial compression test on samples $\mathrm{Al}-4 \mathrm{Cu} / 2 \mathrm{wt} \% \mathrm{TiO}_{2}$ and $\mathrm{Al}-4 \mathrm{Cu} /$ $8 \mathrm{wt} \% \mathrm{TiO}_{2}$ after different TE passes, respectively. The obtained results are compared in Table 11. Fig. 16(c) illustrates variation curves of yield strength for both composites in different TE passes. As indicated, with increasing number of passes, strength increased and ductility decreased. The strength increase extent in the first pass is obviously higher than that in the second and fourth passes which is due to gradual strain saturation in different regions, particularly those closer to the centre. By applying a few number of TE passes, strain exceeds saturation limit and saturation state gradually extends all cross-section area leading to uniformity in changing microstructure and other properties [35].

## 4. Conclusions

Mechanical alloying and powder metallurgy routes were applied to fabricate a new composite with binary matrix of Al$4 \mathrm{Cu}$ and reinforced by $2 \mathrm{wt} \% \mathrm{TiO}_{2}$ nano-particles. The annealed materials were subjected to some of the mechanical tests, and hardness, strength and yield strength were measured. With increasing percentages of the reinforcement particles, hardness, yield strength, Young modulus and wear resistance of the composites increased but ductility decreased. Afterwards, the composites were deformed severely through twist extrusion for 1,2 and 4 passes. The maximum allowable passes of extrusion was four, beyond which the materials did not endure plastic deformation and failed. It was revealed that with increasing the number of passes by 4 , a more homogeneous distribution of reinforcement particles occurred and also an ultrafine-grained nano-structure was obtained.

## References

[1] B. Ogel, R. Gurbuz, Microstructural characterization and tensile properties of hot pressed Al-SiC composites prepared from pure Al and Cu powders, Mater. Sci. Eng. A 301 (2001) 213-220.

[2] J. Onoro, M.D. Salvador, L.E.G. Cambronero, High-temperature mechanica properties of aluminium alloys reinforced with boron carbide particles, Mater. Sci. Eng. A 499 (2009) 421-426.

[3] R. Khorshidi, A. Hassani, Comparative analysis between TOPSIS and PSI methods of materials selection to achieve a desirable combination of strength and workability in Al/SiC composite, Mater. Des. 52 (2013) 999-1010.
[4] A. Hassani, M. Zabihi, High strain rate superplasticity in a nano-structured Al$\mathrm{Mg} / \mathrm{SiCP}$ composite severely deformed by equal channel angular extrusion, J. Mater. Des. 39 (2012) 140-150

[5] H. Kaftelena, M.L. Ovecoglua, H. Heneinb, H. Cimenoglua, $\mathrm{ZrC}$ particle reinforced $\mathrm{Al}-4 \mathrm{wt} \% \mathrm{Cu}$ alloy composites fabricated by mechanical alloying and vacuum hot pressing: microstructural evaluation and mechanical properties, Mater. Sci. Eng. A 527 (2010) 5930-5938,

[6] S.A.A. Akbari Mousavi, A.R. Shahab, M. Mastoori, Computational study of Ti$6 \mathrm{Al}-4 \mathrm{~V}$ flow behaviors during the twist extrusion process, Mater. Des. 29 (2008) 1316-1329.

[7] R.Z. Valiev, Y. Estrin, Z. Horita, T.G. Langdon, M.J. Zehetbauer, Y.T. Zhu, Producing bulk ultrafine-grained materials by severe plastic deformation, JOM 58 (4) (2006) 33-39.

[8] N.A. Smirnova, V.I. Levit, V.I. Pilyugin, R.I. Kuznetsov, L.S. Davydova, V.A. Sazonova, Evolution of structure of fcc single crystals during strong plastic deformation, Phys. Met. Metallogr. 61 (6) (1989) 127-134.

[9] M.V. Segal, V.I. Reznikov, A.E. Drobyshevskiy, V.I. Kopylov, Plastic metal working by simple shear, Izvestia Akademii nauk SSSR. Metally 1 (1981) 115123.

[10] G.A. Salishchev, O.R. Valiakhmetov, R.M. Galeyev, Formation of submicrocrystalline structure in the titanium alloy VT8 and its influence on mechanical properties, J. Mater. Sci. 28 (1993) 2898-2903.

[11] Y. Saito, H. Utsunomiya, N. Tsuji, T. Sakai, Novel ultra-high straining process for bulk materials development of the accumulative roll-bonding (ARB) process, Acta Mater. 47 (2) (1999) 579-583.

[12] J.Y. Huang, Y.T. Zhu, H.G. Jiang, T.C. Lowe, Microstructures and dislocation configurations in nanostructured Cu processed by repetitive corrugation and straightening, Acta Mater. 49 (9) (2001) 1497-1505.

[13] Y. Beygelzimer, V.N. Varyukhin, D.V. Orlov, S.G. Son, Twist extrusion - the accumulation of strain, Donetsk firma naukoemnih Technol. Natl. Acad. Sci. Ukraine (2003) 73-75.

[14] N. Pardis, R. Ebrahimi, Deformation behavior in simple shear extrusion (SSE) as a new severe plastic deformation technique, Mater. Sci. Eng. A 527 (1-2) (2009) 355-360.

[15] V. Varyukhin, Y. Beygelzimer, R. Kulagin, O. Prokofeva, A. Reshetov, Twist extrusion: fundamentals and applications, Mater. Sci. Forum 667-669 (2011) 31-37.

[16] Y. Beygelzimer, D. Orlov, V. Varyukhin, Proceedings of the Second International Symposium on Ultrafine Grained Materials, in: Y.T. Zhu (Ed.), Minerals, Metals, and Materials Society, Warren Dale (PA), 2002, pp. 297-301.

[17] Beygelzimer Y, Varukhin V, Synkov S, Sapronov A, Synkov V. New techniques for accumulating large plastic deformations using hydroextrusion, Fizika i Tekhnika Vusokih Davlenii (High Pressure Physics and Technology, in Russian) 1999; 9(3).

[18] Y. Beygelzimer, V. Varyukhin, D. Orlov, S. Sinkov, Twist extrusion: accumulating deformations 56 (2003) 456-465 (in Russian).

[19] Y. Beygelzimer, D. Prilepoa, R. Kulagina, V. Grishaeva, A. Abramovaa, V. Varyukhina, Planar twist extrusion vs. TWIST extrusion, J. Mater. Process Technol. 211 (2011) 522-529.

[20] V. Varukhin, Y. Beygelzimer, S. Synkov, D. Orlov, Applications of twist extrusion, Mater. Sci. Forum 503-504 (2006) 335-340.

[21] Y. Beygelzimer, V. Varyukhin, S. Synkov, D. Orlov, Useful properties of twist extrusion, Mater. Sci. Eng. A 503 (2009) 14-17.

[22] ASTM B962-13 Standard Test Methods for Density of Compacted or Sintered Powder Metallurgy (PM) Products Using Archimedes' Principle West Conshohocken, PA: ASTM International, 2004.

[23] G99-04 A. Standard test method for wear testing with a Pin-on-Disk apparatus. West Conshohocken, PA: ASTM International, 2004.

[24] J.F. Archard, Contact and rubbing of flat surfaces, J. Appl. Phys. 24 (1953) 981.

[25] C.S. Ramesha, A.R. Anwar Khanb, N. Ravikumar, P. Savanprabhu, Prediction of wear coefficient of $\mathrm{Al}_{6061}-\mathrm{TiO}_{2}$ composites Wear 259 (2005) 602-608.

[26] M. Furukawa, Y. Iwahashi, Z. Horita, M. Nemoto, T.G. Langdon, The shearing characteristics associated with equal-channel angular pressing, Mater. Sci. Eng. A 257 (2) (1998) 328-332.

[27] M.V. Segal, Slip line solutions, deformation mode and loading history during equal channel angular extrusion, Mater. Sci. Eng. A 271 (1-2) (1999) 322-333.

[28] R. Ritasalo, M.E. Cura, X.W. Liu, Y. Ge, T. Kosonen, U. Kanerva, O. Söderberg, S.P. Hannula, Microstructural and mechanical characteristics of $\mathrm{Cu}_{-1} \mathrm{Cu}_{2} \mathrm{O}$ composites compacted with pulsed electric current sintering and hot isostatic pressing, Composites: Part A 45 (2013) 61-69.

[29] A. Mishra, V. Richard, F. Gregori, R.J. Asaro, M.A. Meyers, Microstructural evolution in copper processed by severe plastic deformation, Mater. Sci. Eng. A 290 (2005) 410-411.

[30] D. Orlov, Y. Beygelzimer, S. Synkov, V. Varyukhin, N. Tsuji, Z. Horita, Plastic flow, structure and mechanical properties in pure Al deformed by twist extrusion, Mater. Sci. Eng. A 519 (2009) 105-111.

[31] Y. Beygelzimer, D. Orlov, A. Korshunov, S. Synkov, V. Varyukhin, I. Vedernikova, A. Reshetov, A. Synkov, L. Polyakov, I. Korotchenkova, Features of twist extrusion: method, structures and material properties, Solid State Phenomena 114 (2006) 69-78.

[32] G.S. Kataiah, D.P. Girish, The mechanical properties and fractography of aluminium $6061-\mathrm{TiO}_{2}$ composites, IJPSR I (2010) 17-25.

[33] H. Zendehdel, A. Hassani, Influence of twist extrusion process on microstructure and mechanical properties of 6063 aluminum alloy, Mater. Des. 37 (2012) 13-18.

[34] M.S. Mohebbi, A. Akbarzadeh, Experimental study and FEM analysis of redundant strains in flow forming of tubes, J. Mater. Process Technol. 210 (2010) 389-395

[35] Y. Beygelzimer, A. Reshetov, S. Synkov, O. Prokofeva, R. Kulagin, Kinematics of metal flow during twist extrusion investigated with a new experimental method, J. Mater. Proc. Technol. 209 (2009) 3650-3656.