dependent on the service headway and the reliability of the departure  time of the service to which passengers are incident.

After briefly introducing the random incidence model, which is  often assumed to hold at short headways, the balance of this section  reviews six studies of passenger incidence behavior that are moti- vated by understanding the relationships between service headway,  service reliability, passenger incidence behavior, and passenger  waiting time in a more nuanced fashion than is embedded in the  random incidence assumption ( 2 ). Three of these studies depend on  manually collected data, two studies use data from AFC systems,  and one study analyzes the issue purely theoretically. These studies  reveal much about passenger incidence behavior, but all are found  to be limited in their general applicability by the methods with  which they collect information about passengers and the services  those passengers intend to use.

# Random Passenger Incidence Behavior

One characterization of passenger incidence behavior is that of ran- dom incidence ( 3 ). The key assumption underlying the random inci- dence model is that the process of passenger arrivals to the public  transport service is independent from the vehicle departure process  of the service. This implies that passengers become incident to the  service at a random time, and thus the instantaneous rate of passen- ger arrivals to the service is uniform over a given period of time. Let  $W$  and $H$  be random variables representing passenger waiting times  and service headways, respectively. Under the random incidence  assumption and the assumption that vehicle capacity is not a binding  constraint, a classic result of transportation science is that

$$
E!\\left(W\\right)!=!\\frac{E!\\left\[H^{2}\\right\]}{2E!\\left\[H\\right\]}!=!\\frac{E!\\left\[H\\right\]}{2}!!\\left(1!+!\\operatorname{CV}!\\left(H\\right)^{2}\\right)
$$

where $E\[X\]$  is the probabilistic expectation of some random variable  $X$  and $\\operatorname{CV}(H)$  is the coefficient of variation of $H$ ,  a unitless measure  of the variability of $H$  defined as

$$
\\mathbf{CV}\\big(H\\big)!=!\\frac{\\boldsymbol{\\upsigma}\_{H}}{E\\big\[H\\big\]}
$$

where  $\\upsigma\_{H}$  is the standard deviation of $H\\left(4\\right)$ . The second expression  in Equation 1 is particularly useful because it expresses the mean  passenger waiting time as the sum of two components: the waiting  time caused by the mean headway (i.e., the reciprocal of service fre- quency) and the waiting time caused by the variability of the head- ways (which is one measure of service reliability). When the service  is perfectly reliable with constant headways, the mean ­ waiting time  will be simply half the headway.

# More Behaviorally Realistic Incidence Models

Jolliffe and Hutchinson studied bus passenger incidence in South  London suburbs ( 5 ). They observed 10 bus stops for  $^{1\\mathrm{~h~}}$  per day  over 8 days, recording the times of passenger incidence and actual  and scheduled bus departures. They limited their stop selection to  those served by only a single bus route with a single service pat- tern so as to avoid ambiguity about which service a passenger was  waiting for. The authors found that the actual average passenger  waiting time was $30%$  less than predicted by the random incidence  model. They also found that the empirical distributions of passenger  incidence times (by time of day) had peaks just before the respec- tive average bus departure times. They hypothesized the existence  of three classes of passengers: with proportion $q$ ,  passengers whose  time of incidence is causally coincident with that of a bus departure  (e.g., because they saw the approaching bus from their home or a  shop window); with proportion $p(1-q)$ , passengers who time their  arrivals to minimize expected waiting time; and with proportion  $(1-p)(1-q)$ , passengers who are randomly incident. The authors  found that $p$  was positively correlated with the potential reduction  in waiting time (compared with arriving randomly) that resulted  from knowledge of the timetable and of service reliability. They also  found $p$  to be higher in the peak commuting periods rather than in  the off-peak periods, indicating more awareness of the timetable or  historical reliability, or both, by commuters.

Bowman and Turnquist built on the concept of aware and unaware  passengers of proportions $p$  and $(1-p)$ , respectively. They proposed  a utility-based model to estimate $p$  and the distribution of incidence  times, and thus the mean waiting time, of aware passengers over  a given headway as a function of the headway and reliability of  bus departure times $(l)$ . They observed seven bus stops in Chicago,  Illinois, each served by a single (different) bus route, between 6:00  and $8{\\cdot}00;\\mathrm{a.m}$ . for 5 to 10 days each. The bus routes had headways  of 5 to  $20~\\mathrm{min}$  and a range of reliabilities. The authors found that  actual average waiting time was substantially less than predicted  by the random incidence model. They estimated that $p$  was not  statistically significantly different from 1.0, which they explain by  the fact that all observations were taken during peak commuting  times. Their model predicts that the longer the headway and the  more reliable the departures, the more peaked the distribution of  incidence times will be and the closer that peak will be to the next  scheduled departure time. This prediction demonstrates what they  refer to as a safety margin that passengers add to reduce the chance  of missing their bus when the service is known to be somewhat  unreliable. Such a safety margin can also result from unreliability in  passengers’ journeys to the public transport stop or station. Bowman  and ­ Turnquist conclude from their model that the random incidence  model underestimates the waiting time benefits of improving reli- ability and overestimates the waiting time benefits of increasing ser- vice frequency. This is because as reliability increases passengers  can better predict departure times and so can time their incidence to  decrease their waiting time.

Furth and Muller study the issue in a theoretical context and gener- ally agree with the above findings ( 2 ). They are primarily concerned  with the use of data from automatic vehicle-tracking systems to assess  the impacts of reliability on passenger incidence behavior and wait- ing times. They propose that passengers will react to unreliability by  departing earlier than they would with reliable services. Randomly  incident unaware passengers will experience unreliability as a more  dispersed distribution of headways and simply allocate additional  time to their trip plan to improve the chance of arriving at their des- tination on time. Aware passengers, whose incidence is not entirely  random, will react by timing their incidence somewhat earlier than  the scheduled departure time to increase their chance of catching the  desired service. The authors characterize these ­ reactions as the costs  of unreliability.

Luethi et al. continued with the analysis of manually collected  data on actual passenger behavior ( 6 ). They use the language  of probability to describe two classes of passengers. The first is  timetable-dependent passengers (i.e., the aware passengers), whose  incidence behavior is affected by awareness (possibly gained
