```markdown
# ClearerVoice-Studio 快速部署与运行指南（国产 DCU 环境）

## 1. 启动 Docker 容器（DCU 专用）

```bash
# 拉取镜像
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10

# 启动容器（必须带全以下参数）
docker run -it \
  --network=host \
  --ipc=host \
  --shm-size=64G \
  --device=/dev/kfd \
  --device=/dev/mkfd \
  --device=/dev/dri \
  -v /opt/hyhal:/opt/hyhal \
  --group-add video \
  --cap-add=SYS_PTRACE \
  --security-opt seccomp=unconfined \
  image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.5.1-ubuntu22.04-dtk25.04.2-py3.10 \
  /bin/bash
```


## 2. 下载并安装 ClearerVoice-Studio

```bash
git clone https://github.com/modelscope/ClearerVoice-Studio.git
cd ClearerVoice-Studio
pip install -r requirements.txt

cd clearvoice
pip install --editable .
cd ..
```

## 3. 快速测试

```bash
# 设置 HuggingFace 国内镜像（强烈建议）
export HF_ENDPOINT=https://hf-mirror.com

# 运行官方测试脚本
python test.py
```

看到 `Inference completed successfully` 或类似输出即表示成功。


## 参考资料

- 官方仓库：https://github.com/modelscope/ClearerVoice-Studio/tree/main/clearvoice  
- 中文教程：https://stable-learn.com/zh/clearvoice-studio-tutorial  

## 小贴士

- 模型下载慢请务必设置 `HF_ENDPOINT=https://hf-mirror.com`

