
from clearvoice import ClearVoice
import os

# 初始化语音增强模型
cv_se = ClearVoice(
    task='speech_enhancement',
    model_names=['MossFormer2_SE_48K']
)

# 处理单个音频文件
input_path = 'samples/input.wav'
output_wav = cv_se(
    input_path=input_path,
    online_write=False
)

# 保存增强后的音频
output_dir = 'samples/enhanced'
os.makedirs(output_dir, exist_ok=True)
output_path = os.path.join(output_dir, 'enhanced.wav')
cv_se.write(output_wav, output_path=output_path)
