# --fp16：使用半精度
# --onnx：模型路径
# --input-dim：模型输入维度
#	@unique_ids_raw_output___9:0 1：标志位无需修改
#	@segment_ids:0 256 256：第一个数为batch size，默认256；第二个数为序列长度，默认256
#       @input_mask:0 256 256：第一个数为batch size，默认256；第二个数为序列长度，默认256
#	@input_ids:0 256 256：第一个数为batch size，默认256；第二个数为序列长度，默认256


data=$(date +"%Y-%m-%d-%H-%M-%S")
logdir=/datasets/logs_comomm_model_infer/bert/${data}

if [ ! -f ${logdir} ]; then
    mkdir ${logdir} -p
fi

HIP_VISIBLE_DEVICES=0 /opt/dtk-24.04.1/bin/migraphx-driver perf -n 20 --fp16 --gpu --onnx ./weights/bertsquad-10.onnx \
	--input-dim @unique_ids_raw_output___9:0 1 @segment_ids:0 256 256 @input_mask:0 256 256 @input_ids:0 256 256 \
	2>&1 | tee ${logdir}/pert-bert-bs-256-seqlen-256.log
