#include "roctracer_wrapper.h"
#include "hip/hip_runtime.h"
#include "roctracer/roctx.h"
#include <iostream>
#include <sstream>

class RoctracerWrapper::Impl {
public:
    Impl() {
        // 初始化HIP
        hipError_t err = hipInit(0);
        if (err != hipSuccess) {
            std::cerr << "Failed to initialize HIP: " << hipGetErrorString(err) << std::endl;
        }
    }
    
    ~Impl() {
        // 清理资源
    }
    
    void mark(const std::string& message) {
        roctxMark(message.c_str());
    }
    
    int rangeStart(const std::string& message) {
        return roctxRangeStart(message.c_str());
    }
    
    void rangePush(const std::string& message) {
        roctxRangePush(message.c_str());
    }
    
    void rangePop() {
        roctxRangePop();
    }
    
    void rangeStop(int id) {
        roctxRangeStop(id);
    }
    
};

RoctracerWrapper::RoctracerWrapper() : impl(std::make_unique<Impl>()) {}
RoctracerWrapper::~RoctracerWrapper() = default;

void RoctracerWrapper::mark(const std::string& message) { impl->mark(message); }
int RoctracerWrapper::rangeStart(const std::string& message) { return impl->rangeStart(message); }
void RoctracerWrapper::rangePush(const std::string& message) { impl->rangePush(message); }
void RoctracerWrapper::rangePop() { impl->rangePop(); }
void RoctracerWrapper::rangeStop(int id) { impl->rangeStop(id); }