from setuptools import setup, find_packages
import os
import sys
import shutil

# 创建 roctracer_py 目录结构
package_dir = 'roctracer_py'
os.makedirs(package_dir, exist_ok=True)

# 创建 __init__.py
init_py = os.path.join(package_dir, '__init__.py')
if not os.path.exists(init_py):
    with open(init_py, 'w') as f:
        f.write('''"""
ROCtracer Python Bindings
"""
import os
import sys
import ctypes

# 首先加载依赖库
lib_path = os.path.join(os.path.dirname(__file__), 'libroctracer_wrapper.so')
if os.path.exists(lib_path):
    ctypes.CDLL(lib_path, mode=ctypes.RTLD_GLOBAL)

# 然后加载主模块
module_path = os.path.join(os.path.dirname(__file__), 'roctracer_py.cpython-310-x86_64-linux-gnu.so')

# 重命名 .so 文件以匹配模块名
target_so = os.path.join(os.path.dirname(__file__), 'roctracer_py.so')
if os.path.exists(module_path) and not os.path.exists(target_so):
    os.symlink(module_path, target_so)  # 或者使用 shutil.copy2

# 尝试导入
try:
    from .roctracer_py import *
    __all__ = ['roctracer_py']
except ImportError as e:
    print(f"警告: 无法导入 roctracer_py: {e}")
    print(f"确保 .so 文件在: {module_path}")

__version__ = "0.1.0"
''')

# 复制 .so 文件到包目录
so_files_to_copy = [
    ('build/roctracer_py.cpython-310-x86_64-linux-gnu.so', 
     os.path.join(package_dir, 'roctracer_py.so')),
    ('build/libroctracer_wrapper.so', 
     os.path.join(package_dir, 'libroctracer_wrapper.so'))
]

for src, dst in so_files_to_copy:
    if os.path.exists(src) and not os.path.exists(dst):
        print(f"复制 {src} 到 {dst}")
        shutil.copy2(src, dst)

setup(
    name="roctracer_py",
    version="0.1.0",
    packages=[package_dir],
    include_package_data=True,
    package_data={
        package_dir: ['*.so', '*.py'],
    },
    install_requires=[],
)