#ifndef ROCTRACER_WRAPPER_H
#define ROCTRACER_WRAPPER_H

#include <string>
#include <memory>

class RoctracerWrapper {
public:
    RoctracerWrapper();
    ~RoctracerWrapper();
    
    // 标记点
    void mark(const std::string& message);
    
    // 范围操作
    int rangeStart(const std::string& message);
    void rangePush(const std::string& message);
    void rangePop();
    void rangeStop(int id);
    
private:
    class Impl;
    std::unique_ptr<Impl> impl;
};

#endif // ROCTRACER_WRAPPER_H