#!/usr/bin/env bash

script_path=$(dirname "$0")
cd $script_path

function zf()
{
    return 8
    echo "[INFO] Adapter_$1 is Z100 DCU Card."
    echo "[INFO] Will not automatically upgrade Vbios for the Z100 board. If you need to update the vbios, it is recommended to manual Vbios upgrade!"
}

function km()
{
    echo "[INFO] Adapter_$1 is K100 DCU Card"

    # Check the production testing card.
    m1_f2_board=`./hyflash --index $1 --version | egrep -i 'DEV-M1|DEV-F2' | wc -l`
    if [[ $m1_f2_board -ne 0 ]]; then
        echo "[Warning] Internal production testing cards do not recommend vbios upgrades! Exit upgrade."
        echo "------------------------------------------------------------------------------------------"
        return 8
    fi

    # Check the type of K100 card
    opn_k100_ai=`./hyflash --index $1 --opnInfo | grep -i 8275 | wc -l`
    opn_k100_hpc=`./hyflash --index $1 --opnInfo | grep -i 8285 | wc -l`
    if [[ $opn_k100_ai -ne 0 ]] && [[ $opn_k100_hpc -eq 0 ]]; then
        # K100 DCU board
        update_ai_vbios=1
    elif [[ $opn_k100_ai -eq 0 ]] && [[ $opn_k100_hpc -ne 0 ]]; then
        # K100SM DCU board
        update_hpc_vbios=1
    else
        cnt_dev_k100_ai=`./hyflash --index $1 --list | grep -i 62B7 | wc -l`
        cnt_dev_k100_hpc=`./hyflash --index $1 --list | grep -i 61B7 | wc -l`
        if [[ $cnt_dev_k100_ai -ne 0 ]]; then
            update_ai_vbios=1
        elif [[ $cnt_dev_k100_hpc -ne 0 ]]; then
            update_hpc_vbios=1
        else
            echo "[ERROR] Unrecognized KM device, Exit vbios upgrades!"
            exit -1
        fi
    fi

    if [[ $update_ai_vbios -ne 0 ]]; then
        # K100 62B7 DCU board
        vbios_file_name=`ls ./KM/ai-k100-*.bin`
    elif [[ $update_hpc_vbios -ne 0 ]]; then
        # K100 61B7 DCU board
        vbios_file_name=`ls ./KM/hpc-*.bin`
    fi

    # K100 vbiso upgrade.
    if [ -z "$vbios_file_name" ]; then
        echo "[ERROR] No vbios file found! Exit vbios upgrade..."
        exit -1
    else
        cnt_vbios_cmpr=`./hyflash --index $1 --compare $vbios_file_name | grep -i Mismatch | wc -l`
        if [[ $cnt_vbios_cmpr -ne 0 ]]; then
            #echo "[INFO] Auto Upgrade vbios(filename: $vbios_file_name):"
            ./hyflash --index $1 --umc --board --ecc --rate
            ./hyflash --index $1 --update $vbios_file_name --ecc off
        else
            echo "[INFO] The DCU vbios of adapter_$1 is already the latest version!"
            echo "----------------------------------------------------------------"
            return 8
        fi
    fi

    return $?
}

function zd()
{
    echo "[INFO] Adapter_$1 is K100_AI DCU Card"

    # K100_AI DCU board
    vbios_file_name=`ls ./ZD/K100_AI-*.bin`

    # K100_AI vbiso upgrade.
    if [ -z "$vbios_file_name" ]; then
        echo "[ERROR] No vbios file found! Exit vbios upgrade..."
        exit -1
    else
        cnt_vbios_cmpr=`./hyflash --index $1 --compare $vbios_file_name | grep -i Mismatch | wc -l`
        if [[ $cnt_vbios_cmpr -ne 0 ]]; then
            ./hyflash --index $1 --umc --board --ecc --rate
            ./hyflash --index $1 --update $vbios_file_name --ecc off
        else
            echo "[INFO] The DCU vbios of adapter_$1 is already the latest version!"
            echo "-----------------------------------------------------------------"
            return 8
        fi
    fi

    return $?
}

function update()
{
    opn_k100=`./hyflash --index $1 --opnInfo | grep -i 82.5 | wc -l`
    opn_e100=`./hyflash --index $1 --opnInfo | egrep -i '8375|8277' | wc -l`
    if [ $opn_k100 -ne 0 ]; then
        # K100 DCU board
        km $1
    elif [ $opn_e100 -ne 0 ]; then
        # K100_AI DCU board
        zd $1
    else
        dev_k100=`./hyflash --index $1 --list | grep -i 6.b7 | wc -l`
        dev_z100=`./hyflash --index $1 --list | grep -i 5.b7 | wc -l`
        dev_e100=`./hyflash --index $1 --list | grep -i 6210 | wc -l`
        if [[ $dev_k100 -ne 0 ]] && [[ $dev_z100 -ne 0 ]] && [[ $dev_e100 -ne 0 ]]; then
            echo "[ERROR] Adapter_$1: Unrecognized Hygon dcu board type! only support K100, Z100 or K100_AI cards."
            exit -1
        elif [[ $dev_k100 -eq 0 ]] && [[ $dev_z100 -eq 0 ]] && [[ $dev_e100 -eq 0 ]]; then
            echo "[ERROR] Adapter_$1: Unrecognized hygon dcu card type!"
            exit -1
        elif [[ $dev_k100 -ne 0 ]] && [[ $dev_e100 -eq 0 ]] && [[ $dev_z100 -eq 0 ]]; then
            # K100 DCU board
            km $1
        elif [[ $dev_e100 -ne 0 ]] && [[ $dev_k100 -eq 0 ]] && [[ $dev_z100 -eq 0 ]]; then
            # K100_AI DCU board
            zd $1
        elif [[ $dev_z100 -ne 0 ]] && [[ $dev_k100 -eq 0 ]] && [[ $dev_e100 -eq 0 ]]; then
            # Z100 DCU board
            zf $1
        fi
    fi

    return $?
}

function Determine_en_vbios_upgrade()
{
    # check the total number of K100 board
    cnt_km=`./hyflash --index a --list | egrep -i 'K100|K100_AI' | wc -l`
    cnt_opn_km=`./hyflash --index a --opnInfo | egrep -i '82.5|8375|8277' | wc -l`
    if [[ $cnt_km -eq 0 ]] && [[ $cnt_opn_km -eq 0 ]]; then
        echo "Not found K100 or K100_AI board! Exit VBIOS upgrade."
        echo "-----------------------------------------------------------"
        exit 0
    else
        # 提示用户输入
        read -p "Found $cnt_km K100/K100_AI board. Do you want to upgrade vbios automatically? [Y/n] " response

        # 将输入转换为小写以便不区分大小写进行比较
        response=${response,,}
        case "$response" in
            y|yes)
                # 选择升级VBIOS
                echo "Start upgrade vbios automatically."
                return 0
                ;;
            n|no)
                # 选择不升级Vbios
                echo "Not upgrade vbios automatically."
                exit 0
                ;;
            *)
                echo "Invalid input. Please enter 'Y' or 'n'."
                exit -1
                ;;
        esac
    fi
}

function board_vbios_update()
{
    cnt_dcu_update_err=0
    cnt_dcu_update_ok=0
    cnt_dcu=`./hyflash --index a --list | grep -i 'Total [0-9]' | awk '{print $2}'`
    if [[ $cnt_dcu -ge 1 && $cnt_dcu -le 8 ]]; then
        echo "----------- Total $cnt_dcu Hygon DCU board were detected ----------"
        # Determine_en_vbios_upgrade

        # Start vbios upgrade of K100 board
        for ((i=0; i<$cnt_dcu; i++)); do
            update $i
            # Check the vbios update return
            ret=$?
            if [ $ret -eq 0 ]; then
                cnt_dcu_update_ok=$((cnt_dcu_update_ok+1))
            elif [ $ret -ne 8 ]; then
                cnt_dcu_update_err=$((cnt_dcu_update_err+1))
            fi
        done
    else
        echo "[Warning] No Hygon DCU board detected!"
    fi

    if [ $cnt_dcu_update_err -ne 0 ]; then
        echo "[ERROR]----- Total $cnt_dcu_update_err boards burn vbios failed, Please investigate the cause of the problem! ------";
        exit -1
    elif [ $cnt_dcu_update_ok -ne 0 ]; then
        echo "[OK]----------- Burn all board vbios successful! ----------- "
    fi

    exit 0
}

board_vbios_update
