#ifndef HYLOG_PORTABILITY_H
#define HYLOG_PORTABILITY_H

#ifdef _MSC_VER
#define HYLOG_ALWAYS_INLINE __forceinline
#elif defined(__GNUC__)
#define HYLOG_ALWAYS_INLINE inline __attribute__((__always_inline__))
#else
#define HYLOG_ALWAYS_INLINE inline
#endif

#ifdef _MSC_VER
#define HYLOG_NOINLINE __declspec(noinline)
#elif defined(__GNUC__)
#define HYLOG_NOINLINE __attribute__((__noinline__))
#else
#define HYLOG_NOINLINE
#endif

#ifdef _MSC_VER
#define HYLOG_PACK_PUSH __pragma(pack(push, 1))
#define HYLOG_PACK_POP __pragma(pack(pop))
#elif defined(__GNUC__)
#define HYLOG_PACK_PUSH _Pragma("pack(push, 1)")
#define HYLOG_PACK_POP _Pragma("pack(pop)")
#else
#define HYLOG_PACK_PUSH
#define HYLOG_PACK_POP
#endif

#ifdef _MSC_VER
#ifdef _USE_ATTRIBUTES_FOR_SAL
#undef _USE_ATTRIBUTES_FOR_SAL
#endif

#define _USE_ATTRIBUTES_FOR_SAL 1
#include <sal.h>

#define HYLOG_PRINTF_FORMAT _Printf_format_string_
#define HYLOG_PRINTF_FORMAT_ATTR(string_index, first_to_check)
#elif defined(__GNUC__)
#define HYLOG_PRINTF_FORMAT
#define HYLOG_PRINTF_FORMAT_ATTR(string_index, first_to_check) \
  __attribute__((__format__(__printf__, string_index, first_to_check)))
#else
#define HYLOG_PRINTF_FORMAT
#define HYLOG_PRINTF_FORMAT_ATTR(string_index, first_to_check)
#endif

#endif /* HYLOG_PORTABILITY_H */
