#!/bin/bash

set -x

docker_image=ollama_k100ai_v1
tag=latest


export MY_CONTAINER="base_dtk24.04.1_torch_ollama_k100ai"
num=`docker ps -a|grep "$MY_CONTAINER"|wc -l`
echo $num
echo $MY_CONTAINER

par=$1
if [ 0 -eq $par ];then
echo "${MY_CONTAINER} container has destroy."
docker stop ${MY_CONTAINER}
docker rm -f ${MY_CONTAINER}
echo "${MY_CONTAINER} container has destroy."
exit
fi

if [ 0 -eq $num ];then

# --rm 使用完后，容器会自动删除退出;
# export HIS_VISIBLE_DEVICES=0 \
docker run -itd \
--name ${MY_CONTAINER} \
--shm-size=32G \
--ipc=host \
--network=host \
--privileged \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
-v /opt/hyhal:/opt/hyhal \
-v /home:/home \
--group-add video \
--cap-add=SYS_PTRACE \
--security-opt seccomp=unconfined \
${docker_image}:${tag} \
/bin/bash


# 在 Docker 中，--network=host 和 --ipc=host 分别控制着容器与宿主机在不同方面的资源共享：
# --network=host： 当指定 --network=host 启动容器时，容器将不会创建独立的网络命名空间，而是直接使用宿主机的网络命名空间。这意味着容器内的应用将共享宿主机的所有网络接口和端口，容器内的服务可以直接监听宿主机的任意端口，无需进行端口映射。例如，如果在容器内运行了一个 Web 服务器并监听 80 端口，那么外部可以直接通过宿主机的 80 端口访问到这个 Web 服务器。
# --ipc=host： 当指定 --ipc=host 启动容器时，容器将与宿主机共享同一个 IPC（进程间通信，Inter-Process Communication）命名空间。这允许容器内的进程与其他容器或宿主机上的进程使用 System V IPC、POSIX 共享内存或者消息队列进行通信。如果没有指定此选项，Docker 会为每个容器创建一个独立的 IPC 命名空间，容器内的进程只能与其自身容器内的其他进程进行 IPC 通信。
# 总结来说，这两个选项都是为了打破容器的默认隔离机制，以实现更深层次的资源集成与共享：
# --network=host 主要是打破了网络层面的隔离，让容器共享宿主机的网络资源。
# --ipc=host 则是在进程间通信层面打破了隔离，使得容器内的进程可以和其他容器或宿主机上的进程进行直接的低级别通信


# --privileged 会导致指定GPU卡的透传失效，从而透传所有的GPU卡

# --device=/dev/kfd \
# --device=/dev/dri \ 

else

docker start $MY_CONTAINER
docker exec -ti --env COLUMNS=`tput cols` --env LINES=`tput lines` $MY_CONTAINER /bin/bash
fi
