# 基于DCU开源代码适配Ollama

DCU上 v0.3.9 ollama 和 ollama 官方保持一致。


教程见: [./tutorial_ollama/01-ollama_open-webui.md](./tutorial_ollama/01-ollama_open-webui.md)


## 适配步骤

工程地址：http://developer.hpccube.com/codes/wangkx1/ollama_dcu.git

### **1. 拉取工程, 根据readme解压构建ollama的压缩文件;**

```bash
git clone http://developer.hpccube.com/codes/wangkx1/ollama_dcu.git -b v0.3.9

cd ollama_dcu

tar -xvf ollama.tar
cp -r /opt/hyhal ./
tar -zxvf cmake-3.29.3.tgz

```
### **2. 执行如下命令, 开始构建镜像;**

```bash
# sudo docker build -t <镜像名字> .  # ollama_k100ai 可以更改为自己想要的镜像名字
# 构建涉及到大规模的代码编译, 时间预计花费15分钟左右

# sudo docker build -t <自定义的镜像名字> .

sudo docker build -t ollama_k100ai_v0.3.9 .
```

### **3. 构建成功，查看镜像**

```bash
(base) sugon@ailab:~$ sudo docker images
[sudo] password for sugon: 
REPOSITORY                                        TAG                                   IMAGE ID       CREATED              SIZE
ollama_k100ai_v0.3.9                              latest                                b60143c747ea   About a minute ago   20.2GB
```

### **4. 进入容器**

```bash

docker run -id \
    --name ${CONTAINER_NAME} \
    --shm-size=32G \
    --ipc=host \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    --network=host \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/mkfd \
    --device=/dev/dri \
    -e OLLAMA_HOST=0.0.0.0:11434 \
    -v /opt/hyhal:/opt/hyhal \
    ollama_k100ai_v0.3.9:latest \
    /bin/bash
```


### **5. 启动 ollama**


<font color=red>**注意:**</font>


<font color=red>**设置关键环境变量步骤，只需要设置一次即可:**</font>

```bash

# 前提，确保已经进入容器

vim ~/.bashrc, 键盘输入 i

# 不指定的话, 无法在其他机器调用 ollama 服务
# export OLLAMA_HOST="0.0.0.0:11434"

# 如果有迁移的本地模型仓库, 需要增加环境变量
# /local—model-path 建议从容器外映射到容器内
# export OLLAMA_MODELS=/local—model-path

切换至英文输入法, 键盘输入: Esc 后, 输入 wq + enter , 保存退出;
激活环境变量:  source ~/.bashrc
```


<font color=red>**建议启动ollama容器的方法:**</font>

在终端执行:

`ollama serve &`


说明:

- 命令末尾使用`空格 + &`结尾, 直接将启动的ollama设置到后台执行, 如果需要停止 ollama 服务, 进入容器后, 执行 `pkill ollama`
### **6. ollama 拉取模型**

ollama 模型仓: https://ollama.com/library

<font color=red>**建议ollama拉取模型的方法:**</font>

- 前提: 
    1. 确保当前处于容器之中, 可以参考[4. 进入容器](#4-进入容器) 确认自己进入容器
    2. 确保 ollama serve 命令已经执行;

- 运行命令:  `ollama pull llava`

- 说明: `ollama pull <model-name:tag>`
   - `<model-name:tag>` 可以从 https://ollama.com/library 参考;


### **7. 运行模型**
 

前提: 
   1. 确保当前处于容器之中, 可以参考[4. 进入容器](#4-进入容器) 确认自己进入容器
   2. 确保 ollama serve 命令已经执行;

ollama 执行`run`命令, 会自动拉取模型

#### 7.1 ollama 运行对话大模型 llama3


运行命令:  `ollama run llama3`


#### 7.2 ollama 运行多模态大模型 llava

运行命令:  `ollama run llava`

对话过程中可以输入`本地图像的绝对路径`，多模态大模型会对图片内容自动进行一个描述

### **8. 自定义模型**

我们可以利用下载到本地的GGUF模型文件，创建一个Modelfile模型描述文件给ollama使用。 

文件名称: llama3-zh.mf

文件内容:

---

FROM ./xxx.gguf

---

FROM 后面的内容是 GGUF模型文件 的路径，创建好模型描述文件后，我们使用ollama命令行工具即可将模型注册到本地:

ollama create llama3-zh -f ./xxx.mf


此时我们就可以使用`ollama list`和`ollama run`等命令操作这个模型了



### **9. ollama + open-webui**


见: [./tutorial_ollama/01-ollama_open-webui.md](./tutorial_ollama/01-ollama_open-webui.md)
