# Examples: ollama + open-webui 


ollama 官方网站：https://ollama.com/

ollama Github地址：https://github.com/ollama/ollama

open-webui 文档说明：https://docs.openwebui.com/

open-webui Github地址：https://github.com/open-webui/open-webui

---

### **1 部署形式、流程介绍**

- open-webui 和 ollama 都采用容器形式部署;
- 首先部署 ollama, 启动 ollama 服务
- 其次利用`docker compose`, 启动 open-webui 服务
- 本地web输入: 服务器网址:映射的端口 , 注册账号, 设置中对`ollama`进行连接，开启对话;


### **2 启动 ollama + open-webui**


open-webui 镜像获取链接:

通过百度网盘分享的文件：open-webui.tgz
链接：https://pan.baidu.com/s/1iHycUYGS9MSabMXz4eIs9w 
提取码：xndp 
--来自百度网盘超级会员V5的分享


加载镜像: `docker load -i open-webui.tgz`

前提: 
- 安装`docker-compose`: 
    - 安装命令: `sudo apt install docker-compose`

- **`docker-compose.yml` 根据实际情况修改**:

    ```bash
    image: ghcr.io/open-webui/open-webui:main
    container_name: ollama-webui
    restart: unless-stopped
    ports:
        - 11433:8080  # 11433 如果冲突也可以自行设置端口(端口范围:1024-65535)
    # volumes:
        # - ./data:/app/backend/data
    environment:
        - OLLAMA_API_BASE_URL=http://101.6.161.43:11434/api  # ollama服务的ip:端口, 101.6.161.43 即为服务器ip, 端口为默认为11434，如果参考 `01-ollama_llama3_llava.md` 之中第2部分的内容进行了更改，选择更改后的端口
        - WEBUI_SECRET_KEY=123456
    ```    

<font color=red>启动open-webui命令, 在终端执行:</font>

```bash
cd tutorial_ollama
# 一键启动
sudo docker-compose up -d
```

### **3 本地浏览器配置:**

4.1. 浏览器之中输入: http://101.6.161.43:选择的端口 进入, (101.6.161.43 即为服务器ip, 端口和docker-compose.yml里ports设置的一样);

   - 需要等待10分钟左右，等待open-webui完全启动，才会弹出登录页面;

4.2. 初次登录需要注册，设置用户名、邮箱、密码，第一个注册的用户为admin账户，其他用户登录需要admin用户同意.

4.3. 登录成功后，点击左下角头像，点击setting设置，选择connections, 设置Ollama的Base URL, 点击后面的连接按钮测试连接，然后点击保存，显示保存成功即可。

4.4. 回到首页，点击 `Select a model` 后面的下拉箭头，如果之前在`ollama`的服务里`pull`过模型，这时会看到已经存在的，如下比如之前`pull`过`llama3`和`llava`