#!/bin/bash

pip3 install modelscope -i https://pypi.tuna.tsinghua.edu.cn/simple

# 设置日志目录
LOG_DIR="./log_downloads"
CACHE_DIR="./"
# 检查并创建日志目录
if [ ! -d "$LOG_DIR" ]; then
    echo "创建日志目录: $LOG_DIR"
    mkdir -p "$LOG_DIR"
fi

# 检查并创建缓存目录
if [ ! -d "$CACHE_DIR" ]; then
    echo "创建缓存目录: $CACHE_DIR"
    mkdir -p "$CACHE_DIR"
fi

# 要下载的模型列表
MODELS=(
    "deepseek-ai/DeepSeek-R1-0528"
    "Qwen/Qwen3-235B-A22B-GPTQ-Int4"
    "Qwen/Qwen3-235B-A22B"
)

# 遍历并下载每个模型
for MODEL_ID in "${MODELS[@]}"; do
    echo "开始下载模型: $MODEL_ID"
    python3 model_downloader.py \
        --model-id "$MODEL_ID" \
        --cache-dir "$CACHE_DIR" \
        --log-dir "$LOG_DIR"
    
    # 检查上一个命令的退出状态
    if [ $? -eq 0 ]; then
        echo "模型 $MODEL_ID 下载完成"
    else
        echo "模型 $MODEL_ID 下载失败"
    fi
done

echo "所有模型下载任务完成"
