#!/bin/bash

SERVER_IP="node1"       # 服务端的 IP 地址

for CLIENT_IP in master node2 node3; do
# CLIENT_IP="node1"        # 客户端的 IP 地址
TEST_DURATION=10         # 测试持续时间（秒）
log_dir_name=ibperf_result_${SERVER_IP}_${CLIENT_IP}
# 判断目录是否存在，若不存在则创建
if [ -d "$log_dir_name" ]; then
    echo "目录 '$log_dir_name' 已存在。"
else
    echo "目录 '$log_dir_name' 不存在，正在创建..."
    mkdir -p "$log_dir_name"
    if [ $? -eq 0 ]; then
        echo "目录 '$log_dir_name' 创建成功。"
    else
        echo "目录 '$log_dir_name' 创建失败，请检查权限或其他问题。"
        exit 1 # 表示有错误发生，程序非正常退出
    fi
fi


# 定义变量
for IB_DEV in mlx5_1 mlx5_2 mlx5_3 mlx5_4 mlx5_7 mlx5_8 mlx5_9 mlx5_10; do
#for IB_DEV in mlx5_9; do


    LOG_FILE="${log_dir_name}/bandwidth_test_${IB_DEV}.log" # 日志文件名

    # 清空日志文件
    > "$LOG_FILE"

    # 启动服务端
    echo "Starting server on $SERVER_IP..."
    ib_write_bw --ib-dev=$IB_DEV --connection=RC --qp=32 > /dev/null 2>&1 &
    SERVER_PID=$!

    # 等待服务端启动完成
    sleep 2

    # 启动客户端
    echo "Starting client on $CLIENT_IP..."
    ssh root@$CLIENT_IP "ib_write_bw --ib-dev=$IB_DEV $SERVER_IP --CPU-freq --report_gbits --duration=$TEST_DURATION --connection=RC --mtu=4096 --qp=32 --size=65536" >> "$LOG_FILE" 2>&1

    # 等待客户端完成
    sleep $((TEST_DURATION + 2))

    # 停止服务端
    echo "Stopping server on $SERVER_IP..."
    kill $SERVER_PID

    # 输出测试结果
    echo "Bandwidth test completed. Results saved to $LOG_FILE."
    cat "$LOG_FILE"

    cd ${log_dir_name}
    ls
    echo "Filename,    BW_Average" > output.csv
    for file in *.log; do
        bw_avg=$(awk '/#bytes/{getline; print $4}' "$file")
        echo "$file,    $bw_avg" >> output.csv
    done
    cat output.csv

    cd -
done


done
