#!/bin/bash

# 1. 添加 10.17.30.230 hygon.ai.com 到 /etc/hosts 文件的末尾
HOST_ENTRY="10.17.27.100 hygon.ai.com"
HOSTS_FILE="/etc/hosts"

if ! grep -q "$HOST_ENTRY" "$HOSTS_FILE"; then
    echo "$HOST_ENTRY" | sudo tee -a "$HOSTS_FILE"
    echo "已添加 $HOST_ENTRY 到 $HOSTS_FILE"
else
    echo "$HOST_ENTRY 已存在于 $HOSTS_FILE 中"
fi

# 2. 从远程服务器下载 harbor.crt 文件
REMOTE_USER="root"
REMOTE_HOST="10.17.27.100"
REMOTE_PATH="/home/harbor/key/harbor.crt"
LOCAL_PATH="/etc/ssl/certs/"

echo "如需使用, 请私聊索要密码"

scp "$REMOTE_USER@$REMOTE_HOST:$REMOTE_PATH" "$LOCAL_PATH"
if [ $? -eq 0 ]; then
    echo "文件已成功下载到 $LOCAL_PATH"
else
    echo "文件下载失败"
fi

# sudo update-ca-certificates
echo "Please do as follows so that you can start enjoying using harbor"
echo "1. sudo systemctl daemon-reload"
echo "2. sudo systemctl restart docker"
