#/bin/bash

# set -x
# 脚本作用: 、
# 1. bash launch.sh 直接进入容器
# 2. bash launch.sh d / bash launch.sh destroy 删除容器
# 3. bash launch.sh p / bash launch.sh print 打印容器名称



docker_image=dcu_ai:v1.1
export CONTAINER_NAME="yolov5_test_dtk24.04.1"

command="docker run -id \
    --name ${CONTAINER_NAME} \
    --shm-size=32G \
    --ipc=host \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    --network=host \
    --privileged \
    -e https_proxy=http://10.17.26.123:8086 \
    -e http_proxy=http://10.17.26.123:8086 \
    --device=/dev/kfd \
    --device=/dev/mkfd \
    --device=/dev/dri \
    -v /opt/hyhal:/opt/hyhal \
    -v /home/wkx/yolov5/datasets:/datasets \
    ${docker_image} \
    /bin/bash"


# 检查 CONTAINER_NAME 环境变量是否设置
if [ -z "${CONTAINER_NAME}" ]; then
    echo "环境变量 CONTAINER_NAME 未设置，请设置后再试。"
    exit 1
fi


check_command_result() {
    # 获取传递给函数的退出状态
    local exit_status=$1
    
    # 根据退出状态采取行动
    if [ "$exit_status" -eq 0 ]; then
        echo "命令成功执行"
    else
        echo "命令执行失败，退出状态为: $exit_status"
        exit $exit_status
    fi
}


# 使用 docker ps -a | grep 来查找容器，并计算结果行数
num=$(docker ps -a | grep "$CONTAINER_NAME" | wc -l)

# 检查容器是否存在
if [ "$num" -gt 0 ]; then
    echo "Container:[${CONTAINER_NAME}] already exists"

    #! 功能: 检测是否输入参数，而且参数是否符合类型，进行停止删除操作
    # 检查是否有参数传入
    if [ "$#" -gt 0 ]; then
        # 获取第一个参数
        param="$1"
        if [ "$param" = "d" ] || [ "$param" = "destroy" ]; then
            # echo "参数是 d 或者 destroy"
            docker stop ${CONTAINER_NAME}
            docker rm -f ${CONTAINER_NAME}
            echo "container:[${CONTAINER_NAME}] finish destroy."
        fi

        if [ "$param" = "p" ] || [ "$param" = "print" ]; then
            # echo "参数是 d 或者 destroy"
            echo "container:[${CONTAINER_NAME}]."
            exit
        fi
    else  #! 如果没参数传入, 则直接进入容器
        docker start $CONTAINER_NAME        
        docker exec -ti --env COLUMNS=`tput cols` --env LINES=`tput lines` $CONTAINER_NAME /bin/bash
        exit
    fi 
    #!

else
    echo "Container:[${CONTAINER_NAME}] does not exist, will be created and go inside it."

    eval ${command}

    check_command_result $?
    echo "Container:[${CONTAINER_NAME}] Created successfully!"

    docker start $CONTAINER_NAME
    exit_status=$?


    echo "Container:[${CONTAINER_NAME}] Started successfully!"
    docker exec -ti --env COLUMNS=`tput cols` --env LINES=`tput lines` $CONTAINER_NAME /bin/bash
    exit
fi
