from flask import Flask, render_template, request, jsonify
import os

app = Flask(__name__)

# 任务文件路径
TASK_FILE = "tasks.txt"

# 初始化任务文件
def init_task_file():
    if not os.path.exists(TASK_FILE):
        with open(TASK_FILE, 'w') as file:
            file.write("")

# 获取所有任务
def get_tasks():
    with open(TASK_FILE, 'r') as file:
        tasks = file.readlines()
    return [task.strip() for task in tasks]

# 添加任务
def add_task(task):
    with open(TASK_FILE, 'a') as file:
        file.write(task + "\n")

# 删除任务
def remove_task(task):
    tasks = get_tasks()
    with open(TASK_FILE, 'w') as file:
        for t in tasks:
            if t != task:
                file.write(t + "\n")

# 首页路由
@app.route('/')
def index():
    tasks = get_tasks()
    return render_template('index.html', tasks=tasks)

# 添加任务接口
@app.route('/add', methods=['POST'])
def add():
    task = request.form.get('task')
    if task:
        add_task(task)
    return jsonify({"status": "success", "tasks": get_tasks()})

# 删除任务接口
@app.route('/remove', methods=['POST'])
def remove():
    task = request.form.get('task')
    if task:
        remove_task(task)
    return jsonify({"status": "success", "tasks": get_tasks()})

# 启动服务
if __name__ == '__main__':
    init_task_file()
    app.run(debug=True)