import yaml
import smtplib
from email.mime.text import MIMEText
import os
import sys
import time
import schedule

# 加载配置文件
def load_config():
    with open('eml.yml', 'r') as file:
        return yaml.safe_load(file)

# 发送邮件
def send_email(subject, body):
    config = load_config()
    msg = MIMEText(body)
    msg['Subject'] = subject
    msg['From'] = config['email']['from']
    msg['To'] = config['email']['to']

    with smtplib.SMTP(config['email']['smtp_server'], config['email']['smtp_port']) as server:
        server.starttls()
        server.login(config['email']['username'], config['email']['password'])
        server.sendmail(config['email']['from'], config['email']['to'], msg.as_string())

# 初始化任务文件
def init_task_file(task_path):
    with open(task_path, 'w') as file:
        file.write("")
    send_email("Task Initialized", f"Task file created at {task_path}")

# 添加任务
def add_task(task_path, task):
    with open(task_path, 'a') as file:
        file.write(task + "\n")
    tasks = get_tasks(task_path)
    send_email("Task Added", f"Task added: {task}\n\nCurrent Tasks:\n{tasks}")

# 删除任务
def remove_task(task_path, task):
    with open(task_path, 'r') as file:
        tasks = file.readlines()
    with open(task_path, 'w') as file:
        for t in tasks:
            if t.strip() != task:
                file.write(t)
    tasks = get_tasks(task_path)
    send_email("Task Removed", f"Task removed: {task}\n\nCurrent Tasks:\n{tasks}")

# 获取当前任务列表
def get_tasks(task_path):
    with open(task_path, 'r') as file:
        return file.read()

# 检查路径并发送通知
def check_path_and_notify(path, time_limit):
    if os.path.exists(path):
        send_email("Path Exists", f"The path {path} exists.")
    else:
        time.sleep(time_limit)
        if not os.path.exists(path):
            send_email("Path Not Completed", f"The path {path} was not completed within the specified time.")

# 整理当日任务并发送邮件
def summarize_tasks(task_path):
    tasks = get_tasks(task_path)
    send_email("Daily Task Summary", f"Tasks for today:\n{tasks}")

# 主函数
def main():
    if len(sys.argv) < 2:
        print("Usage: exe <command> [args]")
        return

    command = sys.argv[1]
    task_path = "tasks.txt"  # 默认任务文件路径

    if command == "init":
        if len(sys.argv) < 3:
            print("Usage: exe init <task.path>")
            return
        init_task_file(sys.argv[2])
    elif command == "add":
        if len(sys.argv) < 3:
            print("Usage: exe add <task>")
            return
        add_task(task_path, sys.argv[2])
    elif command == "remove":
        if len(sys.argv) < 3:
            print("Usage: exe remove <task>")
            return
        remove_task(task_path, sys.argv[2])
    elif command == "cat":
        print(get_tasks(task_path))
    elif command == "notify":
        if len(sys.argv) < 4:
            print("Usage: exe notify <path> <time>")
            return
        check_path_and_notify(sys.argv[2], int(sys.argv[3]))
    elif command == "goodnight":
        summarize_tasks(task_path)
    else:
        print("Unknown command")

if __name__ == "__main__":
    main()