# 日志解析工具

这是一个用于解析模型性能测试日志文件的Python脚本，能够从ONNX模型性能测试日志中提取关键信息并汇总到CSV文件中。

## 功能特性

- 自动解析日志文件中的关键信息：
  - 模型名称 (model_name)
  - 批处理大小 (batch_size)
  - 输入形状 (input_shape)
  - 推理速率 (FPS)
  - 最大内存使用量 (MaxMemoryUsageMiB)
  - HCU使用率 (HCU%)
- 支持批量处理日志文件
- 自动检测并跳过重复记录
- 将结果保存到CSV文件以便后续分析
- 提供详细的过程输出和结果预览

## 安装要求

- Python 3.x
- 无需额外依赖包（仅使用Python标准库）

## 使用方法

### 基本用法

```bash
# 删除之前保存的csv
# 解析当前目录下所有.log文件，输出到result.csv
python parse_logs.py

# 解析特定模式的日志文件
python parse_logs.py "*.log"

# 指定输入文件模式和输出CSV文件名
python parse_logs.py "test_*.log" "output.csv"
```

### 参数说明

1. **log_pattern** (可选，默认: `"*.log"`):
   - 用于匹配日志文件的通配符模式
   - 示例: `"resnet*.log"`, `"test_*.txt"`

2. **csv_file** (可选，默认: `"result.csv"`):
   - 输出CSV文件的路径
   - 如果文件已存在，新记录将被追加到文件末尾

### 命令行示例

```bash
# 示例1：解析特定模型的日志文件
python parse_logs.py "./result/*.log" "results.csv"

# 示例2：解析不同格式的日志文件
python parse_logs.py "performance_*.txt" "summary.csv"
```

## 输出格式

脚本将生成一个CSV文件，包含以下列：

| 列名 | 描述 | 示例 |
|------|------|------|
| model_name | 模型名称 | resnet50 |
| batch_size | 批处理大小 | 4 |
| input_shape | 输入形状 | 1 3 224 224 |
| FPS | 每秒推理次数 | x |
| MaxMemoryUsageMiB | 最大内存使用量(MiB) | x |
| HCU% | HCU峰值使用率 | x |



## 注意事项

1. **重复记录检测**: 脚本会自动检测并跳过CSV文件中已存在的相同模型、相同batch size和相同输入形状的记录

2. **排序**: 结果会按模型名称（字母顺序）和batch size（数值大小）升序排序

3. **错误处理**: 如果某个日志文件解析失败，脚本会继续处理其他文件并显示错误信息

4. **编码**: 脚本使用UTF-8编码读取和写入文件，确保支持中文等非ASCII字符

## 故障排除

### 常见问题

1. **"没有找到匹配的日志文件"**
   - 检查当前目录是否正确
   - 确认文件扩展名是否匹配（默认为`.log`）

2. **"解析不完整"警告**
   - 检查日志文件格式是否符合预期
   - 确保日志包含所有必要的信息字段

3. **编码错误**
   - 如果日志文件使用其他编码，可能需要修改脚本中的编码设置
