# all_test.py
#!/usr/bin/env python3
import yaml
import os
import sys

# 添加当前目录到Python路径
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from env import Environment
from scripts.model_runner import ModelRunner

def load_config():
    """加载配置文件"""
    config_file = "config/base.yaml"
    
    if not os.path.exists(config_file):
        print(f"错误: 配置文件不存在: {config_file}")
        sys.exit(1)
    
    with open(config_file, 'r') as f:
        return yaml.safe_load(f)

def main():
    """主函数"""
    
    print("开始运行模型性能测试...")
    
    # 加载配置
    config = load_config()
    
    # 初始化环境
    env = Environment(config)
    
    # 初始化模型运行器
    runner = ModelRunner(config, env)
    
    # 运行所有模型
    runner.run_all_models()

if __name__ == "__main__":
    main()