# 模型性能测试框架

这是一个基于Python的模型性能测试框架，用于在HYGON GPU上使用MIGraphX驱动测试各种深度学习模型的性能。该框架替代了原来的Shell脚本，使用YAML配置文件进行灵活配置。

## 项目结构

```
benchmark/
├── config/                          # 配置文件目录
│   ├── base.yaml                    # 基础配置文件
│   ├── ppocr-v5-rec.yaml           # PPOCR V5识别模型配置
│   ├── yolov3.yaml                 # YOLOv3模型配置
│   ├── inception.yaml              # Inception模型配置
│   └── ...                         # 其他模型配置文件
├── scripts/                         # 核心脚本目录
│   ├── __init__.py                 # Python包文件
│   ├── base_runner.py              # 基础运行器
│   ├── model_runner.py             # 模型运行器
│   └── monitor.py                  # 显存监控器
├── all_test.py                      # 主测试脚本
├── env.py                          # 环境配置
├── requirements.txt                # Python依赖
└── README.md                       # 本文件
```

## 文件说明

### 1. 配置文件 (config/)

#### base.yaml
基础配置文件，包含：
- **通用环境变量**：LD_LIBRARY_PATH等系统路径
- **通用设置**：结果目录、设备ID、MIGraphX驱动路径、迭代次数等
- **监控设置**：监控间隔、日志文件名
- **要运行的模型列表**：指定需要测试的模型
- **日志文件夹路径配置**: 输出的日志文件存放的文件夹路径设置

#### 模型配置文件（如ppocr-v5-rec.yaml）
每个模型对应的配置文件，包含：
- **模型名称**：用于标识模型
- **模型文件路径**：ONNX模型文件位置
- **批次大小列表**：要测试的batch大小
- **输入配置**：输入节点名称和维度
- **环境变量**：模型特定的环境变量
- **额外参数**：传递给MIGraphX驱动的额外参数

### 2. 核心脚本 (scripts/)

#### monitor.py - 显存监控器
负责监控GPU显存使用情况：
- **MemoryMonitor类**：管理显存监控线程
- **功能**：
  - 获取总显存
  - 实时监控显存使用率
  - 记录使用数据到日志文件
  - 计算最大使用量和峰值使用率

#### base_runner.py - 基础运行器
包含通用的模型运行逻辑：
- **BaseRunner类**：所有模型运行器的基类
- **功能**：
  - 构建MIGraphX命令
  - 执行性能测试命令
  - 处理标准输出和错误

#### model_runner.py - 模型运行器
实现具体的模型测试逻辑：
- **ModelRunner类**：继承BaseRunner
- **功能**：
  - 加载模型配置文件
  - 支持单模型文件多批次测试
  - 支持多模型文件（如YOLOv3不同批次有不同文件）
  - 集成显存监控
  - 生成测试结果和统计信息

### 3. 主程序文件

#### env.py - 环境配置
- **Environment类**：管理测试环境
- **功能**：
  - 设置环境变量
  - 创建结果目录
  - 管理设备可见性

#### all_test.py - 主测试脚本
- 程序入口点
- 加载配置文件
- 初始化环境和运行器
- 执行所有模型的测试

## 安装与使用

### 环境要求
- Python 3.7+
- ROCm环境
- MIGraphX驱动

### 安装步骤

1. **克隆或创建项目结构**
```bash
mkdir -p benchmark/{config,scripts}
```

2. **安装Python依赖**
```bash
# 或手动安装
pip install pyyaml
```

3. **准备配置文件**
将示例配置文件放入`config/`目录，并根据实际情况修改：
- 修改`base.yaml`中的路径和设备ID
- 为每个模型创建对应的配置文件

### 运行测试

1. **运行所有模型**
```bash
python all_test.py
```

2. **运行特定模型**
```bash
# 可以直接修改all_test.py中的models_to_run列表
# 或使用命令行参数（需要稍作修改支持）
```

### 配置示例

#### 单个模型文件配置（如PPOCR）
```yaml
# config/ppocr-v5-rec.yaml
model:
  name: "ppocr-v5-rec"
  model_file: "/path/to/ppocr-v5-rec_model.onnx"
  batch_sizes: [1, 8]  # 测试批次大小
  inputs:
    - name: "x"        # 输入节点名称
      shape: [3, 48, 320]  # 输入维度（批次大小会自动插入）
  env_vars:
    MIGRAPHX_ENABLE_NHWC: 1  # 模型特定环境变量
```

#### 多个模型文件配置（如YOLOv3）
```yaml
# config/yolov3.yaml
model:
  name: "yolov3"
  model_files:          # 多个模型文件
    - path: "../models/yolov3/yolov3.onnx"
      batch: 1
    - path: "../models/yolov3/yolov3_b8.onnx"
      batch: 8
  inputs:
    - name: "input"
      shape: [3, 416, 416]
  env_vars:
    MIGRAPHX_ENABLE_NHWC: 1
```

## 输出结果

测试结果保存在`result_dir`指定的目录中（默认为`../result-v1`），每个测试生成的文件包括：

1. **性能日志文件**：`{模型名}-{批次大小}batch.log`
   - MIGraphX驱动的输出
   - 性能统计信息
   - 显存使用统计

2. **显存监控日志**：`memory_simple.log`
   - 实时显存使用记录

## 添加新模型

要添加新模型测试，只需以下步骤：

1. **创建配置文件**
在`config/`目录下创建`{模型名}.yaml`文件

2. **配置模型参数**
参考现有配置文件设置：
- 模型文件路径
- 测试批次大小
- 输入节点配置

3. **添加到运行列表**
在`base.yaml`的`models_to_run`中添加模型名称

## 注意事项

1. **环境要求**：
   - 确保ROCm和MIGraphX已正确安装
   - 确认模型文件路径正确
   - 检查GPU设备ID是否可用

2. **权限要求**：
   - 需要访问GPU的权限
   - 需要有模型文件的读取权限

3. **监控功能**：
   - 监控依赖于`hy-smi`命令
   - 确保监控间隔设置合理（默认1秒）

4. **错误处理**：
   - 模型文件不存在时会跳过测试
   - 命令执行失败会记录错误信息
   - 监控异常不会中断主测试

## 从Shell脚本迁移

### 主要改进

1. **配置管理**：从Shell变量改为YAML文件
2. **代码复用**：统一命令构建逻辑
3. **错误处理**：更好的异常捕获和处理
4. **线程安全**：独立的监控线程
5. **类型安全**：Python类型提示

### 对应关系

| Shell脚本部分 | Python对应部分 |
|--------------|---------------|
| env.sh配置 | config/base.yaml + env.py |
| 模型特定配置 | config/{模型名}.yaml |
| 监控脚本 | scripts/monitor.py |
| migraphx-driver调用 | base_runner.py中build_command方法 |
| 循环测试批次 | model_runner.py中run方法 |

## 故障排除

### 常见问题

1. **找不到模型文件**
   - 检查配置文件中的路径
   - 确认文件是否存在且可读

2. **监控失败**
   - 检查`hy-smi`命令是否可用
   - 确认设备ID正确

3. **权限问题**
   - 确保有运行MIGraphX驱动的权限
   - 检查结果目录的写入权限

### 调试方法

1. **增加日志输出**
   修改配置文件或代码中的日志级别

2. **单独运行命令**
   手动运行生成的MIGraphX命令进行调试

3. **检查环境变量**
   使用`printenv`确认环境变量已正确设置

## 扩展功能

框架支持以下扩展：

1. **自定义监控指标**：扩展Monitor类添加更多监控项
2. **性能数据解析**：添加结果解析和汇总功能
3. **自动化报告**：生成HTML或PDF测试报告
4. **批量测试**：支持跨多个设备的并行测试

---

如有问题或建议，请参考代码注释或创建Issue。
