#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
#include <pybind11/numpy.h>
#include "roctracer_wrapper.h"

namespace py = pybind11;

PYBIND11_MODULE(roctracer_py, m) {
    m.doc() = "Python bindings for ROCtracer with HIP support";
    
    py::class_<RoctracerWrapper>(m, "RoctracerWrapper")
        .def(py::init<>())
        .def("mark", &RoctracerWrapper::mark, "Add a marker to the trace")
        .def("range_start", &RoctracerWrapper::rangeStart, "Start a range")
        .def("range_push", &RoctracerWrapper::rangePush, "Push a range")
        .def("range_pop", &RoctracerWrapper::rangePop, "Pop a range")
        .def("range_stop", &RoctracerWrapper::rangeStop, "Stop a range")
        ;
    
}