#!/usr/bin/env bash
# Set bash to 'debug' mode, it will exit on :
# -e 'error', -u 'undefined variable', -o ... 'error in pipeline', -x 'print commands',
set -e
set -u
set -o pipefail
export HIP_PRINTF_DEBUG_FOR_FP64=0
export MIOPEN_FIND_MODE=3
export HSA_FORCE_FINE_GRAIN_PCIE=1

train_set=train
valid_set=dev
test_sets="dev test"
test_sets="test"
asr_config=conf/tuning/train_asr_conformer.yaml
inference_config=conf/decode_asr_rnn.yaml

lm_config=conf/tuning/train_lm_transformer.yaml
use_lm=true
use_wordlm=false

# speed perturbation related
# (train_set will be "${train_set}_sp" if speed_perturb_factors is specified)
speed_perturb_factors="0.9 1.0 1.1"
export HIP_VISIBLE_DEVICES=7
nohup ./asr_inference7.sh \
    --batch_size 24 \
    --nj 32 \
    --inference_nj 16 \
    --ngpu 1 \
    --lang zh \
    --audio_format "flac.ark" \
    --feats_type raw \
    --token_type char \
    --use_lm ${use_lm}                                 \
    --use_word_lm ${use_wordlm}                        \
    --lm_config "${lm_config}"                         \
    --asr_config "${asr_config}"                       \
    --inference_config "${inference_config}"           \
    --train_set "${train_set}"                         \
    --valid_set "${valid_set}"                         \
    --test_sets "${test_sets}"                         \
    --speed_perturb_factors "${speed_perturb_factors}" \
    --asr_speech_fold_length 512 \
    --asr_text_fold_length 150 \
    --lm_fold_length 150 \
    --lm_train_text "data/${train_set}/text" "$@" 2>&1 | tee inference7_dcu_`date +%Y%m%d%H%M%S`.log &
